﻿var BARS = 20;  // The number of bars to display
var CLASS = "Progress"; // Style class name when bar is off
var CLASS_ON_SUFFIX = "On";  // Suffix to append to style class name when bar is on
var SPEED = 200; // Delay in milliseconds for animation

var ELEMENT_ID_PREFIX = "Progress_"; // ID prefix for progress bar elements
var current = 0; // Last rendered progress bar element
var timeOut;


function createAnimation() {
    // Create the progress bar
    var progress = document.getElementById("Progress");
    for (var p = 0; p < BARS; p++) {
        var pDiv = document.createElement("div");
        pDiv.innerHTML = "&nbsp;&nbsp;";
        pDiv.className = CLASS;
        pDiv.id = "Progress_" + p;
        progress.appendChild(pDiv);
    }

    // Start the animation
    animate();
}

function animate() {
    var progressObj = document.getElementById(ELEMENT_ID_PREFIX + current);
    progressObj.className = CLASS + (progressObj.className == CLASS ? CLASS_ON_SUFFIX : "");

    current++;
    if (current == BARS)
        current = 0;

    timeOut = window.setTimeout("animate()", SPEED);
}

function stopAnimation() {
    window.clearTimeout(timeOut);
}