﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using System.Xml;
using System.Text.RegularExpressions;
using System.Xml.Linq;

namespace SpaceBuilder.Web.upgrade
{
    /// <summary>
    /// 所有升级页面基类
    /// </summary>
    public class UpgradePageBase : System.Web.UI.Page
    {

        //执行sql脚本
        protected void ExecuteInFile(SqlConnection sqlCon, string pathToScriptFile)
        {
            string sqlString = string.Empty;
            StreamReader reader = null;
            if (!System.IO.File.Exists(pathToScriptFile))
            {
                throw new Exception("文件" + pathToScriptFile + " 未找到!");
            }
            Stream stream = System.IO.File.OpenRead(pathToScriptFile);
            reader = new StreamReader(stream, Encoding.UTF8);
            sqlString = reader.ReadToEnd();
            reader.Close();
            reader.Dispose();

            SqlCommand command = new SqlCommand(sqlString, sqlCon);
            command.CommandType = System.Data.CommandType.Text;

            System.Collections.ArrayList al = new System.Collections.ArrayList();
            Regex reg = new Regex(@"^(\s*)GO(\s*)$", RegexOptions.IgnoreCase | RegexOptions.Multiline | RegexOptions.Compiled | RegexOptions.ExplicitCapture);

            string[] sqls = reg.Split(sqlString);
            sqlCon.Open();
            foreach (string _sql in sqls)
            {
                if (!string.IsNullOrEmpty(_sql))
                {
                    command.CommandText = _sql;
                    try
                    {
                        command.ExecuteNonQuery();
                    }
                    catch
                    {
                        continue;
                    }
                }
            }
            sqlCon.Close();
        }

        private SqlConnection writableConnection = null;
        /// <summary>
        /// 获取v3.0下的数据库写连接
        /// </summary>
        public SqlConnection WritableConnection
        {
            get
            {
                if (writableConnection == null)
                {
                    string connectionString = string.Empty;
                    connectionString = ConfigurationManager.ConnectionStrings["writableConnection"].ConnectionString;
                    if (!string.IsNullOrEmpty(connectionString))
                        try
                        {
                            writableConnection = new SqlConnection(connectionString);
                        }
                        catch { }
                }

                return writableConnection;
            }
        }


        private SqlConnection readOnlyConnection = null;
        /// <summary>
        /// 获取v3.0下的数据库读连接
        /// </summary>
        public SqlConnection ReadOnlyConnection
        {
            get
            {
                if (readOnlyConnection == null)
                {
                    string connectionString = string.Empty;
                    connectionString = ConfigurationManager.ConnectionStrings["readOnlyConnection"].ConnectionString;
                    try
                    {
                        readOnlyConnection = new SqlConnection(connectionString);
                    }
                    catch { }

                }
                return readOnlyConnection;
            }
        }
    }
}
