﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

namespace SpaceBuilder.Web.upgrade
{
    public partial class check : UpgradePageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                ReadOnlyConnection.Open();
                ReadOnlyConnection.Close();

                WritableConnection.Open();
                WritableConnection.Close();

                ConnectionLi.Attributes["class"] = "detectionHit";
                ConnectionExamine.Text = "数据库库连接检测成功";
            }
            catch
            {
                ConnectionLi.Attributes["class"] = "detectionError";
                ConnectionExamine.Text = "数据库库连接检测失败，请检查web.config 中的readOnlyConnection与writableConnection 数据库连接字符串是否正确";
                ReCheckButton.Visible = true;
                return;
            }

            if (CheckFolderWriteable(Server.MapPath("~/Uploads")))
            {
                UploadsLi.Attributes["class"] = "detectionHit";
                UploadsExamine.Text = "Web/Uploads文件夹检测成功";
            }
            else
            {
                UploadsLi.Attributes["class"] = "detectionError";
                UploadsExamine.Text = "Web/Uploads文件夹检测失败";
                ReCheckButton.Visible = true;
                return;
            }
            if (CheckFolderWriteable(Server.MapPath("~/Logs")))
            {
                LogsLi.Attributes["class"] = "detectionHit";
                LogsExamine.Text = "Web/Logs文件夹检测成功";
            }
            else
            {
                LogsLi.Attributes["class"] = "detectionError";
                LogsExamine.Text = "Web/Logs文件夹检测失败";
                ReCheckButton.Visible = true;
                return;
            }

            NextButton.Visible = true;
            ReCheckButton.Visible = false;
        }


        bool CheckFolderWriteable(string path)
        {
            if (Directory.Exists(path) == false)
            {
                Directory.CreateDirectory(Server.MapPath(path));
                return true;
            }
            else
            {
                try
                {
                    string testFilePath = string.Format("{0}/test{1}{2}{3}{4}.txt", path, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second, DateTime.Now.Millisecond);
                    FileStream testFile = System.IO.File.Create(testFilePath);
                    testFile.WriteByte(Convert.ToByte(true));
                    testFile.Close();
                    System.IO.File.Delete(testFilePath);
                    return true;
                }
                catch
                {
                    return false;
                }
            }
        }

    }
}
