using System;
using System.Text;
using System.Text.RegularExpressions;

using Discuz.Data;
using Discuz.Entity;
using Discuz.Config;
using Discuz.Common;
using Discuz.Common.Generic;

namespace Discuz.Forum
{
    public class Debates
    {
        /// <summary>
        /// ȡӹ۵
        /// </summary>
        /// <param name="tid">ID</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<int, int> GetPostDebateList(int tid)
        {
            if (tid <= 0)
                return null;

            return Discuz.Data.Debates.GetPostDebateList(tid);
        }

        /// <summary>
        /// ȡ۵չϢ
        /// </summary>
        /// <param name="tid">ID</param>
        /// <returns>չϢ</returns>
        public static DebateInfo GetDebateTopic(int tid)
        {
            if (tid <= 0)
                return null;

            return Discuz.Data.Debates.GetDebateTopic(tid);
        }

        /// <summary>
        /// ±Ϣ
        /// </summary>
        /// <param name="debateInfo">Ϣ</param>
        /// <returns></returns>
        public static bool UpdateDebateTopic(DebateInfo debateInfo)
        {
            if (debateInfo.Tid <= 0)
                return false;
            return Discuz.Data.Debates.UpdateDebateTopic(debateInfo);
        }

        /// <summary>
        /// صõJSON
        /// </summary>
        /// <param name="callback">JSص</param>
        /// <param name="tidlist">IDб</param>
        /// <returns>JS</returns>
        public static string GetDebatesJsonList(string callback, string tidlist)
        {
            switch (callback)
            {
                //ȡϢ
                case "gethotdebatetopic":
                    {
                        string[] debatesrule = Utils.StrIsNullOrEmpty(tidlist) ? new string[0] : tidlist.Split(',');

                        if (debatesrule.Length < 3)
                            break;
                        else if (debatesrule[0] != "views" && debatesrule[0] != "replies" && Utils.IsNumeric(debatesrule[1]) && Utils.IsNumeric(debatesrule[2]))
                            break;

                        return Discuz.Data.Debates.GetDebatesJsonList(callback, debatesrule[0], TypeConverter.StrToInt(debatesrule[1]), TypeConverter.StrToInt(debatesrule[2]));
                    }

                //ȡƼϢ
                case "recommenddebates":
                    {
                        if (!Utils.IsNumericList(tidlist))
                            break;

                        if (Utils.StrIsNullOrEmpty(tidlist))
                            tidlist = GeneralConfigs.GetConfig().Recommenddebates;

                        return Discuz.Data.Debates.GetRecommendDebates(callback, tidlist);
                    }

                default:
                    break;
            }
            return "0";
        }
        /// <summary>
        /// ӵ
        /// </summary>
        /// <param name="tid">ID</param>
        /// <param name="message"></param>
        public static StringBuilder CommentDabetas(int tid, string message, bool ispost)
        {
            StringBuilder xmlnode = IsValidDebates(tid, message, ispost);
            if (!xmlnode.ToString().Contains("<error>"))
            {
                xmlnode.Append("<message>" + message + "</message>");
                Discuz.Data.Debates.CommentDabetas(tid, TypeConverter.ObjectToInt(Data.PostTables.GetPostTableId(tid)), Utils.HtmlEncode(ForumUtils.BanWordFilter(message)));
            }
            return xmlnode;
        }

        private static StringBuilder IsValidDebates(int tid, string message, bool ispost)
        {
            StringBuilder xmlnode = new StringBuilder();
            xmlnode.Append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            if (!ispost || ForumUtils.IsCrossSitePost())
            {
                xmlnode.Append("<error>·ȷ޷ύװĳĬ·Ϣĸ˷ǽ( Norton Internet Security)䲻Ҫֹ·Ϣԡ</error>");
                return xmlnode;
            }

            Regex r = new Regex(@"\[area=([\s\S]+?)\]([\s\S]+?)\[/area\]", RegexOptions.Singleline | RegexOptions.IgnoreCase);
            MatchCollection m = r.Matches(message);
            if (m.Count == 0)
            {
                xmlnode.Append("<error>ݲΪ</error>");
                return xmlnode;
            }

            TopicInfo topicinfo = Topics.GetTopicInfo(tid);
            if (tid == 0 || topicinfo.Special != 4)
            {
                xmlnode.Append("<error>ⲻǱ޷</error>");
                return xmlnode;
            }
            if (Debates.GetDebateTopic(tid).Terminaltime > DateTime.Now)
            {
                xmlnode.Append("<error>ʱδ޷</error>");
                return xmlnode;
            }
            return xmlnode;
        }


        /// <summary>
        /// ֤ûǷ
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <param name="tips">ʾϢ</param>
        /// <returns>ǷԶ</returns>
        public static bool AllowDiggs(int userid)
        {
            //жοǷԶ
            if (UserGroups.GetUserGroupInfo(7).Allowdiggs == 0 && userid == -1)
                return false;

            //жϵǰûǷԶ
            UserGroupInfo usergroupinfo = UserGroups.GetUserGroupInfo(Discuz.Data.Users.GetUserInfo(userid).Groupid);
            if (usergroupinfo.Allowdiggs == 0)
                return false;

            return true;
        }


        /// <summary>
        /// Digg
        /// </summary>
        /// <param name="tid">id</param>
        /// <param name="pid">ID</param>
        /// <param name="type">۵</param>
        /// <param name="userid">ûID</param>
        public static void AddDebateDigg(int tid, int pid, int type, int userid)
        {
            if (userid < 0)
                return;

            UserInfo userinfo = Discuz.Data.Users.GetUserInfo(userid);
            if (userinfo == null)
                return;

            Discuz.Data.Debates.AddDebateDigg(tid, pid, type, Utils.GetRealIP(), userinfo);
        }

        /// <summary>
        /// жǷ񶥹
        /// </summary>
        /// <param name="pid">ID</param>
        /// <param name="userid">ûID</param>
        /// <returns>жǷ񶥹</returns>
        public static bool IsDigged(int pid, int userid)
        {
            //οͺ֤ʽΪɢ֤,24Сʱֻܶһ
            if (UserGroups.GetUserGroupInfo(7).Allowdiggs != 1)
                return !DatabaseProvider.GetInstance().AllowDiggs(pid, userid);
            else
            {
                if (Utils.StrIsNullOrEmpty(Utils.GetCookie("debatedigged")))
                    return false;

                foreach (string s in Utils.GetCookie("debatedigged").Split(','))
                {
                    if (pid == Utils.StrToInt(s, 0))
                        return true;
                }
            }
            return false;
        }

        /// <summary>
        /// дѶCOOKIES
        /// </summary>
        /// <param name="pid">ID</param>
        public static void WriteCookies(int pid)
        {
            if (Utils.StrIsNullOrEmpty((Utils.GetCookie("debatedigged"))))
                Utils.WriteCookie("debatedigged", pid.ToString(), 1440);
            else
                Utils.WriteCookie("debatedigged", Utils.GetCookie("debatedigged") + "," + pid, 1440);
        }

        /// <summary>
        /// رһ
        /// </summary>
        /// <param name="postpramsInfo">ӵĸϢ</param>
        /// <param name="debateOpinion">ӹ۵</param>
        /// <returns></returns>
        public static int GetDebatesPostCount(PostpramsInfo postpramsInfo, int debateOpinion)
        {
            return Discuz.Data.Debates.GetDebatesPostCount(postpramsInfo.Tid, debateOpinion);
        }

        /// <summary>
        /// ȡб
        /// </summary>
        /// <param name="postpramsInfo">ӵĸϢ</param>
        /// <param name="attachmentlist">б</param>
        /// <param name="ismoder">ǷйȨ</param>
        /// <returns>б</returns>
        public static List<ShowtopicPagePostInfo> GetPositivePostList(PostpramsInfo postpramsInfo, out List<ShowtopicPageAttachmentInfo> attachmentlist, bool ismoder)
        {
            return GetDebatePostList(postpramsInfo, out attachmentlist, ismoder, 1, new PostOrderType());
        }

        private static List<ShowtopicPagePostInfo> GetDebatePostList(PostpramsInfo postpramsInfo, out List<ShowtopicPageAttachmentInfo> attachList, 
            bool isModer, int debateOpinion, PostOrderType postOrderType)
        {
            List<ShowtopicPagePostInfo> postList = new List<ShowtopicPagePostInfo>();
            attachList = new List<ShowtopicPageAttachmentInfo>();
            StringBuilder attachmentpidlist = new StringBuilder();
            StringBuilder pidList = new StringBuilder();
            postList = Data.Debates.GetDebatePostList(postpramsInfo, debateOpinion, postOrderType);

            //ֶβ׼δȡ÷ҳϢʱֶΣȡһҳ
            if (postList.Count == 0 && postpramsInfo.Pageindex > 1)
            {
                int postcount = Data.Debates.GetRealDebatePostCount(postpramsInfo.Tid, debateOpinion);

                postpramsInfo.Pageindex = postcount % postpramsInfo.Pagesize == 0 ? postcount / postpramsInfo.Pagesize : postcount / postpramsInfo.Pagesize + 1;

                postList = Data.Debates.GetDebatePostList(postpramsInfo, debateOpinion, postOrderType);
            }

            StringBuilder attachPidList = new StringBuilder();

            foreach (ShowtopicPagePostInfo post in postList)
            {
                pidList.AppendFormat("{0},", post.Pid);
                if (post.Attachment > 0)
                    attachPidList.AppendFormat("{0},", post.Pid);
            }

            attachList = Attachments.GetAttachmentList(postpramsInfo, attachPidList.ToString().TrimEnd(','));

            Dictionary<int, int> postdiggs = GetPostDiggs(pidList.ToString().Trim(','));
            foreach (ShowtopicPagePostInfo post in postList)
            {
                if (postdiggs.ContainsKey(post.Pid))
                    post.Diggs = postdiggs[post.Pid];
            }

            Posts.ParsePostListExtraInfo(postpramsInfo, attachList, isModer, postList);

            return postList;
        }
        /// <summary>
        /// ӱ
        /// </summary>
        /// <param name="pidlist">ID</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<int, int> GetPostDiggs(string pidlist)
        {
            if (!Utils.IsNumericList(pidlist))
                return new Dictionary<int, int>();

            return Discuz.Data.Debates.GetPostDiggs(pidlist);
        }

        /// <summary>
        /// б
        /// </summary>
        /// <param name="postpramsInfo">ӵĸϢ</param>
        /// <param name="attachmentlist">б</param>
        /// <param name="ismoder">ǷйȨ</param>
        /// <returns>б</returns>
        public static List<ShowtopicPagePostInfo> GetNegativePostList(PostpramsInfo postpramsInfo, out List<ShowtopicPageAttachmentInfo> attachmentlist, bool ismoder)
        {
            return GetDebatePostList(postpramsInfo, out attachmentlist, ismoder, 2, new PostOrderType());
        }
     

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="tid">Id</param>
        /// <param name="opinion">ֶΣ1 2</param>
        /// <param name="pid">Id</param>
        public static void DeleteDebatePost(int tid, int opinion, int pid)
        {
            switch (opinion)
            {
                case 1: Discuz.Data.Debates.DeleteDebatePost(tid, "positivediggs", pid); break;
                case 2: Discuz.Data.Debates.DeleteDebatePost(tid, "negativediggs", pid); break;
            }
        }
    }
}
