using System;
using System.Data;

using Discuz.Common;
using Discuz.Data;
using Discuz.Config;
using Discuz.Entity;

namespace Discuz.Forum
{
	/// <summary>
	/// ղؼв
	/// </summary>
	public class Favorites
	{
		/// <summary>
		/// ղϢ
		/// </summary>
		/// <param name="uid">ûID</param>
		/// <param name="tid">ID</param>
		/// <returns>ɹ 1 򷵻 0</returns>	
		public static int CreateFavorites(int uid,int tid)
		{
            if (uid < 0)
                return 0;

            return CreateFavorites(uid, tid, FavoriteType.ForumTopic);
		}

        /// <summary>
        /// ղϢ
        /// </summary>
        /// <param name="uid">ûID</param>
        /// <param name="tid">ID</param>
        /// <param name="type">ղ</param>
        /// <returns>ɹ 1 򷵻 0</returns>	
        public static int CreateFavorites(int uid, int tid, FavoriteType type)
        {
            return Discuz.Data.Favorites.CreateFavorites(uid, tid, (byte)type);
        }
	
		/// <summary>
		/// ɾָûղϢ
		/// </summary>
		/// <param name="uid">ûid</param>
		/// <param name="fitemid">ҪɾղϢidб</param>
        /// <param name="type">ղ</param>
		/// <returns>ɾʱ -1</returns>
        public static int DeleteFavorites(int uid, string[] fitemid, FavoriteType type)
		{
			foreach (string id in fitemid)
			{
				if (!Utils.IsNumeric(id))
					return -1;
			}

            return Discuz.Data.Favorites.DeleteFavorites(uid, String.Join(",",fitemid), (byte)type);
		}

		       
		/// <summary>
		/// õûղϢб
		/// </summary>
		/// <param name="uid">ûid</param>
		/// <param name="pagesize">ҳʱÿҳļ¼</param>
		/// <param name="pageindex">ǰҳ</param>
		/// <param name="type">ղid</param>
		/// <returns>ûϢб</returns>
        public static DataTable GetFavoritesList(int uid, int pagesize, int pageindex, FavoriteType type)
        {
            return Discuz.Data.Favorites.GetFavoritesList(uid, pagesize, pageindex, (int)type);
        }


        /// <summary>
        /// õûղص
        /// </summary>
        /// <param name="uid">ûid</param>
        /// <returns>ղ</returns>
        public static int GetFavoritesCount(int uid, FavoriteType type)
        {
            return uid > 0 ? Discuz.Data.Favorites.GetFavoritesCount(uid, (int)type) : 0;
        }


		/// <summary>
		/// ղؼǷָ
		/// </summary>
		/// <param name="uid">ûid</param>
		/// <param name="tid">Id</param>
        /// <param name="type">: , ־, </param>
		/// <returns></returns>
		public static int CheckFavoritesIsIN(int uid,int tid, FavoriteType type)
		{
            return Discuz.Data.Favorites.CheckFavoritesIsIN(uid, tid, (byte)type);	
        }

        /// <summary>
        /// ûղĿĲ鿴ʱ
        /// </summary>
        /// <param name="uid">ûid</param>
        /// <param name="tid">id</param>
        /// <returns></returns>
        public static int UpdateUserFavoriteViewTime(int uid, int tid)
        {
            return Discuz.Data.Favorites.UpdateUserFavoriteViewTime(uid, tid);
        }
	}//class end
}
