using System;
using System.Web;
using System.Data;
using System.Collections.Generic;

using Discuz.Common;
using Discuz.Data;
using Discuz.Config;
using Discuz.Entity;
using Discuz.Common.Generic;

namespace Discuz.Forum
{
    /// <summary>
    /// û
    /// </summary>
    public class OnlineUsers
    {
        private static object SynObject = new object();

        /// <summary>
        /// û
        /// </summary>
        /// <returns>û</returns>
        public static int GetOnlineAllUserCount()
        {
            int onlineUserCountCacheMinute = GeneralConfigs.GetConfig().OnlineUserCountCacheMinute;
            if (onlineUserCountCacheMinute == 0)
                return Discuz.Data.OnlineUsers.GetOnlineAllUserCount();

            Discuz.Cache.DNTCache cache = Discuz.Cache.DNTCache.GetCacheService();
            int onlineAllUserCount = TypeConverter.ObjectToInt(cache.RetrieveObject("/Forum/OnlineUserCount"));
            if (onlineAllUserCount != 0)
                return onlineAllUserCount;

            onlineAllUserCount = Discuz.Data.OnlineUsers.GetOnlineAllUserCount();
            //Discuz.Cache.ICacheStrategy ics = new RssCacheStrategy();
            //ics.TimeOut = onlineUserCountCacheMinute * 60;
            //cache.LoadCacheStrategy(ics);
            cache.AddObject("/Forum/OnlineUserCount", onlineAllUserCount, onlineUserCountCacheMinute * 60);
            //cache.LoadDefaultCacheStrategy();
            return onlineAllUserCount;
        }

        /// <summary>
        /// ػû
        /// </summary>
        /// <returns>û</returns>
        public static int GetCacheOnlineAllUserCount()
        {
            int count = TypeConverter.StrToInt(Utils.GetCookie("onlineusercount"), 0);
            if (count == 0)
            {
                count = OnlineUsers.GetOnlineAllUserCount();
                Utils.WriteCookie("onlineusercount", count.ToString(), 3);
            }
            return count;
        }

        /// <summary>
        /// ֮ǰ߱¼(Ӧóʼʱ)
        /// </summary>
        /// <returns></returns>
        public static int InitOnlineList()
        {
            return Discuz.Data.OnlineUsers.CreateOnlineTable();
        }

        /// <summary>
        /// λ߱, ϵͳδ, Ӧó, 򲻻´
        /// </summary>
        /// <returns></returns>
        public static int ResetOnlineList()
        {
            try
            {

                // ϵͳʱС10
                if (System.Environment.TickCount < 600000 && System.Environment.TickCount > 0)
                    return Discuz.Data.OnlineUsers.CreateOnlineTable();

                return -1;
            }
            catch
            {
                try
                {
                    return Discuz.Data.OnlineUsers.CreateOnlineTable();
                }
                catch
                {
                    return -1;
                }
            }
        }

        /// <summary>
        /// עû
        /// </summary>
        /// <returns>û</returns>
        public static int GetOnlineUserCount()
        {
            return Discuz.Data.OnlineUsers.GetOnlineUserCount();
        }

        #region ݲͬѯûϢ


        /// <summary>
        /// ûб
        /// </summary>
        /// <param name="totaluser">ȫû</param>
        /// <param name="guest">ο</param>
        /// <param name="user">¼û</param>
        /// <param name="invisibleuser">Ա</param>
        /// <returns>ûб</returns>
        public static DataTable GetOnlineUserList(int totaluser, out int guest, out int user, out int invisibleuser)
        {
            DataTable dt = Discuz.Data.OnlineUsers.GetOnlineUserListTable();
            int highestonlineusercount = TypeConverter.StrToInt(Statistics.GetStatisticsRowItem("highestonlineusercount"), 1);

            if (totaluser > highestonlineusercount)
            {
                if (Statistics.UpdateStatistics("highestonlineusercount", totaluser.ToString()) > 0)
                {
                    Statistics.UpdateStatistics("highestonlineusertime", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    Statistics.ReSetStatisticsCache();
                }
            }
            // ͳû
            //DataRow[] dr = dt.Select("userid>0");
            user = Discuz.Data.OnlineUsers.GetOnlineUserCount();// dr == null ? 0 : dr.Length;

            //ͳû
            if (EntLibConfigs.GetConfig() != null && EntLibConfigs.GetConfig().Cacheonlineuser.Enable)
                invisibleuser = Discuz.Data.OnlineUsers.GetInvisibleOnlineUserCount();
            else
            {
                DataRow[] dr = dt.Select("invisible=1");
                invisibleuser = dr == null ? 0 : dr.Length;
            }
            //ͳο
            guest = totaluser > user ? totaluser - user : 0;

            //صǰû
            return dt;
        }
        #endregion


        /// <summary>
        /// ûͼ
        /// </summary>
        /// <returns>ûͼ</returns>
        private static DataTable GetOnlineGroupIconTable()
        {
            lock (SynObject)
            {
                Discuz.Cache.DNTCache cache = Discuz.Cache.DNTCache.GetCacheService();
                DataTable dt = cache.RetrieveObject("/Forum/OnlineIconTable") as DataTable;

                if (dt == null)
                {
                    dt = Discuz.Data.OnlineUsers.GetOnlineGroupIconTable();
                    cache.AddObject("/Forum/OnlineIconTable", dt);
                }
                return dt;
            }
        }

        /// <summary>
        /// ûͼ
        /// </summary>
        /// <param name="groupid">û</param>
        /// <returns>ûͼ</returns>
        public static string GetGroupImg(int groupid)
        {
            string img = "";
            DataTable dt = GetOnlineGroupIconTable();
            // ûҪʾͼ򷵻""
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    // ͼͳʼΪ:ͨû
                    // ƥΪƥͼ
                    if ((int.Parse(dr["groupid"].ToString()) == 0 && img == "") || (int.Parse(dr["groupid"].ToString()) == groupid))
                    {
                        img = "<img src=\"" + BaseConfigs.GetForumPath + "images/groupicons/" + dr["img"].ToString() + "\" />";
                    }
                }
            }
            return img;
        }

        #region 鿴ָĳһûϸϢ
        public static OnlineUserInfo GetOnlineUser(int olid)
        {
            return Discuz.Data.OnlineUsers.GetOnlineUser(olid);
        }

        /// <summary>
        /// ָûϸϢ
        /// </summary>
        /// <param name="userid">ûID</param>
        /// <param name="password">û</param>
        /// <returns>ûϸϢ</returns>
        private static OnlineUserInfo GetOnlineUser(int userid, string password)
        {
            return Discuz.Data.OnlineUsers.GetOnlineUser(userid, password);
        }

        /// <summary>
        /// ָûϸϢ
        /// </summary>
        /// <returns>ûϸϢ</returns>
        private static OnlineUserInfo GetOnlineUserByIP(int userid, string ip)
        {
            return Discuz.Data.OnlineUsers.GetOnlineUserByIP(userid, ip);
        }

        /// <summary>
        /// û֤ǷЧ
        /// </summary>
        /// <param name="olid">ûID</param>
        /// <param name="verifycode">֤</param>
        /// <returns>ûID</returns>
        public static bool CheckUserVerifyCode(int olid, string verifycode)
        {
            return Discuz.Data.OnlineUsers.CheckUserVerifyCode(olid, verifycode, ForumUtils.CreateAuthStr(5, false));
        }

        #endregion

        #region µû

        /// <summary>
        /// CookieûûIDĵûIDЧʱ߱һο.
        /// </summary>
        public static OnlineUserInfo CreateGuestUser(int timeout)
        {
            OnlineUserInfo onlineuserinfo = new OnlineUserInfo();

            onlineuserinfo.Userid = -1;
            onlineuserinfo.Username = "ο";
            onlineuserinfo.Nickname = "ο";
            onlineuserinfo.Password = "";
            onlineuserinfo.Groupid = 7;
            onlineuserinfo.Olimg = GetGroupImg(7);
            onlineuserinfo.Adminid = 0;
            onlineuserinfo.Invisible = 0;
            onlineuserinfo.Ip = DNTRequest.GetIP();
            onlineuserinfo.Lastposttime = "1900-1-1 00:00:00";
            onlineuserinfo.Lastpostpmtime = "1900-1-1 00:00:00";
            onlineuserinfo.Lastsearchtime = "1900-1-1 00:00:00";
            onlineuserinfo.Lastupdatetime = Utils.GetDateTime();
            onlineuserinfo.Action = 0;
            onlineuserinfo.Lastactivity = 0;
            onlineuserinfo.Verifycode = ForumUtils.CreateAuthStr(5, false);
            onlineuserinfo.Olid = Discuz.Data.OnlineUsers.CreateOnlineUserInfo(onlineuserinfo, timeout);

            return onlineuserinfo;
        }


        /// <summary>
        /// һԱϢбСûlogin.aspxûϢʱ,ûߵûб
        /// </summary>
        /// <param name="uid"></param>
        private static OnlineUserInfo CreateUser(int uid, int timeout)
        {
            OnlineUserInfo onlineuserinfo = new OnlineUserInfo();
            if (uid > 0)
            {
                ShortUserInfo ui = Users.GetShortUserInfo(uid);
                if (ui != null)
                {
                    onlineuserinfo.Userid = uid;
                    onlineuserinfo.Username = ui.Username.Trim();
                    onlineuserinfo.Nickname = ui.Nickname.Trim();
                    onlineuserinfo.Password = ui.Password.Trim();
                    onlineuserinfo.Groupid = short.Parse(ui.Groupid.ToString());
                    onlineuserinfo.Olimg = GetGroupImg(short.Parse(ui.Groupid.ToString()));
                    onlineuserinfo.Adminid = short.Parse(ui.Adminid.ToString());
                    onlineuserinfo.Invisible = short.Parse(ui.Invisible.ToString());
                    onlineuserinfo.Ip = DNTRequest.GetIP();
                    onlineuserinfo.Lastposttime = "1900-1-1 00:00:00";
                    onlineuserinfo.Lastpostpmtime = "1900-1-1 00:00:00";
                    onlineuserinfo.Lastsearchtime = "1900-1-1 00:00:00";
                    onlineuserinfo.Lastupdatetime = Utils.GetDateTime();
                    onlineuserinfo.Action = 0;
                    onlineuserinfo.Lastactivity = 0;
                    onlineuserinfo.Verifycode = ForumUtils.CreateAuthStr(5, false);

                    int newPms = PrivateMessages.GetPrivateMessageCount(uid, 0, 1);
                    int newNotices = Notices.GetNewNoticeCountByUid(uid);
                    onlineuserinfo.Newpms = short.Parse(newPms > 1000 ? "1000" : newPms.ToString());
                    onlineuserinfo.Newnotices = short.Parse(newNotices > 1000 ? "1000" : newNotices.ToString());
                    //onlineuserinfo.Newfriendrequest = short.Parse(Friendship.GetUserFriendRequestCount(uid).ToString());
                    //onlineuserinfo.Newapprequest = short.Parse(ManyouApplications.GetApplicationInviteCount(uid).ToString());
                    onlineuserinfo.Olid = Discuz.Data.OnlineUsers.CreateOnlineUserInfo(onlineuserinfo, timeout);


                    //Ա͹ע֪ͨ
                    if (ui.Adminid > 0 && ui.Adminid < 4)
                    {
                        if (Discuz.Data.Notices.ReNewNotice((int)NoticeType.AttentionNotice, ui.Uid) == 0)
                        {
                            NoticeInfo ni = new NoticeInfo();
                            ni.New = 1;
                            ni.Note = "뼰ʱ鿴<a href=\"modcp.aspx?operation=attention&forumid=0\">Ҫע</a>";
                            ni.Postdatetime = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                            ni.Type = NoticeType.AttentionNotice;
                            ni.Poster = "";
                            ni.Posterid = 0;
                            ni.Uid = ui.Uid;
                            Notices.CreateNoticeInfo(ni);
                        }
                    }
                    Discuz.Data.OnlineUsers.SetUserOnlineState(uid, 1);

                    HttpCookie cookie = HttpContext.Current.Request.Cookies["dnt"];
                    if (cookie != null)
                    {
                        cookie.Values["tpp"] = ui.Tpp.ToString();
                        cookie.Values["ppp"] = ui.Ppp.ToString();
                        if (HttpContext.Current.Request.Cookies["dnt"]["expires"] != null)
                        {
                            int expires = TypeConverter.StrToInt(HttpContext.Current.Request.Cookies["dnt"]["expires"].ToString(), 0);
                            if (expires > 0)
                            {
                                cookie.Expires = DateTime.Now.AddMinutes(TypeConverter.StrToInt(HttpContext.Current.Request.Cookies["dnt"]["expires"].ToString(), 0));
                            }
                        }
                    }

                    string cookieDomain = GeneralConfigs.GetConfig().CookieDomain.Trim();
                    if (!Utils.StrIsNullOrEmpty(cookieDomain) && HttpContext.Current.Request.Url.Host.IndexOf(cookieDomain) > -1 && ForumUtils.IsValidDomain(HttpContext.Current.Request.Url.Host))
                        cookie.Domain = cookieDomain;
                    HttpContext.Current.Response.AppendCookie(cookie);
                }
                else
                {
                    onlineuserinfo = CreateGuestUser(timeout);
                }
            }
            else
            {
                onlineuserinfo = CreateGuestUser(timeout);
            }
            return onlineuserinfo;
        }


        /// <summary>
        /// ûϢάжϵǰû(Աο),Ƿбд,»Աĵǰ,.
        /// </summary>
        /// <param name="passwordkey">̳passwordkey</param>
        /// <param name="timeout">߳ʱʱ</param>
        /// <param name="passwd">û</param>
        public static OnlineUserInfo UpdateInfo(string passwordkey, int timeout, int uid, string passwd)
        {
            lock (SynObject)
            {
                OnlineUserInfo onlineuser = new OnlineUserInfo();
                string ip = DNTRequest.GetIP();
                int userid = TypeConverter.StrToInt(ForumUtils.GetCookie("userid"), uid);
                string password = (Utils.StrIsNullOrEmpty(passwd) ? ForumUtils.GetCookiePassword(passwordkey) : ForumUtils.GetCookiePassword(passwd, passwordkey));

                // Base64ַɱǷ۸, ֱΪο
                if (password.Length == 0 || !Utils.IsBase64String(password))
                    userid = -1;

                if (userid != -1)
                {
                    onlineuser = GetOnlineUser(userid, password);

                    //ͳ
                    if (!DNTRequest.GetPageName().EndsWith("ajax.aspx") && GeneralConfigs.GetConfig().Statstatus == 1)
                        Stats.UpdateStatCount(false, onlineuser != null);

                    if (onlineuser != null)
                    {
                        if (onlineuser.Ip != ip)
                        {
                            UpdateIP(onlineuser.Olid, ip);
                            onlineuser.Ip = ip;
                            return onlineuser;
                        }
                    }
                    else
                    {
                        // жǷȷ
                        userid = Users.CheckPassword(userid, password, false);
                        if (userid != -1)
                        {
                            Discuz.Data.OnlineUsers.DeleteRowsByIP(ip);
                            CheckIp(ip);
                            return CreateUser(userid, timeout);
                        }
                        else
                        {
                            CheckIp(ip);
                            // ߱дο
                            onlineuser = GetOnlineUserByIP(-1, ip);
                            if (onlineuser == null)
                                return CreateGuestUser(timeout);
                        }
                    }
                }
                else
                {
                    onlineuser = GetOnlineUserByIP(-1, ip);
                    //ͳ
                    if (!DNTRequest.GetPageName().EndsWith("ajax.aspx") && GeneralConfigs.GetConfig().Statstatus == 1)
                        Stats.UpdateStatCount(true, onlineuser != null);

                    if (onlineuser == null)
                        return CreateGuestUser(timeout);
                }

                //onlineuser.Lastupdatetime = Utils.GetDateTime();  Ϊ˿ͻܹ¼עʹ˾䣬޸ġ
                return onlineuser;
            }
        }

        /// <summary>
        /// ipַǷϷ
        /// </summary>
        /// <param name="ip"></param>
        private static void CheckIp(string ip)
        {
            string errmsg = "";
            //жIPַǷϷ,Ҫع
            Discuz.Common.Generic.List<IpInfo> list = Caches.GetBannedIpList();

            foreach (IpInfo ipinfo in list)
            {
                if (ip == (string.Format("{0}.{1}.{2}.{3}", ipinfo.Ip1, ipinfo.Ip2, ipinfo.Ip3, ipinfo.Ip4)))
                {
                    errmsg = "ip," + ipinfo.Expiration + "";
                    break;
                }

                if (ipinfo.Ip4.ToString() == "*")
                {
                    if ((TypeConverter.StrToInt(ip.Split('.')[0], -1) == ipinfo.Ip1) && (TypeConverter.StrToInt(ip.Split('.')[1], -1) == ipinfo.Ip2) && (TypeConverter.StrToInt(ip.Split('.')[2], -1) == ipinfo.Ip3))
                    {
                        errmsg = "ڵipα," + ipinfo.Expiration + "";
                        break;
                    }
                }
            }

            if (errmsg != string.Empty)
                HttpContext.Current.Response.Redirect(BaseConfigs.GetForumPath + "tools/error.htm?forumpath=" + BaseConfigs.GetForumPath + "&templatepath=default&msg=" + Utils.UrlEncode(errmsg));
        }

        /// <summary>
        /// ûϢάжϵǰû(Աο),Ƿбд,»Աĵǰ,.
        /// </summary>
        /// <param name="passwordkey">û</param
        /// <param name="timeout">߳ʱʱ</param>
        public static OnlineUserInfo UpdateInfo(string passwordkey, int timeout)
        {
            return UpdateInfo(passwordkey, timeout, -1, "");
        }

        #endregion

        #region ûϢ

        /// <summary>
        /// ûĵǰϢ
        /// </summary>
        /// <param name="olid">бid</param>
        /// <param name="action"></param>
        /// <param name="inid">λô</param>
        /// <param name="timeout">ʱ</param>
        public static void UpdateAction(int olid, int action, int inid, int timeout)
        {
            // ϴˢcookieС5, ˢݿʱ
            if ((timeout < 0) && (Environment.TickCount - TypeConverter.StrToInt(Utils.GetCookie("lastolupdate"), Environment.TickCount) < 300000))
                Utils.WriteCookie("lastolupdate", Environment.TickCount.ToString());
            else
                UpdateAction(olid, action, inid);
        }

        /// <summary>
        /// ûĵǰϢ
        /// </summary>
        /// <param name="olid">бid</param>
        /// <param name="action"></param>
        /// <param name="inid">λô</param>
        public static void UpdateAction(int olid, int action, int inid)
        {
            if (GeneralConfigs.GetConfig().Onlineoptimization != 1)
            {
                Discuz.Data.OnlineUsers.UpdateAction(olid, action, inid);
            }
        }


        /// <summary>
        /// ûĵǰϢ
        /// </summary>
        /// <param name="olid">бid</param>
        /// <param name="action">id</param>
        /// <param name="fid">id</param>
        /// <param name="forumname"></param>
        /// <param name="tid">id</param>
        /// <param name="topictitle"></param>
        /// 
        public static void UpdateAction(int olid, int action, int fid, string forumname, int tid, string topictitle)
        {
            bool isupdate = false;
            forumname = forumname.Length > 40 ? forumname.Substring(0, 37) + "..." : forumname;
            topictitle = topictitle.Length > 40 ? topictitle.Substring(0, 37) + "..." : topictitle;
            if (action == UserAction.PostReply.ActionID || action == UserAction.PostTopic.ActionID)
            {
                if (GeneralConfigs.GetConfig().PostTimeStorageMedia == 0 || Utils.GetCookie("lastposttime") == "")//⵽ûĸcookieֵΪ(ûcookie)Ҫͨݿбȷֵ׼ȷԣֻûcookieֵ֤ȷ
                    isupdate = true;
                else
                    Utils.WriteCookie("lastposttime", Utils.GetDateTime());
            }
            else if (GeneralConfigs.GetConfig().Onlineoptimization != 1)
            {
                if (System.Environment.TickCount - TypeConverter.StrToInt(Utils.GetCookie("lastolupdate"), System.Environment.TickCount) >= 300000) // ϴˢcookieС5, ˢݿʱ
                {
                    if (action == UserAction.ShowForum.ActionID || action == UserAction.ShowTopic.ActionID || action == UserAction.ShowTopic.ActionID || action == UserAction.PostReply.ActionID)
                        isupdate = true;
                }
            }
            if (isupdate)
            {
                Discuz.Data.OnlineUsers.UpdateAction(olid, action, fid, forumname, tid, topictitle);
                Utils.WriteCookie("lastolupdate", System.Environment.TickCount.ToString());
                Utils.WriteCookie("lastposttime", Utils.GetDateTime());
            }
        }

        /// <summary>
        /// ûʱ
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="timeout">ʱʱ</param>
        private static void UpdateLastTime(int olid, int timeout)
        {
            // ϴˢcookieС5, ˢݿʱ
            if ((timeout < 0) && (System.Environment.TickCount - TypeConverter.StrToInt(Utils.GetCookie("lastolupdate"), System.Environment.TickCount) < 300000))
                Utils.WriteCookie("lastolupdate", System.Environment.TickCount.ToString());
            else
                Discuz.Data.OnlineUsers.UpdateLastTime(olid);
        }


        /// <summary>
        /// û󷢶Ϣʱ
        /// </summary>
        /// <param name="olid">id</param>
        public static void UpdatePostPMTime(int olid)
        {
            if (GeneralConfigs.GetConfig().Onlineoptimization != 1)
            {
                Discuz.Data.OnlineUsers.UpdatePostPMTime(olid);
            }
        }

        /// <summary>
        /// ָ߱ûǷ
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="invisible">Ƿ</param>
        public static void UpdateInvisible(int olid, int invisible)
        {
            if (GeneralConfigs.GetConfig().Onlineoptimization != 1)
            {
                Discuz.Data.OnlineUsers.UpdateInvisible(olid, invisible);
            }
        }

        /// <summary>
        /// ָ߱ûû
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="password">û</param>
        public static void UpdatePassword(int olid, string password)
        {
            Discuz.Data.OnlineUsers.UpdatePassword(olid, password);
        }


        /// <summary>
        /// ûIPַ
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="ip">ipַ</param>
        public static void UpdateIP(int olid, string ip)
        {
            Discuz.Data.OnlineUsers.UpdateIP(olid, ip);
        }

        /// <summary>
        /// ûʱ
        /// </summary>
        /// <param name="olid">id</param>
        //public static void UpdateSearchTime(int olid)
        //{
        //    if (GeneralConfigs.GetConfig().Onlineoptimization != 1)
        //    {
        //        Discuz.Data.OnlineUsers.UpdateSearchTime(olid);
        //    }
        //}

        #endregion

        /// <summary>
        /// ɾָ߱id
        /// </summary>
        /// <param name="olid">id</param>
        /// <returns></returns>
        public static int DeleteRows(int olid)
        {
            return Discuz.Data.OnlineUsers.DeleteRows(olid);
        }

        #region ķ

        /// <summary>
        /// ûб
        /// </summary>
        /// <param name="totaluser">ȫû</param>
        /// <param name="guest">ο</param>
        /// <param name="user">¼û</param>
        /// <param name="invisibleuser">Ա</param>
        /// <returns></returns>
        public static Discuz.Common.Generic.List<OnlineUserInfo> GetForumOnlineUserCollection(int forumid, out int totaluser, out int guest, out int user, out int invisibleuser)
        {
            Discuz.Common.Generic.List<OnlineUserInfo> coll = Discuz.Data.OnlineUsers.GetForumOnlineUserCollection(forumid);

            //ο
            guest = 0;
            //û
            invisibleuser = 0;
            //ǰû
            totaluser = coll.Count;

            foreach (OnlineUserInfo onlineUserInfo in coll)
            {
                if (onlineUserInfo.Userid == -1)
                    guest++;

                if (onlineUserInfo.Invisible == 1)
                    invisibleuser++;
            }

            //ͳû
            user = totaluser - guest;
            //صǰû
            return coll;
        }


        /// <summary>
        /// ûб
        /// </summary>
        /// <param name="totaluser">ȫû</param>
        /// <param name="guest">ο</param>
        /// <param name="user">¼û</param>
        /// <param name="invisibleuser">Ա</param>
        /// <returns></returns>
        public static Discuz.Common.Generic.List<OnlineUserInfo> GetOnlineUserCollection(out int totaluser, out int guest, out int user, out int invisibleuser)
        {
            Discuz.Common.Generic.List<OnlineUserInfo> coll = Discuz.Data.OnlineUsers.GetOnlineUserCollection();

            //עû
            user = 0;
            //û
            invisibleuser = 0;

            //бοʱ,ζ'GetOnlineUserCollection()'߱м¼
            if (GeneralConfigs.GetConfig().Whosonlinecontract == 0)
                totaluser = coll.Count;
            else
                totaluser = OnlineUsers.GetOnlineAllUserCount();//Ҫ»ȡȫû

            foreach (OnlineUserInfo onlineUserInfo in coll)
            {
                if (onlineUserInfo.Userid > 0)
                    user++;

                if (onlineUserInfo.Invisible == 1)
                    invisibleuser++;
            }

            if (totaluser > TypeConverter.StrToInt(Statistics.GetStatisticsRowItem("highestonlineusercount"), 1))
            {
                if (Statistics.UpdateStatistics("highestonlineusercount", totaluser.ToString()) > 0)
                {
                    Statistics.UpdateStatistics("highestonlineusertime", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    Statistics.ReSetStatisticsCache();
                }
            }

            //ͳο
            guest = totaluser > user ? totaluser - user : 0;

            //صǰû
            return coll;
        }

        /// <summary>
        /// ʱ
        /// </summary>
        /// <param name="oltimespan">ʱ</param>
        /// <param name="uid">ǰûid</param>
        public static void UpdateOnlineTime(int oltimespan, int uid)
        {
            //Ϊ0رͳƹ
            if (oltimespan != 0)
            {
                if (Utils.StrIsNullOrEmpty(Utils.GetCookie("lastactivity", "onlinetime")))
                    Utils.WriteCookie("lastactivity", "onlinetime", System.Environment.TickCount.ToString());

                //ϴθݿûʱ󵽵ǰʱ
                int oltime = System.Environment.TickCount - TypeConverter.StrToInt(Utils.GetCookie("lastactivity", "onlinetime"), System.Environment.TickCount);
                if (oltime <= 0 /*TickCount 49ϵͳ㣬ɸֵΪ*/ 
                    || oltime >= oltimespan * 60 * 1000)
                {
                    Discuz.Data.OnlineUsers.UpdateOnlineTime(oltimespan, uid);
                    Utils.WriteCookie("lastactivity", "onlinetime", System.Environment.TickCount.ToString());

                    oltime = System.Environment.TickCount - TypeConverter.StrToInt(Utils.GetCookie("lastactivity", "oltime"), System.Environment.TickCount);
                    //жǷͬoltime (¼ĵһonlinetimeµʱ߳oltimespan2ʱ)
                    if (Utils.StrIsNullOrEmpty(Utils.GetCookie("lastactivity", "oltime")) ||
                        oltime <= 0 /*TickCount 49ϵͳ㣬ɸֵΪ*/ 
                        || oltime >= (2 * oltimespan * 60 * 1000))
                    {
                        Discuz.Data.OnlineUsers.SynchronizeOnlineTime(uid);
                        Utils.WriteCookie("lastactivity", "oltime", System.Environment.TickCount.ToString());
                    }
                }
            }
        }

        #endregion



        /// <summary>
        /// UidOlid
        /// </summary>
        /// <param name="uid"></param>
        /// <returns></returns>
        public static int GetOlidByUid(int uid)
        {
            return Discuz.Data.OnlineUsers.GetOlidByUid(uid);
        }

        /// <summary>
        /// ɾ߱Uidû
        /// </summary>
        /// <param name="uid">ҪɾûUid</param>
        /// <returns></returns>
        public static int DeleteUserByUid(int uid)
        {
            return DeleteRows(GetOlidByUid(uid));
        }

        /// <summary>
        /// û¶Ϣ
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="count"></param>
        /// <returns></returns>
        public static int UpdateNewPms(int olid, int count)
        {
            return Discuz.Data.OnlineUsers.UpdateNewPms(olid, count);
        }

        /// <summary>
        /// û֪ͨ
        /// </summary>
        /// <param name="olid">id</param>
        /// <param name="pluscount"></param>
        /// <returns></returns>
        public static int UpdateNewNotices(int olid, int pluscount)
        {
            return Discuz.Data.OnlineUsers.UpdateNewNotices(olid, pluscount);
        }

        /// <summary>
        /// »ȡû֪ͨӱ²ѯ
        /// </summary>
        /// <param name="olid">id</param>
        /// <returns></returns>
        public static int UpdateNewNotices(int olid)
        {
            return Discuz.Data.OnlineUsers.UpdateNewNotices(olid, 0);
        }

        ///// <summary>
        ///// ߱кѹϵ
        ///// </summary>
        ///// <param name="olId">id</param>
        ///// <param name="count"></param>
        ///// <returns></returns>
        //public static int UpdateNewFriendsRequest(int olId, int count)
        //{
        //    return Data.OnlineUsers.UpdateNewFriendsRequest(olId, count);
        //}

        ///// <summary>
        ///// ߱Ӧ
        ///// </summary>
        ///// <param name="olId">id</param>
        ///// <param name="count"></param>
        ///// <returns></returns>
        //public static int UpdateNewApplicationRequest(int olId, int count)
        //{
        //    return Data.OnlineUsers.UpdateNewApplicationRequest(olId, count);
        //}

    }//class end
}
