﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

/// <summary>
/// CardManage 的摘要说明
/// </summary>
public class CardManage
{
	public CardManage()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    DataBase data = new DataBase();

    #region 定义帖子--数据结构
    private string cardid = "";
    private string cardname = "";
    private string moduleid = "";
    private string cardcontent = "";
    private DateTime cardtime = Convert.ToDateTime(DateTime.Now.ToShortDateString());
    private string cardpeople = "";
    private string pop = "";
    /// <summary>
    /// 帖子编号
    /// </summary>
    public string CardID
    {
        get { return cardid; }
        set { cardid = value; }
    }
    /// <summary>
    /// 帖子名称
    /// </summary>
    public string CardName
    {
        get { return cardname; }
        set { cardname = value; }
    }
    /// <summary>
    /// 版块编号
    /// </summary>
    public string ModuleID
    {
        get { return moduleid; }
        set { moduleid = value; }
    }
    /// <summary>
    /// 帖子内容
    /// </summary>
    public string CardContent
    {
        get { return cardcontent; }
        set { cardcontent = value; }
    }
    /// <summary>
    /// 发表日期
    /// </summary>
    public DateTime CardTime
    {
        get { return cardtime; }
        set { cardtime = value; }
    }
    /// <summary>
    /// 发帖人
    /// </summary>
    public string CardPeople
    {
        get { return cardpeople; }
        set { cardpeople = value; }
    }
    /// <summary>
    /// 角色
    /// </summary>
    public string Pop
    {
        get { return pop; }
        set { pop = value; }
    }
    #endregion

    #region 自动生成帖子编号
    /// <summary>
    /// 自动生成帖子编号
    /// </summary>
    /// <returns></returns>
    public string GetCID()
    {
        DataSet ds = GetAllCard("tb_Card");
        string strCID = "";
        if (ds.Tables[0].Rows.Count == 0)
            strCID = "T1001";
        else
            strCID = "T" + (Convert.ToInt32(ds.Tables[0].Rows[ds.Tables[0].Rows.Count - 1][0].ToString().Substring(1, 4)) + 1);
        return strCID;
    }
    #endregion
   
    #region 添加--帖子信息
    /// <summary>
    /// 添加--帖子信息
    /// </summary>
    /// <param name="cardmanage"></param>
    /// <returns></returns>
    public int AddCard(CardManage cardmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50, cardmanage.CardID),
                                        data.MakeInParam("@cardname",  SqlDbType.NVarChar, 1000, cardmanage.CardName),
                						data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50,cardmanage.ModuleID),
                						data.MakeInParam("@cardcontent",  SqlDbType.NVarChar, 4000, cardmanage.CardContent),
                						data.MakeInParam("@cardtime",  SqlDbType.SmallDateTime, 8, cardmanage.CardTime),
                						data.MakeInParam("@cardpeople",  SqlDbType.NVarChar, 50, cardmanage.CardPeople),
                                        data.MakeInParam("@pop",  SqlDbType.NChar, 10, cardmanage.Pop),
			};
        return (data.RunProc("INSERT INTO tb_Card (帖子编号,帖子名称,版块编号,帖子内容,发表时间,发帖人,角色) VALUES (@cardid,@cardname,@moduleid,@cardcontent,@cardtime,@cardpeople,@pop)", prams));
    }
    #endregion

    #region 删除--帖子信息
    /// <summary>
    /// 删除--帖子信息
    /// </summary>
    /// <param name="cardmanage"></param>
    /// <returns></returns>
    public int DeleteCard(CardManage cardmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50, cardmanage.CardID),
			};
        return (data.RunProc("delete from tb_Card where 帖子编号=@cardid", prams));
    }
    #endregion

    #region 查询--帖子信息
    /// <summary>
    /// 根据--版块编号--得到帖子信息
    /// </summary>
    /// <param name="cardmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindCardByMID(CardManage cardmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50,cardmanage.ModuleID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Card where 版块编号 like @moduleid", prams, tbName));
    }
    /// <summary>
    /// 根据--帖子编号--得到帖子信息
    /// </summary>
    /// <param name="cardmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindCardByID(CardManage cardmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50, cardmanage.CardID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Card where 帖子编号 like @cardid", prams, tbName));
    }
    /// <summary>
    /// 根据--帖子名称--得到帖子信息
    /// </summary>
    /// <param name="cardmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindCardByName(CardManage cardmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@cardname",  SqlDbType.NVarChar, 1000, cardmanage.CardName+"%"),
			};
        return (data.RunProcReturn("select * from tb_Card where 帖子名称 like @cardname", prams, tbName));
    }
    /// <summary>
    /// 得到所有--帖子信息
    /// </summary>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet GetAllCard(string tbName)
    {
        return (data.RunProcReturn("select * from tb_Card ORDER BY 发表时间", tbName));
    }
    #endregion
}
