﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

/// <summary>
/// ImageManage 的摘要说明
/// </summary>
public class ImageManage
{
	public ImageManage()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    DataBase data = new DataBase();

    #region 定义头像--数据结构
    private string photoid = "";
    private string photo = "";
    /// <summary>
    /// 编号
    /// </summary>
    public string PhotoID
    {
        get { return photoid; }
        set { photoid = value; }
    }
    /// <summary>
    /// 头像
    /// </summary>
    public string Photo
    {
        get { return photo; }
        set { photo = value; }
    }
    #endregion

    #region 自动生成头像编号
    /// <summary>
    /// 自动生成头像编号
    /// </summary>
    /// <returns></returns>
    public string GetPID()
    {
        DataSet ds = GetAllPhoto("tb_Image");
        string strPID = "";
        if (ds.Tables[0].Rows.Count == 0)
            strPID = "IMG1001";
        else
            strPID = "IMG" + (Convert.ToInt32(ds.Tables[0].Rows[ds.Tables[0].Rows.Count - 1][0].ToString().Substring(3, 4)) + 1);
        return strPID;
    }
    #endregion

    #region 添加--头像信息
    /// <summary>
    /// 添加--头像信息
    /// </summary>
    /// <param name="imagemanage"></param>
    /// <returns></returns>
    public int AddPhoto(ImageManage imagemanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@photoid",  SqlDbType.NVarChar, 20, imagemanage.PhotoID),
                						data.MakeInParam("@photo",  SqlDbType.NVarChar, 200, imagemanage.Photo),
			};
        return (data.RunProc("INSERT INTO tb_Image(编号,头像) VALUES(@photoid,@photo)", prams));
    }
    #endregion

    #region 删除--头像信息
    /// <summary>
    /// 删除--头像信息
    /// </summary>
    /// <param name="imagemanage"></param>
    /// <returns></returns>
    public int DeletePhoto(ImageManage imagemanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@photoid",  SqlDbType.NVarChar, 20, imagemanage.PhotoID),
			};
        return (data.RunProc("delete from tb_Image where 编号=@photoid", prams));
    }
    #endregion

    #region 查询--头像信息
    /// <summary>
    /// 根据--头像编号--得到头像信息
    /// </summary>
    /// <param name="imagemanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindPhotoByID(ImageManage imagemanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@photoid",  SqlDbType.NVarChar, 20, imagemanage.PhotoID),
			};
        return (data.RunProcReturn("select * from tb_Image where 编号 like @photoid", prams, tbName));
    }
    /// <summary>
    /// 得到所有--头像信息
    /// </summary>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet GetAllPhoto(string tbName)
    {
        return (data.RunProcReturn("select * from tb_Image ORDER BY 编号", tbName));
    }
    #endregion
}
