﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

/// <summary>
/// ModuleManage 的摘要说明
/// </summary>
public class ModuleManage
{
	public ModuleManage()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    DataBase data = new DataBase();

    #region 定义版块--数据结构
    private string moduleid = "";
    private string modulename = "";
    /// <summary>
    /// 版块编号
    /// </summary>
    public string ModuleID
    {
        get { return moduleid; }
        set { moduleid = value; }
    }
    /// <summary>
    /// 版块名称
    /// </summary>
    public string ModuleName
    {
        get { return modulename; }
        set { modulename = value; }
    }
    #endregion

    #region 自动生成版块编号
    /// <summary>
    /// 自动生成版块编号
    /// </summary>
    /// <returns></returns>
    public string GetMID()
    {
        DataSet ds = GetAllModule("tb_Module");
        string strCID = "";
        if (ds.Tables[0].Rows.Count == 0)
            strCID = "M1001";
        else
            strCID = "M" + (Convert.ToInt32(ds.Tables[0].Rows[ds.Tables[0].Rows.Count - 1][0].ToString().Substring(1, 4)) + 1);
        return strCID;
    }
    #endregion

    #region 添加--版块信息
    /// <summary>
    /// 添加--版块信息
    /// </summary>
    /// <param name="modulemanage"></param>
    /// <returns></returns>
    public int AddModule(ModuleManage modulemanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, modulemanage.ModuleID),
                                        data.MakeInParam("@modulename",  SqlDbType.NVarChar, 100, modulemanage.ModuleName),
			};
        return (data.RunProc("INSERT INTO tb_Module (版块编号,版块名称) VALUES (@moduleid,@modulename)", prams));
    }
    #endregion

    #region 修改--版块信息
    /// <summary>
    /// 修改--版块信息
    /// </summary>
    /// <param name="modulemanage"></param>
    /// <returns></returns>
    public int UpdateModule(ModuleManage modulemanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, modulemanage.ModuleID),
                                        data.MakeInParam("@modulename",  SqlDbType.NVarChar, 100, modulemanage.ModuleName),
			};
        return (data.RunProc("update tb_Module set 版块名称=@modulename where 版块编号=@moduleid", prams));
    }
    #endregion

    #region 删除--版块信息
    /// <summary>
    /// 删除--版块信息
    /// </summary>
    /// <param name="modulemanage"></param>
    /// <returns></returns>
    public int DeleteModule(ModuleManage modulemanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, modulemanage.ModuleID),
			};
        return (data.RunProc("delete from tb_Module where 版块编号=@moduleid", prams));
    }
    #endregion

    #region 查询--版块信息
    /// <summary>
    /// 根据--版块编号--得到版块信息
    /// </summary>
    /// <param name="modulemanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindModuleByID(ModuleManage modulemanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, modulemanage.ModuleID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Module where 版块编号 like @moduleid", prams, tbName));
    }
    /// <summary>
    /// 根据--版块名称--得到版块信息
    /// </summary>
    /// <param name="modulemanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindModuleByName(ModuleManage modulemanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@modulename",  SqlDbType.NVarChar, 100, modulemanage.ModuleName+"%"),
			};
        return (data.RunProcReturn("select * from tb_Module where 版块名称 like @modulename", prams, tbName));
    }
    /// <summary>
    /// 得到所有--版块信息
    /// </summary>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet GetAllModule(string tbName)
    {
        return (data.RunProcReturn("select * from tb_Module ORDER BY 版块编号", tbName));
    }
    #endregion
}
