﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

/// <summary>
/// RevertManage 的摘要说明
/// </summary>
public class RevertManage
{
	public RevertManage()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    DataBase data = new DataBase();

    #region 定义回帖--数据结构
    private string revertid = "";
    private string revertname = "";
    private string cardid = "";
    private string revertcontent = "";
    private DateTime reverttime = Convert.ToDateTime(DateTime.Now.ToShortDateString());
    private string revertpeople = "";
    private string pop = "";
    /// <summary>
    /// 回帖编号
    /// </summary>
    public string RevertID
    {
        get { return revertid; }
        set { revertid = value; }
    }
    /// <summary>
    /// 回帖主题
    /// </summary>
    public string RevertName
    {
        get { return revertname; }
        set { revertname = value; }
    }
    /// <summary>
    /// 帖子编号
    /// </summary>
    public string CardID
    {
        get { return cardid; }
        set { cardid = value; }
    }
    /// <summary>
    /// 回帖内容
    /// </summary>
    public string RevertContent
    {
        get { return revertcontent; }
        set { revertcontent = value; }
    }
    /// <summary>
    /// 回帖时间
    /// </summary>
    public DateTime RevertTime
    {
        get { return reverttime; }
        set { reverttime = value; }
    }
    /// <summary>
    /// 回帖人
    /// </summary>
    public string RevertPeople
    {
        get { return revertpeople; }
        set { revertpeople = value; }
    }
    /// <summary>
    /// 角色
    /// </summary>
    public string Pop
    {
        get { return pop; }
        set { pop = value; }
    }
    #endregion

    #region 自动生成回帖编号
    /// <summary>
    /// 自动生成回帖编号
    /// </summary>
    /// <returns></returns>
    public string GetRCID()
    {
        DataSet ds = GetAllRevert("tb_Revert");
        string strCID = "";
        if (ds.Tables[0].Rows.Count == 0)
            strCID = "HT1001";
        else
            strCID = "HT" + (Convert.ToInt32(ds.Tables[0].Rows[ds.Tables[0].Rows.Count - 1][0].ToString().Substring(2, 4)) + 1);
        return strCID;
    }
    #endregion

    #region 添加--回帖信息
    /// <summary>
    /// 添加--回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <returns></returns>
    public int AddRevert(RevertManage revertmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@revertid",  SqlDbType.NVarChar, 20, revertmanage.RevertID),
                                        data.MakeInParam("@revertname",  SqlDbType.NVarChar, 50, revertmanage.RevertName),
                						data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50,revertmanage.CardID),
                						data.MakeInParam("@revertcontent",  SqlDbType.NVarChar, 4000, revertmanage.RevertContent),
                						data.MakeInParam("@reverttime",  SqlDbType.SmallDateTime, 8, revertmanage.RevertTime),
                						data.MakeInParam("@revertpeople",  SqlDbType.NVarChar, 50, revertmanage.RevertPeople),
                                        data.MakeInParam("@pop",  SqlDbType.NChar, 10, revertmanage.Pop),
			};
        return (data.RunProc("INSERT INTO tb_Revert (回帖编号,回帖主题,帖子编号,回帖内容,回帖时间,回帖人,角色) VALUES (@revertid,@revertname,@cardid,@revertcontent,@reverttime,@revertpeople,@pop)", prams));
    }
    #endregion

    #region 修改--回帖信息
    /// <summary>
    /// 修改--回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <returns></returns>
    public int UpdateRevert(RevertManage revertmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@revertid",  SqlDbType.NVarChar, 20, revertmanage.RevertID),
                                        data.MakeInParam("@revertname",  SqlDbType.NVarChar, 50, revertmanage.RevertName),
                						data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50,revertmanage.CardID),
                						data.MakeInParam("@revertcontent",  SqlDbType.NVarChar, 4000, revertmanage.RevertContent),
			};
        return (data.RunProc("update tb_Revert set 回帖主题=@revertname,帖子编号=@cardid,回帖内容=@revertcontent where 回帖编号=@revertid", prams));
    }
    #endregion

    #region 删除--回帖信息
    /// <summary>
    /// 删除--回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <returns></returns>
    public int DeleteRevert(RevertManage revertmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@revertid",  SqlDbType.NVarChar, 20, revertmanage.RevertID),
			};
        return (data.RunProc("delete from tb_Revert where 回帖编号=@revertid", prams));
    }
    #endregion

    #region 查询--回帖信息
    /// <summary>
    /// 根据--帖子编号--得到回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindRevertByCID(RevertManage revertmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@cardid",  SqlDbType.NVarChar, 50,revertmanage.CardID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Revert where 帖子编号 like @cardid ORDER BY 回帖时间", prams, tbName));
    }
    /// <summary>
    /// 根据--回帖编号--得到回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindRevertByID(RevertManage revertmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@revertid",  SqlDbType.NVarChar, 20, revertmanage.RevertID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Revert where 回帖编号 like @revertid ORDER BY 回帖时间", prams, tbName));
    }
    /// <summary>
    /// 根据--回帖主题--得到回帖信息
    /// </summary>
    /// <param name="revertmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindRevertByName(RevertManage revertmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@revertname",  SqlDbType.NVarChar, 50, revertmanage.RevertName+"%"),
			};
        return (data.RunProcReturn("select * from tb_Revert where 回帖主题 like @revertname ORDER BY 回帖时间", prams, tbName));
    }
    /// <summary>
    /// 得到所有--回帖信息
    /// </summary>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet GetAllRevert(string tbName)
    {
        return (data.RunProcReturn("select * from tb_Revert ORDER BY 回帖时间", tbName));
    }
    #endregion
}
