﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ModuleManage_ModuleManage : System.Web.UI.Page
{
    ModuleManage modulemanage = new ModuleManage();
    HostManage hostmanage = new HostManage();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvBind();
        }
    }
    protected void btnFind_Click(object sender, EventArgs e)
    {
        gvBind();
    }
    protected void gvInfo_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvInfo.PageIndex = e.NewPageIndex;
        gvBind();
    }
    protected void gvInfo_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        modulemanage.ModuleID = gvInfo.DataKeys[e.RowIndex].Value.ToString();
        modulemanage.DeleteModule(modulemanage);
        Response.Write("<script>alert('版块信息删除成功')</script>");
        gvBind();
    }
    protected void gvInfo_RowEditing(object sender, GridViewEditEventArgs e)
    {
        gvInfo.EditIndex = e.NewEditIndex;
        gvBind();
    }
    protected void gvInfo_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        modulemanage.ModuleID = gvInfo.DataKeys[e.RowIndex].Value.ToString();
        modulemanage.ModuleName = ((TextBox)(gvInfo.Rows[e.RowIndex].Cells[1].Controls[0])).Text;
        modulemanage.UpdateModule(modulemanage);
        gvInfo.EditIndex = -1;
        gvBind();
    }
    protected void gvInfo_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        gvInfo.EditIndex = -1;
        gvBind();
    }
    public void gvBind()
    {
        if (txtName.Text == string.Empty)
        {
            if (Session["Pop"] == "版主")
            {
                HyperLink1.Visible = false;
                hostmanage.HostName = Session["Name"].ToString();
                modulemanage.ModuleID = hostmanage.FindHostByName(hostmanage, "tb_Host").Tables[0].Rows[0][1].ToString();
                gvInfo.DataSource = modulemanage.FindModuleByID(modulemanage,"tb_Module").Tables[0];
                gvInfo.DataKeyNames = new string[] { "版块编号" };
                gvInfo.DataBind();
                return;
            }
            if (Session["Pop"] == "管理员")
            {
                gvInfo.DataSource = modulemanage.GetAllModule("tb_Module").Tables[0];
                gvInfo.DataKeyNames = new string[] { "版块编号" };
                gvInfo.DataBind();
                return;
            }
        }
        else
        {
            if (Session["Pop"] == "管理员")
            {
                modulemanage.ModuleName = txtName.Text;
                gvInfo.DataSource = modulemanage.FindModuleByName(modulemanage, "tb_Module").Tables[0];
                gvInfo.DataKeyNames = new string[] { "版块编号" };
                gvInfo.DataBind();
                return;
            }
        }
    }
}
