﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserManage_UserManage : System.Web.UI.Page
{
    UserManage usermanage = new UserManage();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvUserInfo.DataSource = usermanage.GetAllUser("tb_User").Tables[0].DefaultView;
            gvUserInfo.DataKeyNames = new string[] { "用户名" };
            gvUserInfo.DataBind();
            for (int i = 0; i < usermanage.GetAllUser("tb_User").Tables[0].Rows.Count; i++)
            {
                gvUserInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(usermanage.GetAllUser("tb_User").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
    }
    protected void btnFind_Click(object sender, EventArgs e)
    {
        gvBind();
    }
    protected void gvUserInfo_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvUserInfo.PageIndex = e.NewPageIndex;
        gvBind();
    }
    protected void gvUserInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            ((LinkButton)(e.Row.Cells[6].Controls[0])).Attributes.Add("onclick", "return confirm('确定要删除吗？')");
        }
    }
    protected void gvUserInfo_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        usermanage.UserName = gvUserInfo.DataKeys[e.RowIndex].Value.ToString();
        usermanage.DeleteUser(usermanage);
        gvBind();
    }
    protected void gvUserInfo_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Update")
        {
            Session["Name"] = gvUserInfo.Rows[Convert.ToInt32(e.CommandArgument)].Cells[0].Text;
            Session["Pop"] = "用户";
            Response.Redirect("../Common/ModifyInfo.aspx");
        }
    }
    public void gvBind()
    {
        if (txtName.Text == string.Empty)
        {
            gvUserInfo.DataSource = usermanage.GetAllUser("tb_User").Tables[0];
            gvUserInfo.DataBind();
            for (int i = 0; i < usermanage.GetAllUser("tb_User").Tables[0].Rows.Count; i++)
            {
                gvUserInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(usermanage.GetAllUser("tb_User").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
        else
        {
            usermanage.UserName = txtName.Text;
            gvUserInfo.DataSource = usermanage.FindUserByName(usermanage,"tb_User").Tables[0];
            gvUserInfo.DataBind();
            for (int i = 0; i < usermanage.FindUserByName(usermanage, "tb_User").Tables[0].Rows.Count; i++)
            {
                gvUserInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(usermanage.FindUserByName(usermanage, "tb_User").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
    }
}
