<?xml version='1.0' encoding='gb2312'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--  -->
	<xsl:import href='imports.xsl'/>

	<!-- ģ -->
	<xsl:template match='/'>
		<html>
			<head>
				<xsl:call-template name='part_header'/>
				<link href='../css/board.css' rel='stylesheet' type='text/css' />
			</head>
			<body>
				<div id='topdiv'>
					<a name='top'></a> <br/>
					<span class='t2'>[XMLͼ]</span> <br />
					
					<xsl:element name='a'>
						<xsl:attribute name='href'>index<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/></xsl:attribute>
						<xsl:value-of select='DvbbsArchiver/AppInfo/ForumName'/>
					</xsl:element>
					<span style='margin-left:10px;margin-right:10px'></span>
					<xsl:element name='a'>
						<xsl:attribute name='href'><xsl:value-of select='DvbbsArchiver/AppInfo/BaseHref'/>board<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>?boardid=<xsl:value-of select='DvbbsArchiver/Location/BoardId'/></xsl:attribute>
						<xsl:value-of select='DvbbsArchiver/Location/BoardName'/>
					</xsl:element>
					<span class='indent-left t3'>-- ȨĶ --</span>

					<!-- ÷ҳģ -->
					<xsl:apply-templates select='DvbbsArchiver/PagerParams'/>
					<!-- б -->
					<xsl:apply-templates select='DvbbsArchiver/Topics'/>
					<xsl:if test='DvbbsArchiver/PagerParams/TotalRows[.&gt;100]'>
						<!-- Clone÷ҳģ -->
						<xsl:apply-templates select='DvbbsArchiver/PagerParams'/>
					</xsl:if>
					<!-- ÷ҳ -->
					<xsl:call-template name='script_pagination'/>

					<div id='modelinks'>
						<span class='t1'>[Full]</span>
						 :
						<xsl:element name='a'>
							<xsl:attribute name='href'><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../../board.aspx?boardid=<xsl:value-of select='DvbbsArchiver/Location/BoardId'/></xsl:attribute>
							<xsl:attribute name='target'>_blank</xsl:attribute>
							<xsl:value-of select='DvbbsArchiver/Location/BoardName'/>
						</xsl:element>
						<br/>
						<span class='t1'>[XHTML]</span>
						XHTMLͼ :
						<xsl:element name='a'>
							<xsl:attribute name='href'><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../xhtml/board/<xsl:value-of select='DvbbsArchiver/Location/BoardId'/>/index<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/></xsl:attribute>
							<xsl:attribute name='target'>_blank</xsl:attribute>
							<xsl:value-of select='DvbbsArchiver/Location/BoardName'/>
						</xsl:element>
					</div>

					<!-- ҳ -->
					<xsl:call-template name='part_footer'/>
				</div>
			</body>
		</html>
	</xsl:template>

	<!-- бģ -->
	<xsl:template match='DvbbsArchiver/Topics'>
		<div id='topiclist'>
			<ul>
				<xsl:for-each select='Topic'>
					<li>
						<xsl:choose>
							<xsl:when test='IsOnTop[.=1]'>
								<span class='topmark'>[]</span>
							</xsl:when>
							<xsl:when test='IsOnTop[.=2]'>
								<span class='topmark t1'>[]</span>
							</xsl:when>
						</xsl:choose>
						<xsl:element name='a'>
							<xsl:attribute name='href'>
							<!--<xsl:value-of select="/DvbbsArchiver/AppInfo/BaseHref"/>topic/<xsl:value-of select='ID'/>/index<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>-->
							<xsl:value-of select="/DvbbsArchiver/AppInfo/BaseHref"/>topic<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>?topicid=<xsl:value-of select='ID'/>
							</xsl:attribute>
							<xsl:attribute name='title'>:<xsl:value-of select='Author'/>Ķ:<xsl:value-of select='Clicks'/>ظ:<xsl:value-of select='Replies'/></xsl:attribute>
							<xsl:value-of select='Caption'/>
						</xsl:element>
						<span class='topicinfo'>
							<xsl:value-of select='Replies'/> ظ
							<xsl:value-of select='PostTime'/>
						</span>
					</li>
				</xsl:for-each>
			</ul>
		</div>
	</xsl:template>

</xsl:stylesheet>
