<?xml version="1.0" encoding="gb2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- ģ -->
	<xsl:import href="imports.xsl"/>

	<!-- ģ -->
	<xsl:template match="/">
		<html>
			<head>
				<xsl:call-template name="part_header"/>
				<link href="../css/index.css" rel="stylesheet" type="text/css" />
			</head>
			<body>
				<div id="topdiv">
					<a name="top"></a> <br/>
					<span class="t2">[XMLͼ]</span> <br />
					
					<xsl:element name="a">
						<xsl:attribute name="href">index<xsl:value-of select="/DvbbsArchiver/AppInfo/FileExtension"/></xsl:attribute>
						<xsl:value-of select="DvbbsArchiver/AppInfo/ForumName"/>
					</xsl:element>
					<br/>

					<!-- ̳ṹͼ -->
					<xsl:apply-templates select="DvbbsArchiver"/>

					<div id="modelinks">
						<span class="t1">[Full]</span>
						 : <!--<a href="../../index.&#97;spx" target="_blank"><xsl:value-of select="DvbbsArchiver/AppInfo/ForumName"/></a> -->
						<xsl:element name="a">
							<xsl:attribute name="target">_blank</xsl:attribute>
							<xsl:attribute name="href"><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../../index.aspx</xsl:attribute>
							<xsl:value-of select="DvbbsArchiver/AppInfo/ForumName"/>
						</xsl:element>
						<br/>
						<span class="t1">[XHTML]</span>
						XHTMLͼ :
						<xsl:element name="a">
							<xsl:attribute name="target">_blank</xsl:attribute>
							<xsl:attribute name="href"><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../xhtml/index<xsl:value-of select="/DvbbsArchiver/AppInfo/FileExtension"/></xsl:attribute>
							<xsl:value-of select="DvbbsArchiver/AppInfo/ForumName"/>
						</xsl:element>
					</div>

					<!-- ҳ -->
					<xsl:call-template name="part_footer"/>
				</div>
			</body>
		</html>
	</xsl:template>

	<!-- ѭ -->
	<xsl:template match="DvbbsArchiver">
		<ul id="boardlist">
			<xsl:for-each select="Category">
				<li class="category">
					<xsl:value-of select="Name"/>
				</li>
				<!-- ѭ -->
				<xsl:apply-templates select="Boards"/>
			</xsl:for-each>
		</ul>
	</xsl:template>

	<!-- ѭ -->
	<xsl:template match="Boards">
		<xsl:for-each select="Board">
			<xsl:element name="li">
				<xsl:choose>
					<xsl:when test="Indent[.=30]">
						<xsl:attribute name="class">board</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="class">childboard</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:element name="a">
					<xsl:attribute name="href">
					<!--<xsl:value-of select="/DvbbsArchiver/AppInfo/BaseHref"/>board/<xsl:value-of select="ID"/>/index<xsl:value-of select="/DvbbsArchiver/AppInfo/FileExtension"/>					-->
					<xsl:value-of select="/DvbbsArchiver/AppInfo/BaseHref"/>board<xsl:value-of select="/DvbbsArchiver/AppInfo/FileExtension"/>?boardid=<xsl:value-of select="ID"/>
					</xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="Subject"/></xsl:attribute>
					<xsl:value-of select="Name"/>
				</xsl:element>
				<span class="indent-left t3 small">
					<xsl:value-of select="Topics"/> / <xsl:value-of select="Posts"/>
				</span>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
