<?xml version='1.0' encoding='gb2312'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--  -->
	<xsl:import href='imports.xsl'/>

	<!-- ģ -->
	<xsl:template match='/'>
		<html>
			<head>
				<xsl:call-template name='part_header'/>
				<link href='../css/topic.css' rel='stylesheet' type='text/css' />
				<style rel='stylesheet'>
				textarea.content	{
					overflow-y:		visible;
					margin-bottom:	20px;
					border:			0px;
					width:			100%;
					height:			60px;
					color:			black;
				}
				pre.content	{
					margin-bottom:	18px;
					border:			0px;
					width:			100%;
					color:			black;
					font-family:	 !important, tahoma, sans-serif;
					font-size:		12px !important;
					line-height:	20px;
				}
				</style>
			</head>
			<body>
				<div id='topdiv'>
					<a name='top'></a>
					<br />
					<span class='t2'>[XMLͼ]</span>
					<br />
					
					<xsl:element name='a'>
						<xsl:attribute name='href'>index<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/></xsl:attribute>
						<xsl:value-of select='DvbbsArchiver/AppInfo/ForumName'/>
					</xsl:element>
					<span style='margin-left:10px;margin-right:10px'></span>
					<xsl:element name='a'>
						<xsl:attribute name='href'><xsl:value-of select='DvbbsArchiver/AppInfo/BaseHref'/>board<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>?boardid=<xsl:value-of select='DvbbsArchiver/Location/BoardId'/></xsl:attribute>
						<xsl:value-of select='DvbbsArchiver/Location/BoardName'/>
					</xsl:element>
					<span style='margin-left:10px;margin-right:10px'></span>
					<xsl:element name='a'>
						<xsl:attribute name='href'><xsl:value-of select='DvbbsArchiver/AppInfo/BaseHref'/>topic<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>?topicid=<xsl:value-of select='DvbbsArchiver/Location/TopicId'/></xsl:attribute>
						<xsl:value-of select='DvbbsArchiver/Location/TopicCaption'/>
					</xsl:element>

					<!-- ÷ҳģ -->
					<xsl:apply-templates select='DvbbsArchiver/PagerParams'/>
					<!-- б -->
					<xsl:apply-templates select='DvbbsArchiver/Replies'/>
					<xsl:if test='DvbbsArchiver/PagerParams/TotalRows[.&gt;10]'>
						<!-- Clone÷ҳģ -->
						<xsl:apply-templates select='DvbbsArchiver/PagerParams'/>
					</xsl:if>
					<!-- ÷ҳ -->
					<xsl:call-template name='script_pagination'/>

					<div id='modelinks'>
						<span class='t1'>[Full]</span>
						 :
						<xsl:element name='a'>
							<xsl:attribute name='href'><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../../topic.aspx?topicid=<xsl:value-of select='DvbbsArchiver/Location/TopicId'/></xsl:attribute>
							<xsl:attribute name='target'>_blank</xsl:attribute>
							<xsl:value-of select='DvbbsArchiver/Location/TopicCaption'/>
						</xsl:element>
						<br/>
						<span class='t1'>[XHTML]</span>
						XHTMLͼ :
						<xsl:element name='a'>
							<xsl:attribute name='href'><xsl:value-of select="DvbbsArchiver/AppInfo/BaseHref"/>../xhtml/topic/<xsl:value-of select='DvbbsArchiver/Location/TopicId'/>/index<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/></xsl:attribute>
							<xsl:attribute name='target'>_blank</xsl:attribute>
							<xsl:value-of select='DvbbsArchiver/Location/TopicCaption'/>
						</xsl:element>
					</div>

					<!-- ҳ -->
					<xsl:call-template name='part_footer'/>
				</div>
			</body>
		</html>
	</xsl:template>

	<!-- бģ -->
	<xsl:template match='DvbbsArchiver/Replies'>
		<div id='replylist'>
			<div class='topic-caption grid'>
				: 
				<span class='indent-left t1'>
					<xsl:value-of select='../Location/TopicCaption'/>
				</span>
			</div>
			<xsl:for-each select='Reply'>
				<div class='reply-caption grid'>
					<ul>
						<li class='reply-author'>
							<xsl:element name='a'>
								<xsl:attribute name='target'>_blank</xsl:attribute>
								<xsl:attribute name='href'><xsl:value-of select="/DvbbsArchiver/AppInfo/BaseHref"/>user_profile<xsl:value-of select='/DvbbsArchiver/AppInfo/FileExtension'/>?name=<xsl:value-of select='Author'/></xsl:attribute>
								<xsl:value-of select='Author'/>
							</xsl:element>
							<span class='reply-addtime'>
								<xsl:choose>
									<xsl:when test='Floor[.=1]'> </xsl:when>
									<xsl:otherwise> ظ</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select='PostTime'/>
							</span>
						</li>
						<li class='reply-floor'>
							<xsl:element name='a'>
								<xsl:attribute name='class'>t3</xsl:attribute>
								<xsl:attribute name='href'>javascript:void(0)</xsl:attribute>
								<xsl:attribute name='title'>չ/۵</xsl:attribute>
								<xsl:attribute name='onclick'>javascript:collapse(this,<xsl:value-of select='Floor'/>);</xsl:attribute>
								<b><xsl:value-of select='Floor'/></b>¥
								<xsl:if test='Floor[.=1]'>[¥]</xsl:if>
							</xsl:element>
						</li>
					</ul>
				</div>
				<xsl:element name='div'>
					<xsl:attribute name='class'>reply-content grid</xsl:attribute>
					<xsl:attribute name='id'>floor_<xsl:value-of select='Floor'/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="../../AppInfo/UserAgent[.='Firefox']">
							<xsl:element name='pre'>
								<xsl:attribute name='class'>content</xsl:attribute>
								<xsl:attribute name='wrap'>wrap</xsl:attribute>
								<xsl:value-of select='Content'/>
							</xsl:element>
						</xsl:when>
						<xsl:otherwise>
							<xsl:element name='textarea'>
								<xsl:attribute name='class'>content</xsl:attribute>
								<xsl:attribute name='readonly'>readonly</xsl:attribute>
								<xsl:value-of select='Content'/>
							</xsl:element>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:for-each>
		</div>
	</xsl:template>

</xsl:stylesheet>
