var imageName = "";
var imageNumber = 0;
var nextImageToDisplay = 0;
var fadeOutCompleted;

function loadGalleryImages(sender, args) {

	// load the images from the array into
	// the gallery canvases
	var target = null;
	for (var i=0; i<photoArray.length; i++) {
		if (i < 10) {
			var imageName = "imageBrush0" + i;
		}
		else {
			var imageName = "imageBrush" + i;
		}
		target = sender.findName(imageName);
		if (target)
		{
			target.ImageSource = photoArray[i];
		}
	}
	
	for (var i=8; i<photoArray.length; i++) {
		if (i < 10) {
			var imageName = "reflectionBrush0" + i;
		}
		else {
			var imageName = "reflectionBrush" + i;
		}		
		target = sender.findName(imageName);
		if (target)
		{
			target.ImageSource = photoArray[i];
		}
	}

	sender.findName("displayImage").ImageSource = photoArray[0];
	sender.findName("displayImagePaneReflectionImage").ImageSource = photoArray[0];
	sender.findName("galleryTitleText").text = galleryTitle;

	sender.findName("labelText").text = photoLabels[0];
	sender.findName("labelTextShadow").text = photoLabels[0];
	sender.findName("labelTextReflection").text = photoLabels[0];
	sender.findName("labelTextShadowReflection").text = photoLabels[0];
	var textCenter = sender.findName("rightWall").width / 2;
	var labelCenter = textCenter - (sender.findName("labelText").ActualWidth / 2);
	
	sender.findName("labelText")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadow")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextReflection")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadowReflection")["Canvas.Left"] = labelCenter;

	sender.findName("timer").begin();
	sender.findName("timer").addEventListener("completed", doSlideshow);
}


function showOutline(sender,args) {
	sender.strokeThickness = 2;
	sender.stroke = "#000000";

	outlineObjectName = sender.name;
	outlineImageNumber = outlineObjectName.substring(5, outlineObjectName.length);

	if (outlineImageNumber >= 8) {	
		var reflection = "reflectionImage" + outlineImageNumber;

		sender.findName(reflection).strokeThickness = 2;
		sender.findName(reflection).stroke = "#000000";
	}
}

function hideOutline(sender,args) {
	sender.strokeThickness = 0;

	outlineObjectName = sender.name;
	outlineImageNumber = outlineObjectName.substring(5, outlineObjectName.length);

	if (outlineImageNumber >= 8) {	
		var reflection = "reflectionImage" + outlineImageNumber;
		sender.findName(reflection).strokeThickness = 0;
	}
}

function displayImage(sender,args) {
	sender.findName("timer").stop();
	objectName = sender.name;
	imageNumber = objectName.substring(5, objectName.length);
	imageName = "imageBrush" + imageNumber;	
	sender.findName("fadeOutImage").begin();
	sender.findName("fadeOutImage").addEventListener("completed", showNextImage);
}

function showNextImage(sender, args) {
	imageNumber *= 1;
	
	sender.findName("labelText").text = photoLabels[imageNumber];
	sender.findName("labelTextShadow").text = photoLabels[imageNumber];
	sender.findName("labelTextReflection").text = photoLabels[imageNumber];
	sender.findName("labelTextShadowReflection").text = photoLabels[imageNumber];
	var textCenter = sender.findName("rightWall").width / 2;
	var labelCenter = textCenter - (sender.findName("labelText").ActualWidth / 2);
	
	sender.findName("labelText")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadow")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextReflection")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadowReflection")["Canvas.Left"] = labelCenter;	
	
	sender.findName("displayImage").ImageSource = sender.findName(imageName).imageSource;
	sender.findName("displayImagePaneReflectionImage").ImageSource = sender.findName(imageName).imageSource;
	sender.findName("fadeInImage").begin();
	sender.findName("timer").begin();
}

function doSlideshow(sender, args) {

	// find out which image is currently being displayed
	objectName = sender.findName("displayImage").ImageSource;
	for (var i=0; i<photoArray.length; i++) {
		if (objectName == photoArray[i]) {
			imageNumber = i;
			break;
		}
	}

	nextImageToDisplay = imageNumber + 1;
	displayImages(sender, args);
	sender.findName("timer").begin();
}

function displayImages(sender, args) {
	sender.findName("fadeOutImage").begin();
	fadeOutCompleted = sender.findName("fadeOutImage").addEventListener("completed", nextSlide);
}

function nextSlide(sender, args) {
	sender.findName("fadeOutImage").removeEventListener("completed", fadeOutCompleted);
	
	if (nextImageToDisplay == (photoArray.length)) {
		nextImageToDisplay = 0;
	}
	
	if (nextImageToDisplay < 10) {
		var imageName = "imageBrush0" + nextImageToDisplay;
	}
	else {
		var imageName = "imageBrush" + nextImageToDisplay;
	}

	sender.findName("labelText").text = photoLabels[nextImageToDisplay];
	sender.findName("labelTextShadow").text = photoLabels[nextImageToDisplay];
	sender.findName("labelTextReflection").text = photoLabels[nextImageToDisplay];
	sender.findName("labelTextShadowReflection").text = photoLabels[nextImageToDisplay];
	var textCenter = sender.findName("rightWall").width / 2;
	var labelCenter = textCenter - (sender.findName("labelText").ActualWidth / 2);
	
	sender.findName("labelText")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadow")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextReflection")["Canvas.Left"] = labelCenter;
	sender.findName("labelTextShadowReflection")["Canvas.Left"] = labelCenter;
	
	sender.findName("displayImage").ImageSource = sender.findName(imageName).imageSource;
	sender.findName("displayImagePaneReflectionImage").ImageSource = sender.findName(imageName).imageSource;
	sender.findName("fadeInImage").begin();
}