﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Net.Sockets;
using System.Net;

namespace FileClient
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        //_5_1_a_s_p_x
        //连接
        private void btnConnect_Click(object sender, EventArgs e)
        {
            Thread mythread = new Thread(GetData); 
            mythread.Start();
        }

        //接受数据
        private void GetData()
        {
            IPEndPoint ipep = new IPEndPoint(IPAddress.Parse("127.0.0.1"), 8080);
            Socket clientsocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            try
            {
                listBox1.Items.Add("连接远程服务器成功");
                clientsocket.Connect(ipep);
            }
            catch (Exception)
            {
                listBox1.Items.Add("连接远程服务器失败");
            }

            //接收文件的名称          
            string filename = System.Text.Encoding.UTF8.GetString(ReceiveStrToByte(clientsocket)).Split('\0')[0];
           
            //创建一个新文件        
            FileStream MyFileStream = new FileStream(filename, FileMode.Create, FileAccess.Write);

            int PacketSize = 5000;
            //定义一个完整数据包缓存  
            byte[] data = new byte[PacketSize];
            while (true)
            {
                int revcount = clientsocket.Receive(data, 0, PacketSize, SocketFlags.None);
                if (revcount == 0)
                {
                    data = null;
                    break;
                }
                //处理最后一个数据包    
                if (revcount != PacketSize)
                {
                    byte[] lastdata = new byte[revcount];
                    for (int i = 0; i < revcount; i++)
                        lastdata[i] = data[i];
                    //将接收到的最后一个数据包写入到文件流对象      
                    MyFileStream.Write(lastdata, 0, lastdata.Length);
                    lastdata = null;
                }
                else
                {
                    //将接收到的数据包写入到文件流对象      
                    MyFileStream.Write(data, 0, data.Length);
                }
            }
            //关闭文件流       
            MyFileStream.Close();
            //关闭套接字           
            clientsocket.Close();
            listBox1.Items.Add(string.Format("{0}接收完毕", filename));
          
        }

        private byte[] ReceiveStrToByte(Socket s)
        {
            try
            {
                byte[] dataninfo = new byte[100];
                int revByteNum = s.Receive(dataninfo, 0, dataninfo.Length, SocketFlags.None);
                byte[] retByte = new byte[revByteNum];
                for (int i = 0; i < revByteNum; i++)
                    retByte[i] = dataninfo[i];
                return retByte;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                return null;
            }
        }
    }
}
