﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using Wuqi.Webdiyer;

namespace DAL
{
    public class DataBase
    {
        private SqlConnection Conn;
        private SqlCommand Cmd;
        private SqlDataAdapter Da;
        private DataTable Dt;
        private DataSet Ds;
        private string strConn;


        /// <summary>
        /// 数据操作类构造函数
        /// </summary>
        public DataBase()
        {
            strConn = ConfigurationManager.AppSettings["ConnStr"];
        }

        /// <summary>
        /// 打开数据库连接
        /// </summary>
        public void Open()
        {
            if (Conn == null)
                Conn = new SqlConnection(strConn);
            if (Conn.State.Equals(ConnectionState.Closed))
                Conn.Open();
        }


        /// <summary>
        /// 关闭连接并释放资源
        /// </summary>
        public void Close()
        {
            if (Conn.State == ConnectionState.Open)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }

        /// <summary>
        /// 执行CMD类
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns>返回CMD</returns>
        public int ExecuteCmd(string sql)
        {
            try
            {
                Open();
                Cmd = new SqlCommand(sql,Conn);
                return Cmd.ExecuteNonQuery();
                
            }
            catch(Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }

        /// <summary>
        /// DataTable类
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns>返回DataTable</returns>
        public DataTable GetDataTable(string sql)
        {
            try
            {
                Open();
                Da = new SqlDataAdapter(sql, Conn);
                Dt = new DataTable();
                Da.Fill(Dt);
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
            return Dt;
        }

        /// <summary>
        /// 验证类
        /// </summary>
        /// <param name="sql">sql语句</param>
        /// <returns>返回Cmd</returns>
        public int ExecuteRead(string sql)
        {
            try
            {
                Open();
                Cmd = new SqlCommand(sql, Conn);
                return (int)Cmd.ExecuteScalar();
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }

        /// <summary>
        /// DataSet类
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns>返回一个DataSet</returns>
        public DataSet GetDataSet(string sql)
        {
            try
            {
                Open();
                Da = new SqlDataAdapter(sql, Conn);
                Ds = new DataSet();
                Da.Fill(Ds);
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            return Ds;
        }

        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="Pager"></param>
        /// <param name="sql"></param>
        /// <param name="tabel"></param>
        /// <returns></returns>
        public DataSet AspPager(AspNetPager Pager, string sql, string tabel)
        {
            try
            {
                Open();
                Da = new SqlDataAdapter(sql, Conn);
                Ds = new DataSet();
                Da.Fill(Ds, Pager.PageSize * (Pager.CurrentPageIndex - 1), Pager.PageSize, tabel);
                return Ds;
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }
    }
}
