﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.IO;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

[AjaxPro.AjaxNamespace("telesa")]
public partial class Admin_Admin_AddDoc : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = ConfigurationManager.AppSettings["WebName"].ToString() + " - 添加文档";

        TextBox1.ToolTip = "请输入文档名称 50字符!";
        TextBox2.ToolTip = "请输入文档作者 10字符!";
        TextBox3.ToolTip = "请输入提交者单位 30字符";
        TextBox4.ToolTip = "请输入文档关键字 30字符";
        type.ToolTip = "请输入异常类型 50字符";
        start.ToolTip = "请输入异常开始天数 格式:2008-08-08";
        exist.ToolTip = "请输入异常持续天数 匹配为数字!";
        invester.ToolTip = "请输入异常落实人 50字符";
        investerTime.ToolTip = "请输入异常落实时间 50字符";
        Concl.ToolTip = "请输入文档的结论 50字符";
        TextBox5.ToolTip = "请输入文档备注 50字符";
        start.ToolTip = "请输入文档的内容或者图片 无限制";
        TextBox6.ToolTip = "请输入异常地点";
        
        if (!IsPostBack)
        {
            BLL.Message.IsAdmin();
        }
        AjaxPro.Utility.RegisterTypeForAjax(typeof(Admin_Admin_AddDoc));
        exist.Attributes.Add("onchange", "day();");
        TextBox1.Attributes.Add("onchange", "docname();");
    }

    [AjaxPro.AjaxMethod]
    public int getInt(string str)
    {
        int i;
        if (BLL.Message.PositiveInteger(str))
        {
            return i = 1;
        }
        else 
        {
            return i = 2;
        }
    }

    [AjaxPro.AjaxMethod]
    public int getDocName(string str)
    {
        int i;
        BLL.Business Pn163 = new BLL.Business();
        if (Pn163.ReadDocName(str))
        {
            return i = 1;
        }
        else
        {
            return i = 2;
        }
    }

    //添加事件
    protected void Sub_Click(object sender, EventArgs e)
    {
        Model.Document User = new Model.Document();

        BLL.Business Pn163 = new BLL.Business();

        User.DocName = TextBox1.Text;

        User.DocWriter = TextBox2.Text;

        User.DocSumit = TextBox3.Text;

        User.DocUpTime = DateTime.Now.ToString();

        User.Date = DateTime.Now.Year.ToString();

        User.DocInvTime = investerTime.Text;

        User.DocStore = store_doc.Value;

        User.Abstract = TextBox4.Text;

        User.DownUrl = Label1.Text;

        User.Size = Label2.Text;

        User.Memo = TextBox5.Text;

        User.Adder = Session["Admin"].ToString();

        User.Type = type.Text;

        User.Start = start.Text;

        User.Exist = exist.Text;

        User.Invester = invester.Text;

        User.Concl = Concl.Text;

        User.address = TextBox6.Text;

        if (!String.IsNullOrEmpty(User.DocName) &&
            !String.IsNullOrEmpty(User.DocSumit) && 
            !String.IsNullOrEmpty(User.Abstract) && 
            !String.IsNullOrEmpty(User.Type))
        {
            if (Pn163.AddDoc(User) > 0)
            {
                Response.Write("<script>alert('添加成功!');location.href='./Admin_Doc.aspx'</script>");
            }
            else Response.Write("<script>alert('添加失败');</script>");
        }
        else Response.Write("<script>alert('带*号的项不能为空!');</script>");
    }

    //上传事件
    protected void UpFile_Click(object sender, EventArgs e)
    {
        if (FileUpload1.HasFile)
        {
            UpModel File = Upload.UpFile(FileUpload1, "..\\DocFiles\\");
            Label1.Text = "DocFiles\\" + File.address.ToString();
            Label2.Text = File.size.ToString() + " Kb ";
        }
        else Response.Write("<script>alert('请选择要上传的文件!');history.go(-1);</script>");
    }
}
