﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
//http://www.51aspx.com/CV/DadaDocument
public partial class Admin_Admin_Doc : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        BLL.Message.IsAdmin();
        if (!IsPostBack)
        {
            Title = ConfigurationManager.AppSettings["WebName"].ToString() + " - 文档管理";
            this.labPage.Text = "1";
            this.contrlRepeater();
            BLL.Business Pn163 = new BLL.Business();
            Count.Text = Pn163.getCount().ToString();
        }
    }

    /// <summary>
    /// 分页
    /// </summary>
    protected void contrlRepeater()
    {
        BLL.Business Pn163 = new BLL.Business();
        PagedDataSource pds = new PagedDataSource();
        DataSet Ds = Pn163.DocDataSet();
        pds.DataSource = Ds.Tables[0].DefaultView;
        pds.AllowPaging = true;
        pds.PageSize = 15;                          //每页显示数
        pds.CurrentPageIndex = Convert.ToInt32(this.labPage.Text) - 1;
        Repeater1.DataSource = pds;
        LabCountPage.Text = pds.PageCount.ToString();
        labPage.Text = (pds.CurrentPageIndex + 1).ToString();
        this.lbtnpritPage.Enabled = true;
        this.lbtnFirstPage.Enabled = true;
        this.lbtnNextPage.Enabled = true;
        this.lbtnDownPage.Enabled = true;
        if (pds.CurrentPageIndex < 1)
        {
            this.lbtnpritPage.Enabled = false;
            this.lbtnFirstPage.Enabled = false;
        }
        if (pds.CurrentPageIndex == pds.PageCount - 1)
        {
            this.lbtnNextPage.Enabled = false;
            this.lbtnDownPage.Enabled = false;
        }
        Repeater1.DataBind();    
    }

    //单选删除
    protected void DelComm_Click(object sender, CommandEventArgs e)
    {
        if (Session["Comp"].ToString() == "2")
        {
            BLL.Message.Show("你没有该栏目的管理权限");
        }
        else
        {
            Model.Document User = new Model.Document();
            User.id = Convert.ToInt32(e.CommandName);
            BLL.Business Pn163 = new BLL.Business();
            Pn163.DelDoc(User);
            Response.Redirect("./Admin_Doc.aspx");
        }
    }

    //多选删除
    protected void DelCheckBox_Click(object sender,EventArgs e)
    {
        if (Session["Comp"].ToString() == "2")
        {
            BLL.Message.Show("你没有该栏目的管理权限");
        }
        else
        {
            for (int x = 0; x < Repeater1.Items.Count; x++)
            {
                BLL.Business Pn163 = new BLL.Business();
                Model.Document User = new Model.Document();
                CheckBox Cb = (CheckBox)Repeater1.Items[x].FindControl("CheckBox1");
                HiddenField Hf = (HiddenField)Repeater1.Items[x].FindControl("HiddenField1");
                if (Cb.Checked)
                {
                    User.id = Convert.ToInt32(Hf.Value);
                    Pn163.DelDoc(User);
                }
            }
            Response.Redirect("./Admin_Doc.aspx");
        }
    }


    //首页
    protected void lbtnFirstPage_Click(object sender, EventArgs e)
    {
        this.labPage.Text = "1";
        this.contrlRepeater();
    }

    //上一页
    protected void lbtnpritPage_Click(object sender, EventArgs e)
    {
        this.labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) - 1);
        this.contrlRepeater();
    }

    //下一页
    protected void lbtnDownPage_Click(object sender, EventArgs e)
    {
        this.labPage.Text = this.LabCountPage.Text;
        this.contrlRepeater();
    }

    //尾页
    protected void lbtnNextPage_Click(object sender, EventArgs e)
    {
        this.labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) + 1);
        this.contrlRepeater();
    }

    protected void Se_Click(object sender, EventArgs e)
    {
        Response.Redirect("./Admin_Search.aspx?name=" + TextBox1.Text);
    }
}
