﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Smark.Data;
using Smark.Web.Services;
using Smark.Web.Binders;
using Smark.Web;
namespace FileWebManage
{


    [AttributeUsage(AttributeTargets.Class)]
    public class SetConnectionAttribute : Smark.Web.FilterAttribute
    {
        static bool IsChangeConnection = false;
        protected override void OnExecute(Smark.Web.Action action)
        {
            if (!IsChangeConnection)
            {
                string dbpath = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source={0}app_data\data.mdb";
                DBContext.SetConnectionString(ConnectionType.Context1, string.Format(dbpath, MVCContext.Current.Http.Request.PhysicalApplicationPath));
                IsChangeConnection = true;
            }
        }
    }
    public class Encrypt : Smark.Data.Mappings.PropertyCastAttribute
    {
        public Encrypt()
        {

        }
        public BlowfishNET.JavaInterop.BlowfishEasy Blowfish
        {
            get;
            set;
        }
        public override object ToProperty(object value, Type ptype, object source)
        {
            return DecryptString(value.ToString());
        }

        public override object ToColumn(object value, Type ptype, object source)
        {
            return EncryptString(value.ToString());
        }
        public static string EncryptString(string value)
        {
            return mBlowfish.EncryptString(value);
        }
        public static string DecryptString(string value)
        {
            return mBlowfish.DecryptString(value);
        }
        static BlowfishNET.JavaInterop.BlowfishEasy mBlowfish = new BlowfishNET.JavaInterop.BlowfishEasy("sadfksdfsklad");
    }
    [AttributeUsage(AttributeTargets.Class)]
    public class CertificateFilter : Smark.Web.FilterAttribute
    {
        protected override void OnExecute(Smark.Web.Action action)
        {
            ICertificate cer = action as ICertificate;
            if (cer != null)
                Untity.CheckCertificate(cer.ClientID);
        }
    }
    [AttributeUsage(AttributeTargets.Class)]
    public class AdminFilter : Smark.Web.FilterAttribute
    {
        protected override void OnExecute(Smark.Web.Action action)
        {
            ICertificate cer = action as ICertificate;
            if (cer != null)
            {
                if (!Untity.GetByClientID(cer.ClientID).IsAdmin)
                    throw new Exception("你不是管理员没权进行该操作!");
            }
        }
    }
    
    /// <summary>
    /// 业务控制器
    /// </summary>
    [Controller("/")]
    [SetConnectionAttribute]
    [CertificateFilter]
    public class Controller
    {
        /// <summary>
        /// 基础控制器
        /// </summary>
        public class UserBaseAction : Smark.Web.Action, ICertificate
        {
            public string ClientID
            {
                get;
                set;
            }
            [Bind(Convert= typeof(BindLoginer))]
            public User Loginer
            {
                get;
                set;
            }
        }
        /// <summary>
        /// 凭证转换器
        /// </summary>
        public class BindLoginer : IConvert
        {
            #region IConvert 成员

            public object Parse(System.Collections.Specialized.NameValueCollection data, string key, string prefix, out bool succeed)
            {
                succeed = true;
                return Untity.GetByClientID(data["clientid"]);
            }

            #endregion
        }

        /// <summary>
        /// 登陆
        /// </summary>
        [ActionMapper]
        public class Login : Smark.Web.Action
        {
            public string UserName
            {
                get;
                set;
            }
            public string UserPWD
            {
                get;
                set;
            }
            [OutputXml]
            public string ClientID
            {
                get;
                set;
            }
            [OutputXml]
            public int UploadSize
            {
                get;
                set;
            }
            public Smark.Web.Actions.ImageValidate IV
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                lock (typeof(Register))
                {
                    IV.Check();
                    Expression exp = User.userName == UserName;
                    User loginer = exp.ListFirst<User>();
                    if (loginer == null)
                        throw new Exception("用户名或密码不正确!");
                    if (loginer.UserPWD.ToLower() != UserPWD.ToLower())
                        throw new Exception("用户名或密码不正确!");
                    if (!loginer.Enabled)
                        throw new Exception("该用户已经禁用，请与管理员联系!");
                    ClientID = Untity.CreateClientID(loginer.UserName).ClientID;
                    UploadSize = loginer.UploadSize;
                    base.OnExecute();
                }
            }
        }
          
        
       /// <summary>
       /// 注册
       /// </summary>
        [ActionMapper]
        public class Register:Smark.Web.Action
        {
            
            public User User
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                IV.Check();
               
                User.Enabled = true;
                User.UploadSize = 10240;
                User.Save();
                System.IO.Directory.CreateDirectory(Untity.RootPath + User.UserName);
                base.OnExecute();
            }
            public Smark.Web.Actions.ImageValidate IV
            {
                get;
                set;
            }
           
        }

        /// <summary>
        /// 用户查询
        /// </summary>
        [AdminFilter]
        [ActionMapper]
        public class UserList : UserBaseAction
        {
            public string MatchName
            {
                get;
                set;
            }
            [Bind(Fungible=typeof(List<User>))]
            [OutputXml]
            public IList<UserView> Items
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                Items = User.userName.Match(MatchName).List<UserView>();
                base.OnExecute();
            }
        }
        
        /// <summary>
        /// 删除用户
        /// </summary>
        [AdminFilter]
        [ActionMapper]
        public class DeleteUser : UserBaseAction
        {
            public string[] UserID
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                (User.userID == UserID).Delete<User>();
                base.OnExecute();
            }
        }

        /// <summary>
        /// 设置用户有效性
        /// </summary>
        [AdminFilter]
        [ActionMapper]
        public class EnabledUser : UserBaseAction
        {
            public string[] UserID
            {
                get;
                set;
            }
            public bool Enabled
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                (User.userID == UserID).Edit<User>(User.enabled.NewValue(Enabled));
                base.OnExecute();
            }
        }
        
        /// <summary>
        /// 内容查询
        /// </summary>
        [ActionMapper]
         public class ContentList : UserBaseAction
        {
            [OutputXml]
            public string Path
            {
                get;
                set;
            }
           
            [OutputXml]
            [Bind(Fungible = typeof(List<FileItem>))]
            public IList<FileItem> Items
            {
                get;
                set;
            }
            public bool Previous
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                string userroot = Untity.RootPath+Loginer.UserName+@"\";
                if (Previous)
                {
                    
                    
                    int index=Path.LastIndexOf(@"\");
                    if ( index>= 0)
                    {
                        Path = Path.Substring(0, index);
                        
                    }
                    else
                    {
                        Path = "";
                    }
                    if(!string.IsNullOrEmpty(Path))
                        Path =  Path + @"\";
                }
                if (string.IsNullOrEmpty(Path))
                {
                    Path = userroot;
                }
                else
                {

                    Path = userroot + Path;
                   
                }

                string parent = null;
                string parentpath = "";
                if (Path != userroot)
                {
                    Items.Add(new FileItem { Name = "\\", Path = userroot, Type = ItemType.Folder });
                    parentpath = Path.Substring(0, Path.LastIndexOf("\\"));
                    if (parentpath.Length < userroot.Length)
                        parentpath += "\\";
                    Items.Add(new FileItem { Name = "..", Path = parentpath, Type = ItemType.Folder });
                }
                foreach (string item in GetFolder(Path,""))
                {
                    Items.Add(new FileItem { Name = System.IO.Path.GetFileName(item), Path = PressPath(item), Type = ItemType.Folder });
                    Items[Items.Count - 1].CreateDate = System.IO.Directory.GetCreationTime(item).ToShortDateString();
                }
                foreach (string item in GetFiles(Path, parent))
                {
                    Items.Add(new FileItem { Name = System.IO.Path.GetFileName(item), Path = item, Type = ItemType.File });
                    Items[Items.Count - 1].CreateDate = System.IO.File.GetCreationTime(item).ToShortDateString();
                    System.IO.FileInfo fi = new System.IO.FileInfo(item);
                    Items[Items.Count - 1].Size = ((decimal)fi.Length / 1024m).ToString("##,###,##0.#(KB)");
                    Items[Items.Count - 1].FileType = System.IO.Path.GetExtension(item);
                    Items[Items.Count - 1].FileType = Items[Items.Count - 1].FileType.Substring(1, Items[Items.Count - 1].FileType.Length - 1);
                }
                foreach (FileItem item in Items)
                {
                    item.Path = item.Path.Replace(userroot, "");
                }


                Path = Path.Replace(userroot, "");
                base.OnExecute();
            }
            static string[] GetFolder(string path, string parent)
            {
                if (parent != null)
                    return System.IO.Directory.GetDirectories(path);
                return System.IO.Directory.GetDirectories(path);
            }
            static string[] GetFiles(string path, string parent)
            {
                if (parent != null)
                    return System.IO.Directory.GetFiles(path, parent);
                return System.IO.Directory.GetFiles(path);
            }
            private string PressPath(string path)
            {
                if (path.Substring(path.Length - 1, 1) != @"\")
                    return path + @"\";
                        return path;
            }
        }

        /// <summary>
        /// 内容删除
        /// </summary>
        [ActionMapper]
        public class ContentDelete : UserBaseAction
        {
            public string Path
            {
                get;
                set;
            }
            public ItemType Type
            {
                get;
                set;
            }
            public string Resource
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                string resourcepath = Untity.RootPath + Loginer.UserName + @"\" + Path + Resource;
                if (Type == ItemType.Folder)
                {
                    System.IO.Directory.Delete(resourcepath, true);
                }

                else
                {
                    System.IO.File.Delete(resourcepath);
                }
                base.OnExecute();
            }
        }


        /// <summary>
        /// 创建目录
        /// </summary>
        [ActionMapper]
        public class NewFolder : UserBaseAction
        {
            public string Path
            {
                get;
                set;
            }
            public string FolderName
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                if (string.IsNullOrEmpty(Path))
                    Path = Untity.RootPath+Loginer.UserName+@"\";
                else
                    Path = Untity.RootPath + Loginer.UserName + @"\" + Path;
                System.IO.Directory.CreateDirectory(Path + FolderName);
                base.OnExecute();
            }
        }
        
        /// <summary>
        /// 上传文件
        /// </summary>
        [ActionMapper]
        [UploadFilter]
        public class UploadFile : UserBaseAction
        {
            public string Path
            {
                get;
                set;
            }
            public IList<PostFile> Files
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                if (string.IsNullOrEmpty(Path))
                    Path = Untity.RootPath+Loginer.UserName+@"\";
                else
                    Path = Untity.RootPath + Loginer.UserName + @"\" + Path;
          
                foreach (PostFile item in Files)
                {
                    item.Save(Path + item.File.FileName);
                }
                base.OnExecute();
            }
        }
        
        [AdminFilter]
        [ActionMapper]
        public class SetPermissions : UserBaseAction
        {
            public string UserID
            {
                get;
                set;
            }
            public string Folder
            {
                get;
                set;
            }
            public bool CanModify
            {
                get;
                set;
            }
            public bool CanUpload
            {
                get;
                set;
            }
            public bool CanDownload
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                Permissions per = (Permissions.folder == Folder & Permissions.userID == UserID).ListFirst<Permissions>();
                if (per == null)
                {
                    per = new Permissions();
                    per.UserID = UserID;
                    per.Folder = Folder;
                    

                }

                per.CanModify = CanModify;
                    per.CanUpload= CanUpload;
                    per.CanDownload = CanDownload;
                per.Save();
                base.OnExecute();
            }
        }
        
        /// <summary>
        /// 文件下载
        /// </summary>
        [ActionMapper]
        [DownLoadFilter]
        public class FileDownload : UserBaseAction
        {
            public string Path
            {
                get;
                set;
            }
            public string FileName
            {
                get;
                set;
            }
            protected override void OnExecute()
            {
                string resourceurl = Untity.RootPath + Loginer.UserName + @"\" + Path+FileName;
                    MVCContext.Current.Http.Response.Clear();
                    MVCContext.Current.Http.Response.WriteFile(resourceurl);
                    MVCContext.Current.Http.Response.Flush();
                    MVCContext.Current.Http.Response.End();
                
                base.OnExecute();
            }
        }
    }
    [AttributeUsage(AttributeTargets.Class)]
    public class DownLoadFilter : FilterAttribute
    {
        protected override void OnExecute(Smark.Web.Action action)
        {
            Controller.FileDownload fd = (Controller.FileDownload)action;
            switch (System.IO.Path.GetExtension(fd.FileName).ToLower())
            {
                case ".config":
                    throw new Exception("本类型文件无法下载!");
            }
        }
    }
    [AttributeUsage(AttributeTargets.Class)]
    public class UploadFilter : FilterAttribute
    {
        protected override void OnExecute(Smark.Web.Action action)
        {
            Controller.UploadFile uf = (Controller.UploadFile)action;
            foreach (PostFile item in uf.Files)
            {
                if (System.IO.Path.GetExtension(item.File.FileName).ToLower() == ".exe")
                {
                    throw new Exception("不能上传EXE文件!");
                }
            }
        }
    }

    public enum ItemType
    {
        Folder,
        File
    }
    public class FileItem
    {
        public ItemType Type
        {
            get;
            set;
        }
        public string Name
        {
            get;
            set;
        }
        public string Path
        {
            get;
            set;
        }
        public string Size
        {
            get;
            set;

        }
        public string FileType
        {
            get;
            set;
        }
        public string CreateDate
        {
            get;
            set;
        }
    }

}
