﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Smark.Data;
using Smark.Data.Mappings;
using Smark.Data.Validates;
namespace FileWebManage
{
    [Table("Users")]
	[Serializable]
    public class User:Smark.Data.Mappings.DataObject,IUser
    {
        
        [ID]
        [UID]
        public string UserID{get{ return mUserID;}set{mUserID=value;EntityState.FieldChange("UserID");}}

		private string mUserID;

		public static Smark.Data.FieldInfo userID = new Smark.Data.FieldInfo("Users","UserID");

        [Column]
        [NotNull("用户名不能为空")]
        [Unique("该用户名已经存在")]
        public string UserName { get{ return mUserName;} set{mUserName=value;EntityState.FieldChange("UserName");} }

		private string mUserName;

		public static Smark.Data.FieldInfo userName = new Smark.Data.FieldInfo("Users","UserName");

        [Column]
        public bool Enabled { get{ return mEnabled;} set{mEnabled=value;EntityState.FieldChange("Enabled");} }

		private bool mEnabled;

		public static Smark.Data.FieldInfo enabled = new Smark.Data.FieldInfo("Users","Enabled");

        [Column]
        public bool IsAdmin { get{ return mIsAdmin;} set{mIsAdmin=value;EntityState.FieldChange("IsAdmin");} }

		private bool mIsAdmin;

		public static Smark.Data.FieldInfo isAdmin = new Smark.Data.FieldInfo("Users","IsAdmin");

        [Column]
        [Encrypt]
        [NotNull("用户密码不能为空")]
        public string UserPWD { get{ return mUserPWD;} set{mUserPWD=value;EntityState.FieldChange("UserPWD");} }

		private string mUserPWD;

		public static Smark.Data.FieldInfo userPWD = new Smark.Data.FieldInfo("Users","UserPWD");

        [Column]
        public bool IsCreateUser { get{ return mIsCreateUser;} set{mIsCreateUser=value;EntityState.FieldChange("IsCreateUser");} }

		private bool mIsCreateUser;

		public static Smark.Data.FieldInfo isCreateUser = new Smark.Data.FieldInfo("Users","IsCreateUser");

        [Column]
        public string ParentID { get{ return mParentID;} set{mParentID=value;EntityState.FieldChange("ParentID");} }

		private string mParentID;

		public static Smark.Data.FieldInfo parentID = new Smark.Data.FieldInfo("Users","ParentID");

        [Column]
        public int UploadSize { get{ return mUploadSize;} set{mUploadSize=value;EntityState.FieldChange("UploadSize");} }

		private int mUploadSize;

		public static Smark.Data.FieldInfo uploadSize = new Smark.Data.FieldInfo("Users","UploadSize");

    }
    [Table("Users")]
	[Serializable]
    public class UserView:Smark.Data.Mappings.DataObject,IUserView
    {
        [Column]
        public string UserID { get{ return mUserID;} set{mUserID=value;EntityState.FieldChange("UserID");} }

		private string mUserID;

		public static Smark.Data.FieldInfo userID = new Smark.Data.FieldInfo("Users","UserID");

        [Column]
        public string UserName { get{ return mUserName;} set{mUserName=value;EntityState.FieldChange("UserName");} }

		private string mUserName;

		public static Smark.Data.FieldInfo userName = new Smark.Data.FieldInfo("Users","UserName");

        [Column]
        public bool Enabled { get{ return mEnabled;} set{mEnabled=value;EntityState.FieldChange("Enabled");} }

		private bool mEnabled;

		public static Smark.Data.FieldInfo enabled = new Smark.Data.FieldInfo("Users","Enabled");

        [Column]
        public bool IsAdmin { get{ return mIsAdmin;} set{mIsAdmin=value;EntityState.FieldChange("IsAdmin");} }

		private bool mIsAdmin;

		public static Smark.Data.FieldInfo isAdmin = new Smark.Data.FieldInfo("Users","IsAdmin");

        [Column]
        public bool IsCreateUser { get{ return mIsCreateUser;} set{mIsCreateUser=value;EntityState.FieldChange("IsCreateUser");} }

		private bool mIsCreateUser;

		public static Smark.Data.FieldInfo isCreateUser = new Smark.Data.FieldInfo("Users","IsCreateUser");

        [Column]
        public string ParentID { get{ return mParentID;} set{mParentID=value;EntityState.FieldChange("ParentID");} }

		private string mParentID;

		public static Smark.Data.FieldInfo parentID = new Smark.Data.FieldInfo("Users","ParentID");

        [Column]
        public int UploadSize { get{ return mUploadSize;} set{mUploadSize=value;EntityState.FieldChange("UploadSize");} }

		private int mUploadSize;

		public static Smark.Data.FieldInfo uploadSize = new Smark.Data.FieldInfo("Users","UploadSize");

    }
    [Table]
	[Serializable]
    public class Permissions:Smark.Data.Mappings.DataObject,IPermissions
    {
        [ID]
        [UID]
        public string PermissionID { get{ return mPermissionID;} set{mPermissionID=value;EntityState.FieldChange("PermissionID");} }

		private string mPermissionID;

		public static Smark.Data.FieldInfo permissionID = new Smark.Data.FieldInfo("Permissions","PermissionID");

        [Column]
        public string UserID { get{ return mUserID;} set{mUserID=value;EntityState.FieldChange("UserID");} }

		private string mUserID;

		public static Smark.Data.FieldInfo userID = new Smark.Data.FieldInfo("Permissions","UserID");

        [Column]
        public string Folder { get{ return mFolder;} set{mFolder=value;EntityState.FieldChange("Folder");} }

		private string mFolder;

		public static Smark.Data.FieldInfo folder = new Smark.Data.FieldInfo("Permissions","Folder");

        [Column]
        public bool CanUpload { get{ return mCanUpload;} set{mCanUpload=value;EntityState.FieldChange("CanUpload");} }

		private bool mCanUpload;

		public static Smark.Data.FieldInfo canUpload = new Smark.Data.FieldInfo("Permissions","CanUpload");

        [Column]
        public bool CanDownload { get{ return mCanDownload;} set{mCanDownload=value;EntityState.FieldChange("CanDownload");} }

		private bool mCanDownload;

		public static Smark.Data.FieldInfo canDownload = new Smark.Data.FieldInfo("Permissions","CanDownload");

        [Column]
        public bool CanDelete { get{ return mCanDelete;} set{mCanDelete=value;EntityState.FieldChange("CanDelete");} }

		private bool mCanDelete;

		public static Smark.Data.FieldInfo canDelete = new Smark.Data.FieldInfo("Permissions","CanDelete");

        [Column]
        public bool CanModify { get{ return mCanModify;} set{mCanModify=value;EntityState.FieldChange("CanModify");} }

		private bool mCanModify;

		public static Smark.Data.FieldInfo canModify = new Smark.Data.FieldInfo("Permissions","CanModify");

    }
}
