﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Smark.Data;
using Smark.Data.Mappings;
using Smark.Data.Validates;
namespace FileWebManage
{
    [Table("Users")]
    interface IUser
    {
        
        [ID]
        [UID]
        string UserID{get;set;}
        [Column]
        [NotNull("用户名不能为空")]
        [Unique("该用户名已经存在")]
        string UserName { get; set; }
        [Column]
        bool Enabled { get; set; }
        [Column]
        bool IsAdmin { get; set; }
        [Column]
        [Encrypt]
        [NotNull("用户密码不能为空")]
        string UserPWD { get; set; }
        [Column]
        bool IsCreateUser { get; set; }
        [Column]
        string ParentID { get; set; }
        [Column]
        int UploadSize { get; set; }
    }
    [Table("Users")]
    interface IUserView
    {
        [Column]
        string UserID { get; set; }
        [Column]
        string UserName { get; set; }
        [Column]
        bool Enabled { get; set; }
        [Column]
        bool IsAdmin { get; set; }
        [Column]
        bool IsCreateUser { get; set; }
        [Column]
        string ParentID { get; set; }
        [Column]
        int UploadSize { get; set; }
    }
    [Table]
    interface IPermissions
    {
        [ID]
        [UID]
        string PermissionID { get; set; }
        [Column]
        string UserID { get; set; }
        [Column]
        string Folder { get; set; }
        [Column]
        bool CanUpload { get; set; }
        [Column]
        bool CanDownload { get; set; }
        [Column]
        bool CanDelete { get; set; }
        [Column]
        bool CanModify { get; set; }
    }
}
