﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace FileWebManage
{
    public class Untity
    {
        public static string RootPath
        {
            get
            {
                return System.Configuration.ConfigurationManager.AppSettings["rootpath"];
            }
        }
        private static Dictionary<string, Certificate> mCertificates = new Dictionary<string, Certificate>();
        public static Dictionary<string, Certificate> Certificates
        {
            get
            {
                return mCertificates;
            }
        }
        public static void  CheckCertificate(string ClientID)
        {
            if(ClientID ==null)
                throw new Exception("你的凭证无效，请重新登陆!");
            if (!Certificates.ContainsKey(ClientID))
            {
                throw new Exception("你的凭证无效，请重新登陆!");
            }
            else
            {
                if (!Certificates[ClientID].UsefulLife)
                    throw new Exception("你的凭证已经过期，请重新登陆!");
            }
            
        }
        public static Certificate CreateClientID(string username)
        {
            lock (mCertificates)
            {
                Certificate item = new Certificate(username);
                if (Certificates.ContainsKey(item.ClientID))
                    Certificates[item.ClientID] = item;
                else
                    Certificates.Add(item.ClientID, item);
                return item;
            }
        }
        public static User GetByClientID(string clientid)
        {
            if(clientid !=null && Certificates.ContainsKey(clientid))
                return (User.userName == Certificates[clientid].UserName).ListFirst<User>();
            return null;
        }
        public static Permissions GetByUserAndFolder(string userid, string foler)
        {
            return (Permissions.userID == userid & Permissions.folder == foler).ListFirst<Permissions>();
        }

    
    }
    public class Certificate
    {
        public Certificate( string username)
        {
            LoginTime = DateTime.Now;
            UserName = username;
            Key = Guid.NewGuid().ToString("N");
            BlowfishNET.JavaInterop.BlowfishEasy be = new BlowfishNET.JavaInterop.BlowfishEasy(Key);
            ClientID = be.EncryptString(UserName);
        }
        public string UserName
        {
            get;
            set;
        }
        public DateTime LoginTime
        {
            get;
            set;
        }
        public string Key
        {
            get;
            set;
        }
        public string ClientID
        {
            get;
            set;
        }
        public bool UsefulLife
        {
            get
            {
                TimeSpan ts = DateTime.Now - LoginTime;
                return ts.Hours < 24;
            }
        }
    }
}
