﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Security.Cryptography;

namespace Common
{
	/**********************************/
	//作者：速分享
	//地址：http://www.Sulianqi.cn
	/**********************************/
	public sealed class Encode
	{
		public static string StrEncode(string str)
		{
			string result;
			if (string.IsNullOrEmpty(str))
			{
				result = string.Empty;
			}
			else
			{
				str = str.TrimEnd(new char[0]);
				result = str;
			}
			return result;
		}
		public static string SqlEncode(string str)
		{
			string result;
			if (string.IsNullOrEmpty(str))
			{
				result = string.Empty;
			}
			else
			{
				str = str.Replace("'", "''");
				result = str;
			}
			return result;
		}
		public static T Evaluate<T>(object RecordFieldValue, T Variable)
		{
			T result;
			if (RecordFieldValue != null && RecordFieldValue != System.DBNull.Value)
			{
				result = (T)((object)System.Convert.ChangeType(RecordFieldValue, typeof(T)));
			}
			else
			{
				result = Variable;
			}
			return result;
		}
		public static bool ConvertBoolean(object z)
		{
			bool result;
			if (z == null)
			{
				result = false;
			}
			else
			{
				bool flag = false;
				bool.TryParse(z.ToString(), out flag);
				result = flag;
			}
			return result;
		}
		public static string HtmlEncode(string str)
		{
			string result;
			if (string.IsNullOrEmpty(str))
			{
				result = string.Empty;
			}
			else
			{
				str = str.Replace("&", "&amp;");
				str = str.Replace(">", "&gt;");
				str = str.Replace("<", "&lt;");
				str = str.Replace("\"", "&quot;");
				str = str.Replace(" ", "&nbsp;");
				str = str.Replace("\n", "<br>");
				result = str;
			}
			return result;
		}
		public static string HtmlDecode(string str)
		{
			string result;
			if (string.IsNullOrEmpty(str))
			{
				result = string.Empty;
			}
			else
			{
				str = str.Replace("&gt;", ">");
				str = str.Replace("&lt;", "<");
				str = str.Replace("&quot;", "\"");
				str = str.Replace("&amp;", "&");
				result = str;
			}
			return result;
		}
		 
		public static int ConvertInt32(object z)
		{
			int result;
			if (z == null)
			{
				result = 0;
			}
			else
			{
				int num = 0;
				Int32.TryParse(z.ToString(), out num);
				result = num;
			}
			return result;
		}
        public static Int64 ConvertInt64(object z)
        {
            Int64 result;
            if (z == null)
            {
                result = 0;
            }
            else
            {
                Int64 num = 0;
                Int64.TryParse(z.ToString(), out num);
                result = num;
            }
            return result;
        }
		public static decimal ConvertDecimal(object z)
		{
			decimal result;
			if (z == null)
			{
				result = 0m;
			}
			else
			{
				decimal num = 0m;
				decimal.TryParse(z.ToString(), out num);
				result = num;
			}
			return result;
		}
		public static decimal ConvertDecimal(object z, int digit)
		{
			decimal result;
			if (z == null)
			{
				result = 0m;
			}
			else
			{
				decimal num = 0m;
				decimal.TryParse(z.ToString(), out num);
				num = System.Math.Round(num, 2);
				result = num;
			}
			return result;
		}
		public static float ConvertFloat(object z)
		{
			float result;
			if (z == null)
			{
				result = 0f;
			}
			else
			{
				float num = 0f;
				float.TryParse(z.ToString(), out num);
				result = num;
			}
			return result;
		}
		public static double ConvertDouble(object z)
		{
			double result;
			if (z == null)
			{
				result = 0.0;
			}
			else
			{
				double num = 0.0;
				double.TryParse(z.ToString(), out num);
				result = num;
			}
			return result;
		}
		public static System.DateTime ConvertDateTime(object z)
		{
			System.DateTime result;
			if (z == null)
			{
				result = System.DateTime.MinValue;
			}
			else
			{
				System.DateTime minValue = System.DateTime.MinValue;
				System.DateTime.TryParse(z.ToString(), out minValue);
				result = minValue;
			}
			return result;
		}
		public static System.Collections.Generic.List<T> GetProperValuesForObject<T, B>(System.Collections.Generic.List<B> Senders, string ProperName)
		{
			System.Collections.Generic.List<T> list = new System.Collections.Generic.List<T>();
			foreach (B current in Senders)
			{
				System.Type type = current.GetType();
				System.Reflection.PropertyInfo property = type.GetProperty(ProperName);
				list.Add((T)((object)property.GetValue(current, null)));
			}
			return list;
		}
		public static double FormatRound(double v, int length)
		{
			double num = System.Math.Round(v, length);
			double num2 = System.Math.Floor(num);
			double result;
			if (num2 == num)
			{
				result = num2;
			}
			else
			{
				result = num;
			}
			return result;
		}
		 
		public static string GetSafeStr(string s)
		{
			string result;
			if (s == null)
			{
				result = null;
			}
			else
			{
				string text = string.Empty;
				string text2 = s.Replace("%20", " ");
				text2 = Regex.Replace(text2, "\\s", " ");
				string pattern = "select |insert |delete from |count\\(|drop table|update |truncate |asc\\(|mid\\(|char\\(|xp_cmdshell|exec master|net localgroup administrators|:|net user|\"|\\'| or ";
				if (!Regex.IsMatch(text2, pattern, RegexOptions.IgnoreCase))
				{
					text = text2;
				}
				result = text;
			}
			return result;
		}
        public static string GetCurDate()
        {
            return System.DateTime.Now.ToString("yyyy-MM-dd");
        }
        public static string GetCurDateTime()
        {
            return System.DateTime.Now.ToString("yyyy-MM-dd HH:mm");
        }
        public static string GetCurTime()
        {
            return System.DateTime.Now.ToString("HH:mm");
        }
        public static string FormatStdDate(System.DateTime dt)
        {
            return dt.ToString("yyyy-MM-dd");
        }
        public static string FormatStdDateTime(System.DateTime dt)
        {
            return dt.ToString("yyyy-MM-dd HH:mm");
        }
        #region 将原始字符串转换为格式为&#....;&#....
        /// <summary>
        /// 将原始字符串转换为格式为&#....;&#....
        /// </summary>
        /// <param name="srcText"></param>
        /// <returns></returns>
        public static string StringToISO_8859_1(string srcText)
        {
            string dst = "";
            char[] src = srcText.ToCharArray();
            for (int i = 0; i < src.Length; i++)
            {
                string str = @"&#" + (int)src[i] + ";";
                dst += str;
            }
            return dst;
        }

        #endregion

        #region 将字串&#....;&#....;格式字串转换为原始字符串
        /// <summary>
        /// 将字串&#....;&#....;格式字串转换为原始字符串
        /// </summary>
        /// <param name="srcText"></param>
        /// <returns></returns>
        public static string ISO_8859_1ToString(string srcText)
        {
            string dst = "";
            string[] src = srcText.Split(';');

            for (int i = 0; i < src.Length; i++)
            {
                if (src[i].Length > 0)
                {
                    string str = ((char)int.Parse(src[i].Substring(2))).ToString();
                    dst += str;
                }
            }
            return dst;
        }
        #endregion

        public static string ToGB2312(string str)
        {
            byte[] bytes = Encoding.GetEncoding("GB2312").GetBytes(str);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < bytes.Length; i++)
            {
                if (bytes[i] < 0x80)
                {
                    builder.Append("%" + bytes[i].ToString("x"));
                }
                else
                {
                    builder.Append("%" + bytes[i++].ToString("x").PadLeft(2, '0'));
                    if (bytes.Length > i)
                    {
                        builder.Append("%" + bytes[i].ToString("x").PadLeft(2, '0'));
                    }
                }
            }
            return builder.ToString();
        }

        public static string ToUnicode(string str)
        {
            string str2 = "";
            char[] chArray = str.ToCharArray();
            for (int i = 0; i < chArray.Length; i++)
            {
                byte[] bytes = Encoding.Unicode.GetBytes(chArray[i].ToString());
                string str3 = @"\u" + bytes[1].ToString("X2") + bytes[0].ToString("X2");
                str2 = str2 + str3;
            }
            return str2;
        }

        public static string ToUTF8(string str)
        {
            byte[] bytes = Encoding.GetEncoding("UTF-8").GetBytes(str);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < bytes.Length; i++)
            {
                if (bytes[i] < 0x80)
                {
                    builder.Append("%" + bytes[i].ToString("x"));
                }
                else
                {
                    builder.Append("%" + bytes[i++].ToString("x").PadLeft(2, '0'));
                    if (bytes.Length > i)
                    {
                        builder.Append("%" + bytes[i].ToString("x").PadLeft(2, '0'));
                    }
                }
            }
            return builder.ToString();
        }
        public static string DeUnicode(string str)
        {
            Regex regex = new Regex(@"(?i)\\[uU]([0-9a-f]{4})");
            return regex.Replace(str, m => ((char)Convert.ToInt32(m.Groups[1].Value, 0x10)).ToString());
        }

        public static string MD5(string md5_str, int md5Len)
        {
            MD5 md = System.Security.Cryptography.MD5.Create();
            byte[] bytes = Encoding.ASCII.GetBytes(md5_str);
            byte[] buffer2 = md.ComputeHash(bytes);
            StringBuilder builder = new StringBuilder();
            foreach (byte num in buffer2)
            {
                builder.Append(num.ToString("x").PadLeft(2, '0'));
            }
            if (md5Len == 0x20)
            {
                return builder.ToString().ToUpper();
            }
            return builder.ToString().ToUpper().Substring(8, md5Len);
        }

        public static string MD5(byte[] md5_bytes, int md5Len = 0x20)
        {
            byte[] buffer = System.Security.Cryptography.MD5.Create().ComputeHash(md5_bytes);
            StringBuilder builder = new StringBuilder();
            foreach (byte num in buffer)
            {
                builder.Append(num.ToString("x").PadLeft(2, '0'));
            }
            if (md5Len == 0x20)
            {
                return builder.ToString().ToUpper();
            }
            return builder.ToString().ToUpper().Substring(8, md5Len);
        }

        /// <summary>
        /// UTF-8解码(含%的)
        /// </summary>
        /// <param name="str">需要解码的字符串</param>
        /// <returns></returns>
        public static string UTF8Decode(string str)
        {
            //将str转为小写
            string lowerUrl = str.ToLower();

            //判断str中是否包含%，如果不包含%就不需要解码
            if (lowerUrl.IndexOf('%') != -1)
            {
                //判断str中是否包含%E，如果不包含直接用GB2312解码
                if (lowerUrl.IndexOf("%e") != -1)
                {
                    //以UTF-8对str进行解码
                    string stringUrl = System.Web.HttpUtility.UrlDecode(str, Encoding.GetEncoding("UTF-8"));
                   return stringUrl;
                }
                return System.Web.HttpUtility.UrlDecode(str, Encoding.GetEncoding("GB2312"));
            }
            return str;
        }
	}
}
