﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Common
{
    /// <summary>
    /// Page 分页 实体 
    /// </summary>
    public class PageModel
    {
        private int pageSize = 20;
        /// <summary>
        /// 页大小 默认为20
        /// </summary>
        public int PageSize
        {
            set { pageSize = value; }
            get { return pageSize; }
        }
        private int pageID = 1;
        /// <summary>
        /// 页ID
        /// </summary>
        public int PageID
        {
            set { pageID = value; }
            get { return pageID; }
        }

        private int pageCount = 1;
        /// <summary>
        /// 页总数
        /// </summary>
        public int PageCount
        {
            set { pageCount = value; }
            get { return pageCount; }
        }
        private int recordCount = 1;
        /// <summary>
        /// 记录总数
        /// </summary>
        public int RecordCount
        {
            set { recordCount = value; }
            get { return recordCount; }
        }

    }

    /// <summary>
    /// Url方式分页 v1.0
    /// </summary>
    public class PageListHelper
    {
        private string pageName = "?PageID={0}";
        private string pageLink = "";

        public PageListHelper()
        {
            for (int i = 0; i < HttpContext.Current.Request.QueryString.Count; i++)
            {
                if (HttpContext.Current.Request.Params.Keys[i].ToString().ToLower() != "pageid")
                    pageLink += HttpContext.Current.Request.Params.Keys[i].ToString() + "=" + HttpUtility.UrlEncode(HttpContext.Current.Request.Params[HttpContext.Current.Request.Params.Keys[i]].ToString()) + "&";
            }

            PageName = "?" + pageLink + "PageID={0}";
        }

        /// <summary>
        /// 自定连接地址 不带其它动态参数 仅 {0} 代表PageID
        /// </summary>
        /// <param name="pageName">指定连接页地址 {0}=PageID</param>
        public PageListHelper(string pageHref)
        {
            this.PageName = pageHref;
        }

        /// <summary>
        /// 页面完整连接名称 动态参数 {0} 代表PageID
        /// </summary>
        public string PageName
        {
            set { pageName = value; }
            get { return pageName; }
        }

        #region 分页显示文字

        private string firstPageText = "首页";
        /// <summary>
        /// 首页 按钮显示文本
        /// </summary>
        public string FirstPageText
        {
            set { firstPageText = value; }
            get { return firstPageText; }
        }

        private string prevPageText = "上一页";
        /// <summary>
        /// 上一页 按钮显示文本
        /// </summary>
        public string PrevPageText
        {
            set { prevPageText = value; }
            get { return prevPageText; }
        }

        private string nextPageText = "下一页";
        /// <summary>
        /// 下一页 按钮显示文本
        /// </summary>
        public string NextPageText
        {
            set { nextPageText = value; }
            get { return nextPageText; }
        }

        private string lastPageText = "尾页";
        /// <summary>
        /// 尾页 按钮显示文本
        /// </summary>
        public string LastPageText
        {
            set { lastPageText = value; }
            get { return lastPageText; }
        }

        private int numericButtonCount = 8;
        /// <summary>
        /// 数值按钮的数目 默认8
        /// </summary>
        public int NumericButtonCount
        {
            set { numericButtonCount = value; }
            get { return numericButtonCount; }
        }

        #endregion

        public string GetPageList(PageModel pl)
        {
            StringBuilder strPage = new StringBuilder("");


            pl.PageCount = (pl.RecordCount / pl.PageSize);

            if (pl.PageCount < ((double)pl.RecordCount / (double)pl.PageSize))
            {
                pl.PageCount++;
            }

            strPage.Append("<div class=PageInfo>\r");



            if (pl.PageID == 1)//判断首页ID//FirstPage
            {
                strPage.Append(string.Format("<a>{0}</a>", FirstPageText));
            }
            else
            {
                strPage.Append(string.Format("<a href=\"" + string.Format(PageName, "1") + "\">{0}</a>", FirstPageText));
            }

            if (pl.PageID == 1)//判断上一页ID//PrevPage
            {
                strPage.Append(string.Format("<a>{0}</a>", PrevPageText));
            }
            else
            {
                strPage.Append(string.Format("<a href=\"" + string.Format(PageName, (pl.PageID - 1)) + "\">{0}</a>", PrevPageText));
            }
            //分页码 顺序列表
            // int PageNumList = 10; //页连续数字 091012 换成 NumericButtonCount
            int loopNum = pl.PageID - (NumericButtonCount / 2);

            if (loopNum < 1)
                loopNum = 1;

            for (int i = loopNum; i < loopNum + NumericButtonCount; i++)
            {
                if (i > pl.PageCount)
                {
                    break;
                }

                if (i == pl.PageID)
                {
                    strPage.Append("<a class=curent>" + i.ToString() + "</a>");
                }
                else
                {
                    strPage.Append("<a href=\"" + string.Format(PageName, i) + "\">" + i.ToString() + "</a>");
                }
            }
            if (pl.PageID == pl.PageCount)//判断下一页ID//NextPage
            {
                strPage.Append(string.Format("<a>{0}</a>", NextPageText));
            }
            else
            {
                strPage.Append(string.Format("<a href=\"" + string.Format(PageName, (pl.PageID + 1)) + "\">{0}</a>", NextPageText));
            }

            if (pl.PageID == pl.PageCount)//判断最后页//LastPage
            {
                strPage.Append(string.Format("<a>{0}</a>", LastPageText));
            }
            else
            {
                strPage.Append(string.Format("<a href=\"" + string.Format(PageName, pl.PageCount) + "\">{0}</a>", LastPageText));
            }
            strPage.Append("\r</div>");
            return strPage.ToString();
        }
    }
}
