﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class AccountDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(Account model, string dbName = "")
        {

            string sql = "insert into Account(LoginID,LoginPwd,NickName,TypeID,isLock) values(?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.LoginID,
				model.LoginPwd,
				model.NickName,
				model.TypeID,
				model.isLock
	        });
            return rst;

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(Account model, string dbName = "")
        {

            string sql = "update Account set LoginID=?,LoginPwd=?,NickName=?,TypeID=?,isLock=? where LoginID = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				  model.LoginID,
				  model.LoginPwd,
				  model.NickName,
				  model.TypeID,
				  model.isLock,
				  model.LoginID});
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string id, string dbName = "")
        {

            string sql = "DELETE FROM Account WHERE LoginID = ?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { id });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static Account GetModel(string id, string dbName = "")
        {
            string sql = "select LoginID,LoginPwd,NickName,TypeID,isLock from Account where LoginID = ?";
            Account model = new Account();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<Account> list = SqliteHelper.FillEntityFromReader<Account>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
		/// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "LoginID,LoginPwd,NickName,TypeID,isLock" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "Account", colNames, where, order, dbName,p);
            return dt;
        }
    }
}
