﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class CommentDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(Comment model, string dbName = "")
        {

            string sql = "insert into Comment(CID,Name,Contents,AddTime,Title,UrlReferrer) values(?,?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.CID,
				model.Name,
				model.Contents,
				model.AddTime,
				model.Title,
                model.UrlReferrer
	        });
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string id, string dbName = "")
        {

            string sql = "DELETE FROM Comment WHERE ID = ?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { id });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static Comment GetModel(string id, string dbName = "")
        {
            string sql = "select ID,CID,Name,Contents,AddTime,Title,UrlReferrer from Comment where ID = ?";
            Comment model = new Comment();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<Comment> list = SqliteHelper.FillEntityFromReader<Comment>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "ID,CID,Name,Contents,AddTime,Title,UrlReferrer" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "Comment", colNames, where, order, dbName, p);
            return dt;
        }
        public static DataTable GetComment(string id, string dbName = "")
        {
            string sql = "select ID,Name,Contents,AddTime,UrlReferrer from Comment where CID=?";
            DataTable dt = SqliteHelper.ExecuteDataTable(sql, dbName, new object[] { id });
            return dt;
        }
        public static string GetCommentCount(string ID, string dbName = "")
        {
            string reStr = string.Empty;
            string sql = "SELECT count(1) FROM Comment where CID=?";
            object o = SqliteHelper.ExecuteScalar(sql, "", new object[] { ID });
            if (o != null)
            {
                reStr = o.ToString();
            }
            return reStr;
        }
    }
}
