﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class SysTypeDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(SysType model, string dbName = "")
        {

            string sql = "insert into SysType(Depth,IsShow,Kind,ParentID,RootID,Sort,TypeID,TypeName) values(?,?,?,?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.Depth,
				model.IsShow,
				model.Kind,
				model.ParentID,
				model.RootID,
				model.Sort,
				model.TypeID,
				model.TypeName
	        });
            return rst;

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(SysType model, string dbName = "")
        {

            string sql = "update SysType set Depth=?,IsShow=?,Kind=?,ParentID=?,RootID=?,Sort=?,TypeName=? where TypeID = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.Depth,
				model.IsShow,
				model.Kind,
				model.ParentID,
				model.RootID,
				model.Sort,
				model.TypeName,
                model.TypeID
            });
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string KeyField, string dbName = "")
        {

            string sql = "DELETE FROM SysType WHERE TypeID=?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { KeyField });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static SysType GetModel(string id, string dbName = "")
        {
            string sql = "select Depth,IsShow,Kind,ParentID,RootID,Sort,TypeID,TypeName from SysType where TypeID = ?";
            SysType model = new SysType();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<SysType> list = SqliteHelper.FillEntityFromReader<SysType>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "Depth,IsShow,Kind,ParentID,RootID,Sort,TypeID,TypeName" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "SysType", colNames, where, order, dbName,p);
            return dt;
        }
    }
}
