﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class Sys_PropertiesDal
    {

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(Sys_Properties model, string dbName = "")
        {

            string sql = "update Sys_Properties set PValue=?,PText=?,Sort=?,IsLock=?,Kind=?,editor=? where PName = ? and Kind = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				  model.PValue,
				  model.PText,
				  model.Sort,
				  model.IsLock,
				  model.Kind,
				  model.editor,
				  model.PName,
                  model.Kind
            });
            return rst;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static Sys_Properties GetModel(string id, string kind, string dbName = "")
        {
            string sql = "select PValue,PText,Sort,IsLock,Kind,editor,PName from Sys_Properties where PName = ? and Kind = ?";
            Sys_Properties model = new Sys_Properties();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id, kind });
            List<Sys_Properties> list = SqliteHelper.FillEntityFromReader<Sys_Properties>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }

    }
}
