﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class TagLinkDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(TagLink model, string dbName = "")
        {

            string sql = "insert into TagLink(ID,Title,SortID,Url,Target,ParentID,Kind,IsLock,Style,ImageUrl) values(?,?,?,?,?,?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.ID,
				model.Title,
				model.SortID,
				model.Url,
				model.Target,
				model.ParentID,
				model.Kind,
				model.IsLock,
				model.Style,
				model.ImageUrl
	        });
            return rst;

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(TagLink model, string dbName = "")
        {

            string sql = "update TagLink set Title=?,SortID=?,Url=?,Target=?,ParentID=?,Kind=?,IsLock=?,Style=?,ImageUrl=? where ID = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				  model.Title,
				  model.SortID,
				  model.Url,
				  model.Target,
				  model.ParentID,
				  model.Kind,
				  model.IsLock,
				  model.Style,
				  model.ImageUrl,
				  model.ID});
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string id, string dbName = "")
        {

            string sql = "DELETE FROM TagLink WHERE ID = ?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { id });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static TagLink GetModel(string id, string dbName = "")
        {
            string sql = "select ID,Title,SortID,Url,Target,ParentID,Kind,IsLock,Style,ImageUrl from TagLink where ID = ?";
            TagLink model = new TagLink();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<TagLink> list = SqliteHelper.FillEntityFromReader<TagLink>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// 查实体
        /// </summary>
        public static TagLink GetModelByTagName(string name, string dbName = "")
        {
            string sql = "select ID,Title,SortID,Url,Target,ParentID,Kind,IsLock,Style,ImageUrl from TagLink where Title = ?";
            TagLink model = new TagLink();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { name });
            List<TagLink> list = SqliteHelper.FillEntityFromReader<TagLink>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
		/// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "ID,Title,SortID,Url,Target,ParentID,Kind,IsLock,Style,ImageUrl" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "TagLink", colNames, where, order, dbName,p);
            return dt;
        }
    }
}
