﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="Share.Admin.Article.List" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>文章列表</title>
    <link href="/js/jquery-easyui-1.3.2/themes/default/easyui.css" rel="stylesheet" type="text/css" />
    <link href="/js/jquery-easyui-1.3.2/themes/icon.css" rel="stylesheet" type="text/css" />
    <link href="../css/admin.css" rel="stylesheet" type="text/css" />
    <script src="/js/jquery-1.8.0.min.js" type="text/javascript"></script>
    <script src="../js/AdminCommon.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/jquery.easyui.min.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/locale/easyui-lang-zh_CN.js" type="text/javascript"></script>
    <script src="/js/kindeditor-v4.1.6/kindeditor-min.js" type="text/javascript"></script>
    <script src="/js/kindeditor-v4.1.6/lang/zh_CN.js" type="text/javascript"></script>
    <script src="../js/CURD.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dg').datagrid({
                queryParams: { eq_Kind: '<%=Kind %>' },
                iconCls: 'icon-save',
                nowrap: false,
                striped: true,
                url: 'Handler.ashx?src=list',
                sortName: 'CreateDate',
                sortOrder: 'desc',
                method: "post",
                remoteSort: true,
                fitColumns: true,
                fit: true,
                idField: 'ID',
                pagination: true,
                rownumbers: true,
                singleSelect: true,
                pageList: [15, 20, 30, 40, 50],

                frozenColumns: [[
	                { field: 'ID', checkbox: true }
				]],
                columns: [[
                    { field: 'Title', title: '标题', width: 130 },
                    { field: 'Author', title: '作者', width: 40, align: 'center' },
                    { field: 'Click', title: '浏览次数', width: 40, sortable: true, align: 'center' },
                    { field: 'KeyWord', title: '关键字', width: 50, align: 'center' },
                    { field: 'CreateDate', title: '发布时间', width: 60, sortable: true, align: 'center', sortable: true },
                    { field: 'IsLock', title: '锁定?', width: 30, align: 'center',
                        formatter: function (value, row, index) {
                            return value == 'n' ? '否' : '是';
                        }
                    },
                     { field: 'PlCount', title: '评论', width: 40, align: 'center',
                         formatter: function (value, row, index) {
                             return "<a href=\"javascript:ShowComment('" + row["ID"] + "')\">共<font color=red>" + value + "</font>条评论</a>";
                             //return "<a href='/Article.aspx?id=" + row["ID"] + "' target='_blank'>共<font color=red>" + value + "</font>条评论</a>";
                         }
                     }
                ]], onDblClickRow: function (rowIndex, rowData) {
                    OpenForm("edit");
                    CreateEditor();
                },
                onBeforeLoad: function () {

                },
                toolbar: [{
                    id: 'btnSave',
                    text: '添加',
                    iconCls: 'icon-add',
                    handler: function () {
                        OpenForm('add');
                        CreateEditor();
                    }
                }, '-', {
                    id: 'btnUpdate',
                    text: '修改',
                    iconCls: 'icon-edit',
                    handler: function () {
                        OpenForm('edit');
                        CreateEditor();
                    }
                }, '-', {
                    id: 'btnDelete',
                    text: '删除',
                    disabled: false,
                    iconCls: 'icon-remove',
                    handler: function () {
                        Delete();
                    }
                }, '-', {
                    id: 'btnSearch',
                    text: '查询',
                    disabled: false,
                    iconCls: 'icon-search',
                    handler: function () {
                        OpenSearchForm();
                    }
                }, '-', {
                    id: 'btnReload',
                    text: '刷新',
                    iconCls: 'icon-reload',
                    handler: function () {
                        $('#dg').datagrid('reload');
                    }
                }]
            });
        });
        function OpenForm(op) {
            var id = "";
            if (op == "edit") {
                var options = $("#dg").datagrid("options");
                var row = $('#dg').datagrid('getSelected');
                if (row) {
                    id = row[options.idField];
                } else {
                    $.messager.show({ title: '提示', msg: "请选择一行数据再编辑！" });
                    return;
                }
            }
            $('#form1').form('load', 'Handler.ashx?src=edit&id=' + id);

            $('#dlg').show();
            $('#dlg').dialog({
                collapsible: false,
                minimizable: false,
                maximizable: true,
                buttons: [{
                    text: '保存',
                    iconCls: 'icon-ok',
                    handler: function () {
                        $("#Contents").val(escape(editor.html()));
                        Save();
                    }
                }, {
                    text: '取消',
                    handler: function () {
                        $('#dlg').dialog('close');

                        $('#dg').datagrid('clearSelections');
                        $('#dg').datagrid('unselectAll');
                    }
                }]
            });
            ClearForm();
            $("#hdAction").val(op);
        }
        var editor;
        function CreateEditor() {
            KindEditor.remove('textarea[name="edtContents"]');
            $.getScript('/js/kindeditor-v4.1.6/kindeditor-min.js', function () {
                KindEditor.basePath = '/js/kindeditor-v4.1.6/';
                editor = KindEditor.create('textarea[name="edtContents"]', {
                    cssPath: '/js/kindeditor-v4.1.6/themes/default/default.css',
                    uploadJson: '/Tools/upload_json.ashx',
                    fileManagerJson: '/Tools/file_manager_json.ashx',
                    allowFileManager: true,
                    width: '98%',
                    height: '270px'
                });
                $(".ke-container").hide();
                setTimeout("SetContent()", 500);
            });
        }
        function SetContent() {
            editor.html(unescape($("#Contents").val()));
            $(".ke-container").fadeIn();
        }
        function GetKeyWord() {
            $.post("Handler.ashx?src=getKeyWord&r=" + Math.random(), { Title: $("#Title").val() }, function (data) {
                var result = $.parseJSON(data);
                $("#KeyWord").val(result.msg);
            });
        }
        function ShowComment(id) {
            $('#dlgComment').dialog({
                collapsible: false,
                minimizable: false,
                maximizable: true
            });
            $('#dgComment').show();
            $('#dgComment').datagrid({
                url: 'Handler.ashx?src=commentlist&id=' + id,
                remoteSort: true,
                fitColumns: true,
                fit: true,
                autoRowHeight: true,
                idField: 'ID',
                frozenColumns: [[
	                { field: 'ID', checkbox: true }
				]],
                columns: [[
                    { field: 'Name', title: 'IP', width: 40 },
                    { field: 'Contents', title: '内容', width: 100 },
                    { field: 'AddTime', title: '时间', width: 50, align: 'center' },
                    { field: 'UrlReferrer', title: '来路', width: 60}
                ]],
                toolbar: [{
                    id: 'btnDelete',
                    text: '删除',
                    disabled: false,
                    iconCls: 'icon-remove',
                    handler: function () {
                        var options = $("#dgComment").datagrid("options");
                        var rows = $('#dgComment').datagrid('getChecked');
                        if (!rows || rows.length == 0) {
                            $.messager.alert('提示', '请选择要删除的数据');
                            return;
                        }
                        var ids = "";
                        $.each(rows, function (i, row) {
                            if (i == 0) {
                                ids = row[options.idField];
                            }
                            else {
                                ids += "," + row[options.idField];
                            }
                        });

                        $.messager.confirm('提示', '是否删除这些数据?', function (r) {
                            if (r) {
                                $.post('Handler.ashx?src=delcomment', { ids: ids, r: Math.random() }, function (result) {
                                    if (result.code == 1) {
                                        $('#dgComment').datagrid('reload');
                                    }
                                    $('#dgComment').datagrid('clearChecked');
                                    $.messager.show({ title: '提示', msg: result.msg });
                                }, 'json');
                            }
                        });
                    }
                }, '-', {
                    id: 'btnReload',
                    text: '刷新',
                    iconCls: 'icon-reload',
                    handler: function () {
                        $('#dgComment').datagrid('reload');
                    }
                }]
            });
        }
    </script>
</head>
<body>
    <table id="dg">
    </table>
    <div id="dlgComment" style="width: 640px; height: 380px; padding: 10px;" iconcls='icon-search'
        title="评论">
        <table id="dgComment">
        </table>
    </div>
    <div id="dlgSearch" style="width: 340px; height: 220px; padding: 10px; display: none;"
        iconcls='icon-search' title="查询">
        <div class="fitem">
            <label>
                类型:</label>
            <select name="lk_TypeID" class="easyui-combobox" style="width: 125px;">
            </select>
        </div>
        <div class="fitem">
            <label>
                标题:</label>
            <input type="text" name="lk_Title" />
        </div>
        <div class="fitem">
            <label>
                关键字:</label>
            <input type="text" name="lk_KeyWord" />
        </div>
        <div class="fitem">
            <label>
                简介:</label>
            <input type="text" name="lk_Introduction" />
        </div>
        <div class="fitem">
            <label>
                时间:</label>
            <input type="text" name="begin_CreateDate" style="width: 90px;" class="easyui-datebox" />-<input
                type="text" name="end_CreateDate" style="width: 90px;" class="easyui-datebox" />
            <input type="hidden" name="eq_Kind" value='<%=Kind %>' />
        </div>
    </div>
    <div id="dlg" iconcls='icon-save' style="width: 750px; height: 450px; display: none;
        padding: 10px 20px" title="编辑">
        <form id="form1" method="post" action="">
        <div class="fitem" style="text-align: left">
            <span>标 &nbsp;题：</span>
            <input class="easyui-validatebox" type="text" id="Title" name="Title" style="width: 527px;" />
        </div>
        <div class="fitem">
            <a href="javascript:GetKeyWord()" style="width: 40px; color: Blue;">关键字：</a><input
                class="easyui-validatebox" type="text" id="KeyWord" name="KeyWord" style="width: 303px;" />&nbsp;
            固定编号：<input class="easyui-validatebox" type="text" name="ID" />
        </div>
        <div class="fitem">
            <span>锁 &nbsp;定： </span>
            <input class="easyui-validatebox noclear" type="text" name="IsLock" value="n" style="width: 82px;" />&nbsp;
            <span>排序(置顶)：</span><input class="easyui-validatebox" type="text" name="Sort" value="0"
                style="width: 82px;" />&nbsp; <span>类 &nbsp;型：</span>
            <input name="TypeID" class="easyui-combotree" data-options="url:'/<%=ConfigurationManager.AppSettings["AdminPath"].ToString()%>/SysType/Handler.ashx?src=list2&Kind=Article'"
                style="width: 225px;" />
        </div>
        <div class="fitem">
            <textarea id="Contents" name="Contents" rows="5" cols="12" style="display: none"></textarea>
            <textarea id="edtContents" name="edtContents" disabled="disabled" rows="5" cols="12"
                style="width: 0px; height: 0px;"></textarea>
        </div>
        <!--hide field-->
        <input type="hidden" id="hdAction" name="hdAction" value="add" />
        <input class="noclear" type="hidden" name="Kind" value="<%=Kind %>" />
        </form>
    </div>
</body>
</html>
