﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;

namespace Share.Admin
{
    public class BasePage : System.Web.UI.Page
    {
        private Model.Account account;

        public Model.Account Account
        {
            get
            {
                string LoginID = Common.CookieHelper.GetCookie("LoginID");
                if (!string.IsNullOrEmpty(LoginID))
                {
                    LoginID = Common.CFun.Decrypt(LoginID, "LoginID");
                    account = Bll.AccountBll.GetModel(LoginID, "");
                }
                return account;
            }
        }

        public BasePage()
        {
            this.Load += new EventHandler(IsLogin);
        }

        public void IsLogin(Object sender, EventArgs e)
        {
            if (IsAdminLogin())
            {
                string adminPath = ConfigurationManager.AppSettings["AdminPath"].ToString();
              Response.Write("<script>top.location.href='/" + adminPath + "/Login.aspx'</script>");
                Response.End();
            }
        }
        public bool IsAdminLogin()
        {
            string LoginID = Common.CookieHelper.GetCookie("LoginID");
            return string.IsNullOrEmpty(LoginID);
        }
    }
}