﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Bll;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share.Admin
{
    public partial class Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void btnLogin_Click(object sender, EventArgs e)
        {

            String LoginID = loginName.Value;
            String LoginPwd = password.Value;
            String CheckCode = checkCode.Value;


            if (CheckCode.Trim().ToUpper() != Session["CheckCode"].ToString().ToUpper())
            {
                MessageBox("抱歉，验证码有误！"); return;
            }
            else
            {

                Model.Account account = AccountBll.GetModel(LoginID);
                if (null == account)
                {
                    MessageBox("抱歉，账号不存在！"); return;
                }
                else
                {
                    if (Common.CFun.Encrypt(LoginPwd.Trim(), "Share").Equals(account.LoginPwd))
                    {
                        if ("y".Equals(account.isLock.ToString().ToUpper()))
                        {
                            MessageBox("抱歉，账号已锁定！"); return;
                        }
                        Common.CookieHelper.AddCookie("LoginID", Common.CFun.Encrypt(LoginID, "LoginID"), DateTime.Now.AddHours(1));
                        MessageBox("登陆成功！");
                        Response.Redirect("index.aspx");
                    }
                    else
                    {
                        MessageBox("抱歉，密码错误！"); return;
                    }
                }
            }

        }
        private void MessageBox(string msg)
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), "message", "<script type='text/javascript'>$(function(){ShowMsg('" + msg + "');});</script>");
        }
    }
}