﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="Share.Admin.SysRule.List" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>SysRule列表</title>
    <link href="/js/jquery-easyui-1.3.2/themes/default/easyui.css" rel="stylesheet" type="text/css" />
    <link href="/js/jquery-easyui-1.3.2/themes/icon.css" rel="stylesheet" type="text/css" />
    <link href="../css/admin.css" rel="stylesheet" type="text/css" />
    <script src="/js/jquery-1.8.0.min.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/jquery.easyui.min.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/locale/easyui-lang-zh_CN.js" type="text/javascript"></script>
    <script src="../js/AdminCommon.js" type="text/javascript"></script>
    <script src="../js/CURD.js" type="text/javascript"></script>
    <link href="/js/bigcolorpicker/css/jquery.bigcolorpicker.css" rel="stylesheet" type="text/css" />
    <script src="/js/bigcolorpicker/js/jquery.bigcolorpicker.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/jquery.easyui.extend.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dg').datagrid({
                iconCls: 'icon-save',
                nowrap: false,
                striped: true,
                queryParams: { eq_Kind: '<%=Kind %>' },
                url: 'Handler.ashx?src=list&Kind=<%=Kind %>',
                sortName: 'ID',
                sortOrder: 'desc',
                method: "post",
                remoteSort: true,
                fitColumns: true,
                fit: true,
                idField: 'ID',
                pagination: false,
                rownumbers: false,
                singleSelect: true,
                autoRowHeight: true,
                onClickRow: onClickRow,
                pageList: [10, 20, 30, 40, 50],
                columns: [[
                    { field: 'ID', title: 'ID', width: 60, hidden: true },
                    { field: 'Svalue', title: '点击率', width: 60, editor: { type: 'text'} },
                    { field: 'Rvalue', title: '字体大小', width: 100, formatter: function (value, row) {
                        return row.Rvalue;
                    },
                        editor: {
                            type: 'combobox',
                            options: {
                                valueField: 'Rvalue',
                                textField: 'RName',
                                data: [
                                    { "Rvalue": "12", "RName": "12" },
                                    { "Rvalue": "13", "RName": "13" },
                                    { "Rvalue": "14", "RName": "14" },
                                    { "Rvalue": "15", "RName": "15" },
                                    { "Rvalue": "16", "RName": "16" },
                                    { "Rvalue": "17", "RName": "17" },
                                    { "Rvalue": "18", "RName": "18" },
                                    { "Rvalue": "19", "RName": "19" },
                                    { "Rvalue": "20", "RName": "20" },
                                    { "Rvalue": "21", "RName": "21" },
                                    { "Rvalue": "22", "RName": "22" },
                                    { "Rvalue": "23", "RName": "23" },
                                    { "Rvalue": "24", "RName": "24" }
                                ]
                            }
                        }
                    },
                    { field: 'Mark', title: '颜色', width: 100, editor: { type: 'color' },
                        formatter: function (value, row, index) {
                            return '<font style="color:' + value + ';font-size:' + row.Rvalue + 'px;">示例文字</font>';
                        }
                    }
                ]],
                toolbar: [{
                    id: 'btnSave',
                    text: '添加',
                    iconCls: 'icon-add',
                    handler: function () {
                        if (endEditing()) {
                            $('#dg').datagrid('appendRow', { ID: "TAG0000000000000" });
                            editIndex = $('#dg').datagrid('getRows').length - 1;
                            $('#dg').datagrid('selectRow', editIndex).datagrid('beginEdit', editIndex);
                        }
                        //OpenForm('add');
                    }
                }, '-', {
                    id: 'btnDelete',
                    text: '删除',
                    disabled: false,
                    iconCls: 'icon-remove',
                    handler: function () {
                        if (editIndex == undefined) { return }
                        $('#dg').datagrid('cancelEdit', editIndex).datagrid('deleteRow', editIndex);
                        editIndex = undefined;
                        //Delete();
                    }
                }, '-', {
                    id: 'btnsave',
                    text: '保存',
                    disabled: false,
                    iconCls: 'icon-save',
                    handler: function () {
                        if (endEditing()) {
                            $('#dg').datagrid('acceptChanges');
                            var jsondata = '';
                            var rows = $('#dg').datagrid('getRows');
                            var dataGridData = JSON.stringify(rows);
                            if (dataGridData != '') {
                                $.post(
                                    'Handler.ashx?src=save',
                                    { dataGridData: dataGridData ,Kind:"TAG"},
                                    function (result) {
                                        $.messager.show({ title: '提示', msg: result.msg });
                                        $('#dg').datagrid('reload');
                                    }, 'json');
                            }
                        }
                    }
                }, '-', {
                    id: 'btnReject',
                    text: '撤销',
                    iconCls: 'icon-undo',
                    handler: function () {
                        $('#dg').datagrid('rejectChanges');
                        editIndex = undefined;
                    }
                }]
            });
        });


        var editIndex = undefined;
        function endEditing() {
            if (editIndex == undefined) { return true }
            if ($('#dg').datagrid('validateRow', editIndex)) {
                var ed = $('#dg').datagrid('getEditor', { index: editIndex, field: 'ID' });
                $('#dg').datagrid('endEdit', editIndex);
                editIndex = undefined;
                return true;
            } else {
                return false;
            }
        }
        function onClickRow(index) {
            if (editIndex != index) {
                if (endEditing()) {
                    $('#dg').datagrid('selectRow', index)
							.datagrid('beginEdit', index);
                    editIndex = index;
                } else {
                    $('#dg').datagrid('selectRow', editIndex);
                }
            }
        }
  
    </script>
</head>
<body>
    <table id="dg">
    </table>
    <div id="dlgSearch" style="width: 300px; height: 180px; padding: 10px; display: none;"
        iconcls='icon-search' title="查询">
        <div class="fitem">
            <label>
                比率:</label>大于
            <input class="easyui-validatebox" type="text" name="gt_Rate" style="width: 50" />
        </div>
        <div class="fitem">
            <label>
                备注:</label>
            <input class="easyui-validatebox" type="text" name="lk_Mark" />
            <input type="hidden" name="eq_Kind" value='<%=Kind %>' />
        </div>
    </div>
    <div id="dlg" iconcls='icon-save' style="width: 340px; height: 300px; display: none;
        padding: 10px 20px" title="编辑">
        <form id="form1" method="post" action="">
        <div class="fitem">
            <span>编&nbsp;&nbsp;&nbsp;号:</span>
            <input class="easyui-validatebox" type="text" name="ID" />
        </div>
        <div class="fitem">
            <span>上限值:</span>
            <input class="easyui-validatebox" type="text" name="Svalue" />
        </div>
        <div class="fitem">
            <span>颜&nbsp;&nbsp;&nbsp;色:</span>
            <input class="easyui-validatebox" type="text" name="Mark" id="Mark" />
            <img alt="选择颜色" id="imgcolor" src="/images/tm.gif" width="20" height="20" style="background-color: #000000"
                align="absmiddle" onmouseover="this.style.cursor='hand'">
        </div>
        <div class="fitem">
            <span style="float: left; padding-right: 4px;">字&nbsp;&nbsp;&nbsp;体:</span>
            <input class="easyui-validatebox" type="text" name="Rvalue" id="Rvalue" style="width: 18px;
                float: left; margin-right: 10px;" />
            <input class="easyui-slider" value="12" style="width: 150px" data-options="
				showTip: false,min:12,max:26,
				rule: [12,'|',16,'|',20,'|',24,'|',26],
				onChange: function(value){
					$('#ff').css('font-size', value); $('#Rvalue').val(value);
				}" /><div id="ff" style="margin-top: 50px; font-size: 12px">
                    标签样式规则定义</div>
        </div>
        <input type="hidden" id="Kind" class="noclear" name="Kind" value="<%=Kind %>" />
        <input type="hidden" id="hdAction" class="noclear" name="hdAction" value="add" />
        </form>
    </div>
</body>
</html>
