﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using System.Collections.Specialized;
using System.Collections;

namespace Share.Admin.TagLink
{
    public class Handler : StoreBase, IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            String src = Common.CFun.GetQueryString("src", context);
            String result = Common.CFun.ResultJson("0", "src error !");
            if ("list".Equals(src))
            {
                result = List(context);
            }
            else if ("save".Equals(src))
            {
                result = Save(context);
            }
            else if ("edit".Equals(src))
            {
                result = GetModel(context);
            }
            else if ("delete".Equals(src))
            {
                result = Delete(context);
            }
            else if ("parenttree".Equals(src))
            {
                result = ParentTree(context);
            }
            context.Response.Write(result);
        }

        private String Save(HttpContext context)
        {
            string keyField = Common.CFun.GetString("ID", context);
            string hdAction = Common.CFun.GetString("hdAction", context);
            int result = 0;

            Model.TagLink model = TagLinkBll.GetModel(keyField);
            if (hdAction == "add")
            {
                if (model != null) return Common.CFun.ResultJson("0", "主键重复！");

                model = new Model.TagLink();
                Common.CFun.SetModelValue<Model.TagLink>(model, context.Request.Form);
                result = TagLinkBll.Add(model);

            }
            else
            {
                Common.CFun.SetModelValue<Model.TagLink>(model, context.Request.Form);
                result = TagLinkBll.Update(model);
            }

            if (result > 0)
            {
                return Common.CFun.ResultJson("1", "保存成功！");
            }
            else
            {
                return Common.CFun.ResultJson("0", "保存失败！");
            }
        }

        private String Delete(HttpContext context)
        {
            int count = 0;
            String idsStr = Common.CFun.GetString("ids", context);
            string[] ids = idsStr.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {

                int r = TagLinkBll.Delete(ids[i]);
                if (r > 0)
                {
                    count++;
                }
            }
            return Common.CFun.ResultJson("1", string.Format("删除成功{0}！", count));
        }

        private String GetModel(HttpContext context)
        {
            Model.TagLink model = null;
            String id = Common.CFun.GetQueryString("id", context);
            if (!string.IsNullOrEmpty(id))
            {
                model = TagLinkBll.GetModel(id);
            }
            if (model == null)
            {
                model = new Model.TagLink();
                model.ID = Common.CFun.GetMaxLsh("");
                return Common.CFun.ObjToJson<Model.TagLink>(model);
            }
            return JsonConvert.SerializeObject(model);

        }

        private String List(HttpContext context)
        {
            int recordCount = 0;
            int pageIndex = Common.CFun.GetInt("page", context);
            int pageSize = Common.CFun.GetInt("rows", context);
            String colNames = "ID,Title,SortID,Url,Target,ParentID,Kind,IsLock,Style,ImageUrl";
            String where = Common.CFun.GetWhere(context);
            String order = Common.CFun.GetString("sort", context) + " " + Common.CFun.GetString("order", context);
            String dbName = "";
            object[] p = { };
            DataTable dt = TagLinkBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
            String result = Common.CFun.GetPageJson(pageIndex, pageSize, recordCount, dt);
            return result;
        }

        // 获取父级树
        private String ParentTree(HttpContext context)
        {
            string Kind = Common.CFun.GetQueryString("Kind", context);
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(string.Format("SELECT ID as id,Title as text,ParentID FROM TagLink where Kind='{0}' and IsLock='n'", Kind));
            JArray ja = new JArray();
            DataRow[] drRoot = dt.Select("ParentID=''");

            return Common.CFun.GetTreeJson(ja, drRoot, dt, "id", "ParentID");
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}