﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="Share.Admin.TagLink.List" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>TagLink列表</title>
    <link href="/js/jquery-easyui-1.3.2/themes/default/easyui.css" rel="stylesheet" type="text/css" />
    <link href="/js/jquery-easyui-1.3.2/themes/icon.css" rel="stylesheet" type="text/css" />
    <link href="../css/admin.css" rel="stylesheet" type="text/css" />
    <script src="/js/jquery-1.8.0.min.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/jquery.easyui.min.js" type="text/javascript"></script>
    <script src="/js/jquery-easyui-1.3.2/locale/easyui-lang-zh_CN.js" type="text/javascript"></script>
    <script src="../js/AdminCommon.js" type="text/javascript"></script>
    <script src="../js/CURD.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dg').datagrid({
                queryParams: { eq_Kind: '<%=Kind %>' },
                iconCls: 'icon-save',
                nowrap: false,
                striped: true,
                url: 'Handler.ashx?src=list',
                sortName: 'SortID',
                sortOrder: 'desc',
                method: "post",
                remoteSort: true,
                fitColumns: true,
                fit: true,
                idField: 'ID',
                pagination: true,
                rownumbers: true,
                singleSelect: false,
                pageList: [15, 20, 30, 40, 50],
                frozenColumns: [[
	                { field: 'ID', checkbox: true }
				]],
                columns: [[
                    { field: 'Title', title: '标题', width: 100 },
                    { field: 'SortID', title: '排序', width: 50 },
                    { field: 'Url', title: '地址', width: 260 },
                    { field: 'Target', title: '目标', width: 50 },
                    { field: 'ParentID', title: '父节点', width: 100 },
                    { field: 'Kind', title: '种类', width: 100 },
                    { field: 'IsLock', title: '锁定', width: 40 },
                    { field: 'Style', title: '样式', width: 100 },
                    { field: 'ImageUrl', title: '图片', width: 100 }
                ]], onDblClickRow: function (rowIndex, rowData) {
                    OpenForm("edit");
                },
                toolbar: [{
                    id: 'btnSave',
                    text: '添加',
                    iconCls: 'icon-add',
                    handler: function () {
                        OpenForm('add');
                        $("#ParentID").combotree("reload");
                    }
                }, '-', {
                    id: 'btnUpdate',
                    text: '修改',
                    iconCls: 'icon-edit',
                    handler: function () {
                        OpenForm('edit');
                    }
                }, '-', {
                    id: 'btnDelete',
                    text: '删除',
                    disabled: false,
                    iconCls: 'icon-remove',
                    handler: function () {
                        Delete();
                    }
                }, '-', {
                    id: 'btnSearch',
                    text: '查询',
                    disabled: false,
                    iconCls: 'icon-search',
                    handler: function () {
                        OpenSearchForm();
                    }
                }, '-', {
                    id: 'btnReload',
                    text: '刷新',
                    iconCls: 'icon-reload',
                    handler: function () {
                        $('#dg').datagrid('reload');
                    }
                }]
            });

            $('#ParentID').combotree({
                url: 'Handler.ashx?src=parenttree&Kind=<%=Kind %>',
                required: false,
                multiple: false
            });
        });
    </script>
</head>
<body>
    <table id="dg">
    </table>
    <div id="dlgSearch" style="width: 300px; height: 220px; padding: 10px; display: none;"
        iconcls='icon-search' title="查询">
        <div class="fitem">
            <label>
                标题:</label>
            <input type="text" name="lk_Title" />
        </div>
        <div class="fitem">
            <label>
                锁定:</label>
            <input type="checkbox" name="eq_IsLock" />
            <input type="hidden" name="eq_Kind" value='<%=Kind %>' />
        </div>
    </div>
    <div id="dlg" iconcls='icon-save' style="width: 350px; height: 350px; display: none;
        padding: 10px 20px" title="编辑">
        <form id="form1" method="post" action="">
        <div class="fitem">
            <label>
                编号:</label>
            <input class="easyui-validatebox" type="text" name="ID" />
        </div>
        <div class="fitem">
            <label>
                父级:</label>
            <input id="ParentID" name="ParentID" />
        </div>
        <div class="fitem">
            <label>
                目标:</label>
            <select name="Target" style="width: 154px;">
                <option value=""></option>
                <option value="_blank">_blank</option>
                <option value="_parent">_parent</option>
                <option value="_search">_search</option>
                <option value="_self">_self</option>
                <option value="_top">_top</option>
            </select>
        </div>
        <div class="fitem">
            <label>
                标题:</label>
            <input type="text" name="Title" />
        </div>
        <div class="fitem">
            <label>
                排序:</label>
            <input type="text" name="SortID" value="0" />
        </div>
        <div class="fitem">
            <label>
                地址:</label>
            <input type="text" name="Url" />
        </div>
        <div class="fitem">
            <label>
                锁定:</label>
            <input class="noclear" type="text" name="IsLock" value="n" />
        </div>
        <div class="fitem">
            <label>
                样式:</label>
            <input type="text" name="Style" />
        </div>
        <div class="fitem">
            <label>
                图片:</label>
            <input type="text" name="ImageUrl" />
        </div>
        <input class="noclear" type="hidden" id="Kind" name="Kind" value="<%=Kind %>" />
        <input type="hidden" id="hdAction" name="hdAction" value="add" />
        </form>
    </div>
</body>
</html>
