﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Model;
using Bll;
using System.Data;

/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/

namespace Share
{
    public partial class WebForm2 : System.Web.UI.Page
    {
        protected Article model = null;
        protected Article prvModel = new Article();
        protected Article nextModel = new Article();
        protected string Comment = string.Empty;
        protected string CommentCount = string.Empty;
        protected string ShareCode = string.Empty;
        protected string TitleStr = "";
        protected string Description = "";
        protected string Keywords = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                string id = Common.CFun.GetQueryString("id", this.Context);
                if (!string.IsNullOrEmpty(id))
                {
                    ShareCode = Common.CFun.GetPropertyByName("sys", "ShareCode");

                    model = ArticleBll.GetModel(id);
                    if (model == null)
                    {
                        model = new Article();
                        model.Title = model.Contents = "文章不存在或已被管理删除！";
                    }
                    else
                    {
                        TitleStr = model.Title + "-" + model.KeyWord + "-" + Common.CFun.GetPropertyByName("sys", "WebName");
                        Keywords = model.Title + "-" + model.KeyWord + "-" + Common.CFun.GetPropertyByName("sys", "WebName");
                        Description = model.Title + "-" + model.KeyWord + "-" + Common.CFun.GetPropertyByName("sys", "WebName");

                        model.Contents = Common.CFun.UnEscape(model.Contents);
                        InitPage();
                        model.Click += 1;
                        Comment = GetComment(model.ID);
                        ArticleBll.Update(model);
                    }
                }
            }
        }
        public void InitPage()
        {
            DataTable dtn = Common.SqliteHelper.GetUpOrNextPage("Article", " Kind <> 'Sys' and IsLock='n'", "CreateDate", model.CreateDate, "n");
            prvModel = Common.CFun.DtToModel<Article>(dtn);
            DataTable dtu = Common.SqliteHelper.GetUpOrNextPage("Article", " Kind <> 'Sys' and IsLock='n'", "CreateDate", model.CreateDate, "u");
            nextModel = Common.CFun.DtToModel<Article>(dtu);

            if (prvModel == null)
            {
                prvModel = new Article();
                prvModel.ID = "#";
                prvModel.Title = "没有了！";
            }
            else
            {
                prvModel.ID = "Article.aspx?id=" + prvModel.ID;
            }
            if (nextModel == null)
            {
                nextModel = new Article();
                nextModel.ID = "#";
                nextModel.Title = "没有了";
            }
            else
            {
                nextModel.ID = "Article.aspx?id=" + nextModel.ID;
            }
        }
        public string GetComment(string ID)
        {
            string reStr = string.Empty;
            DataTable dt = ArticleBll.GetComment(ID, "");
            CommentCount = dt.Rows.Count.ToString();
            foreach (DataRow row in dt.Rows)
            {
                reStr += string.Format("<li><b>{0}</b>说:<br />\r\n<p style=\"text-indent: 2em\">{1}</p>\r\n</li>", Common.CFun.HidenLastIp(row["Name"].ToString()), row["Contents"]);
            }
            return reStr;
        }
    }
}