﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Model;
using Bll;
using System.Data;
using System.Text;

namespace Share
{
    public partial class ArticleList : System.Web.UI.Page
    {
        protected string PageBar = string.Empty;
        protected List<Model.Article> pageList;
        protected string TitleStr = "";
        protected string Description = "";
        protected string Keywords = "";
        protected string wStr = "";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {

                int recordCount = 0;
                int pageIndex = Common.CFun.GetQueryInt("PageID", this.Context);
                pageIndex = pageIndex == 0 ? 1 : pageIndex;
                int pageSize = Common.CFun.GetQueryInt("rows", this.Context);
                pageSize = pageSize == 0 ? 10 : pageSize;

                string w = Common.CFun.Substring(Common.CFun.GetQueryString("word", this.Context), 0, 38);

                String colNames = "";
                String order = "CreateDate desc";
                String dbName = "";
                String where = " Kind <> 'Sys' and IsLock='n' and " + GetKeyWordsWhere(w);

                object[] p = { };

                string date = Common.CFun.GetQueryString("date", this.Context);
                string CID = Common.CFun.GetQueryString("CID", this.Context);

                string TypeName = string.Empty;
                Model.SysType model = SysTypeBll.GetModel(CID);
                if (model != null) TypeName = model.TypeName;
                TitleStr = w + "-" + TypeName + "-" + Common.CFun.GetPropertyByName("sys", "Title") + "-" + Common.CFun.GetPropertyByName("sys", "WebName");
                Keywords = wStr + "-" + TypeName;
                Description = wStr + "-" + TypeName + "-文章列表-" + Common.CFun.GetPropertyByName("sys", "WebName");

                if (!string.IsNullOrEmpty(date))
                {
                    where = "  Kind <> 'Sys' and IsLock='n' and strftime('%Y%m' ,CreateDate)=?";
                    p = new object[] { date };
                }
                if (!string.IsNullOrEmpty(CID))
                {
                    where = " Kind <> 'Sys' and IsLock='n' and TypeID=?";
                    p = new object[] { CID };

                }


                DataTable dt = ArticleBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
                pageList = Common.CFun.ToList<Article>(dt);
                PageBar = Common.CFun.GetPageBar(pageIndex, recordCount, pageSize);
            }

        }
       
        public string GetKeyWordsWhere(string words)
        {
            List<string> list = new List<string>();
            StringBuilder sb = new StringBuilder();
            string SegType = Common.CFun.GetPropertyByName("sys", "SegType");
            if (SegType == "baidu")
            {
                list = Common.CFun.GetKeyWordArr(words);
            }
            else
            {
                list = Common.SegmentHelper.SplitKey(words);
            }

            for (int i = 0; i < list.Count; i++)
            {
                if (list[i].Trim().Length > 1)
                {
                    wStr += list[i].Trim() + ",";
                    sb.AppendFormat(" Title like '%{0}%' or ", list[i]);

                    TagLink tag = TagLinkBll.GetModelByTagName(list[i]);

                    if (tag == null)
                    {
                        tag = new TagLink();
                        tag.ID = Common.CFun.GetMaxLsh("S");
                        tag.IsLock = "n";
                        tag.Kind = "TAG";
                        tag.Title = list[i];
                        TagLinkBll.Add(tag);
                    }
                    else
                    {
                        tag.SortID += 1;
                        tag.ImageUrl = Common.CFun.GetIP();
                        tag.Url = Common.CFun.GetReferer();
                        TagLinkBll.Update(tag);
                    }
                }
            }
            string result = sb.ToString();

            if (string.IsNullOrEmpty(result))
            {
                result = " 1=1 ";
            }
            else
            {
                result = "(" + Common.CFun.DelLastChar(result.TrimEnd(), "or") + ")";
            }

            wStr = Common.CFun.DelLastChar(wStr.TrimEnd(), ",");

            return result;
        }
    }
}