﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using System.Text;
using Newtonsoft.Json.Linq;
using System.Text.RegularExpressions;

namespace Share
{
    /// <summary>
    /// Handler 的摘要说明
    /// </summary>
    public class Handler : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            string action = Common.CFun.GetQueryString("action", context);
            string result = string.Empty;

            if (action == "add")
            {
                result = Add();
            }
            else if (action == "artList")
            {
                result = GetArtList();
            }
            else if (action == "jokeList")
            {
                result = GetJokeList();
            }
            else if (action == "sendmsg")
            {
                result = SendMsg();
            }
            context.Response.Write(result);
        }
        public string GetNoRespons()
        {
            string[] nos = new string[]{
             "听不懂啊亲！",
             "你叽里咕噜的说些什么啊，听不懂！",
             "别发那么长啊，听不懂的！",
             "认真点说嘛！",
             "什么乱七八糟的啊！",
             "苍天啊，大地啊，让我看天书啊！",
             "虽然我听不懂你说什么，感觉很厉害的样子！",
             "这到底是肿么啦，肿么啦",
             "看不懂，我问问元芳先！",
             "亲，我听不懂你说什么！",
            "扑通……我从椅子上掉下来了，你看我那么可怜的样子，说点别的吧，我已经处在崩溃的边缘了～",
            "你累不累呀？休息～休息一会吧，我看你挺累的，喝口水一会再说吧！",
            "我真的太崇拜你了，收我为徒吧！我也想让别人尝尝被逼疯的感觉，嘿嘿！",
            "你的话实在太有见地了！不是我这种凡夫俗子可以参透的了的！你真是我的偶像啊～～",
            "你的精神是可嘉的，你的情操是高尚的，但是，好好想想你到底要说什么来着？",
            "和你聊天真的太有意思了！句句都是经典啊！！说点别的经典给我听听吧。",
            "服了你了，我要什么时候才能达到你这种忘我的境界啊，天啊～～～",
            "怎么总是这句啊，你不烦我都嫌烦了，聊点别的吧！",
            "元芳，有人找",
            "亲，在的",
            "亲，我不懂的"
            };
            int i = new Random().Next(0, nos.Length - 1);
            return nos[i];
        }

        public string CheckRepet(string msg)
        {
            if (string.IsNullOrEmpty(msg)) return string.Empty;

            string[] nos = new string[]{
             "你是复读机啊！",
             "好话不用说那么多次的！",
             "我发现一个问题，你特别喜欢重复重复再重复哦，这个习惯可不太好哦，要勇于创新知道不？",
             "怎么总是这句啊，你不烦我都嫌烦了，聊点别的吧！",
             "啊～～～我对你的敬仰犹如滔滔江水绵绵不绝，又犹如黄河泛滥一发不可收拾……",
             "你的话实在太有见地了！不是我这种凡夫俗子可以参透的了的！你真是我的偶像啊～～～",
             "我真的太崇拜你了，收我为徒吧！我也想让别人尝尝被逼疯的感觉，嘿嘿！",
             "你真的好偷懒哦，多说点话嘛，不然我会很无聊的哎！"
            };
            int i = new Random().Next(0, nos.Length - 1);
            int rpt = Common.Encode.ConvertInt32(Common.CacheHelper.GetCache(msg));
            if (rpt < 5)
            {
                rpt = rpt + 1;
                Common.CacheHelper.SetCache(msg, rpt);
                return "";

            }
            else
            {
                Common.CacheHelper.RemoveAllCache(msg);
                return nos[i];
            }
        }
        public string CheckSpeed()
        {

            List<DateTime> list = Common.CacheHelper.GetCache("sendhistory") as List<DateTime>;
            if (list == null)
            {
                list = new List<DateTime>();
            }
            if (list.Count < 20)
            {
                list.Add(DateTime.Now);
                Common.CacheHelper.SetCache("sendhistory", list);
            }
            else
            {
                DateTime max = list.Max();
                DateTime min = list.Min();
                TimeSpan t1 = max - min;
                double t = t1.TotalSeconds;
                int s = (int)t / 20;
                if (s < 1)//20条信息平均速度小于每条1秒则提示发送太快，暂停一分钟
                {
                    DateTime stoptime = Common.Encode.ConvertDateTime(Common.CacheHelper.GetCache("stoptime"));
                    if (stoptime < DateTime.Now)
                    {
                        Common.CacheHelper.SetCache("stoptime", DateTime.Now.AddMinutes(1));
                        Common.CacheHelper.RemoveAllCache("sendhistory");
                    }
                    else
                    {
                        return "你是机器人啊,发那么快,禁言一分钟[过" + (int)(stoptime - DateTime.Now).TotalSeconds + "秒再发]!";
                    }
                }
            }
            return "";
        }
        private string SendMsg()
        {

            string msg = Common.CFun.UnEscape(Common.CFun.GetString("w", HttpContext.Current).Trim());
            string face = Common.CFun.UnEscape(Common.CFun.GetString("face", HttpContext.Current));

            string first = msg;
            if (!string.IsNullOrEmpty(face))
            {
                first = string.Format("[\"face\",{0}]", face);
            }
            string ckspeed = CheckSpeed();
            if (ckspeed.Length > 0)
            {
                return Common.CFun.ResultJson("1", ckspeed);
            }
            string rpt = CheckRepet(msg);
            if ((msg.Contains("问:") || msg.Contains("问：")) &&( msg.Contains("答:") || msg.Contains("答：")))
            {
                msg = msg.Replace("：", ":");
                Regex reg = new Regex("答:");
                string[] msgs = reg.Split(msg.Replace("问:", ""));
                if (msgs.Length == 2)
                {
                    string q = msgs[0].Trim();
                    string a = msgs[1].Trim();
                    string isql = "insert into SayHello (Question,Anser,Rank,Stop) values(?,?,?,?)";
                    object[] p = { q, a, 0, "n" };
                    int r = Common.SqliteHelper.ExecuteNonQuery(isql, Common.SqliteHelper.DbName.Robot, p);
                    if (r > 0)
                    {
                        return Common.CFun.ResultJson("1", "谢谢你，我记住了！");
                    }
                    else
                    {
                        return Common.CFun.ResultJson("1", "我生病了，记不住了，麻烦告诉我主人让他给我治病！");
                    }

                }
                else
                {
                    return Common.CFun.ResultJson("1", "亲，格式不对哦！ 正确格式要这样：如 问:你爱我吗？ 答:你说呢");
                }

            }
            else if (rpt.Length > 0 && !msg.Contains("笑话") && !msg.Contains("语录"))
            {
                return Common.CFun.ResultJson("1", rpt);
            }
            string sql = string.Empty;
            DataTable dt = null;
            string reStr = string.Empty;
            if (msg.Contains("笑话"))
            {
                sql = "SELECT Question,Anser,10 len FROM Joke order by RANDOM() limit 1";
                dt = Common.SqliteHelper.ExecuteDataTable(sql, Common.SqliteHelper.DbName.Joke);
                if (dt.Rows.Count == 1)
                {
                    reStr = dt.Rows[0]["Question"] + ":\r\n" + dt.Rows[0]["Anser"];
                }
                return Common.CFun.ResultJson("1", reStr);
            }
            else if (msg.Contains("语录"))
            {
                return Common.CFun.ResultJson("1", "语录");
            }
            else
            {


                string where = GetKeyWordsWhere(msg);

                if (!string.IsNullOrEmpty(where))
                {
                    sql = @"
                select Anser,10 len from SayHello where  Question=?
                union all
                select Anser,(case when length(Question)= length(?) and Question=? then 10 
                when length(Question)= length(?) then 9 else 0 end)len  
                from SayHello where (" + where + @")  
                order by len desc limit  0,20 ";
                }
                else if (string.IsNullOrEmpty(where) && !string.IsNullOrEmpty(face))
                {
                    sql = @"select Anser,len from (select Anser,10 len from SayHello where  Question=? order by len desc limit  0,20) order by RANDOM() limit 1";
                }
                dt = Common.SqliteHelper.ExecuteDataTable(sql, Common.SqliteHelper.DbName.Robot, new object[] { first, msg, msg, msg });

                if (dt.Rows.Count > 0)
                {
                    //if (dt.Rows[0]["len"].ToString() == "10")
                    //{
                    //    reStr = dt.Rows[0]["Anser"].ToString();
                    //}
                    //else
                    //{
                    int i = new Random().Next(0, dt.Rows.Count - 1);
                    reStr = dt.Rows[i]["Anser"].ToString();
                    //}
                    Regex reg = new Regex(@"(\[bq)\d{1,3}(\])");
                    MatchCollection ms = reg.Matches(reStr);
                    foreach (Match item in ms)
                    {
                        int fid = Common.Encode.ConvertInt32(item.Value.ToString().Replace("[bq", "").Replace("]", ""));
                        string img = string.Format("<img class=\"msg-face\" mark=\"[face{0}]\" src=\"http://0.web.qstatic.com/webqqpic/style/face/{0}.gif\"/>", fid);
                        reStr = reStr.Replace(string.Format("[bq{0}]", fid), img);
                    }
                    reStr = reStr.Replace("[wo]", "我").Replace("[ni]", "你");
                }
                else
                {
                    reStr = GetNoRespons();
                }
                return Common.CFun.ResultJson("1", reStr);
            }
        }
        public string GetKeyWordsWhere(string words)
        {
            List<string> list = new List<string>();
            StringBuilder sb = new StringBuilder();

            list = Common.SegmentHelper.SplitKey(words);

            for (int i = 0; i < list.Count; i++)
            {
                if (list[i].Trim().Length > 1)
                {
                    sb.AppendFormat(" Question like '%{0}%' or ", list[i]);
                }
            }
            string result = sb.ToString();
            result += string.Format(" Question like '%{0}%' ", words);
            return result;
        }
        private string GetArtList()
        {
            int recordCount = 0;
            int pageIndex = Common.CFun.GetQueryInt("PageID", HttpContext.Current);
            int pageSize = 10;
            String colNames = "";
            String order = "CreateDate desc";
            String dbName = "";
            String where = " Kind <> 'Sys' and IsLock='n'";
            DataTable dt = ArticleBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName);
            StringBuilder result = new StringBuilder();
            foreach (DataRow row in dt.Rows)
            {
                result.AppendFormat(@"<div class='itemcontent'>
                                <h2>
                                    <a href='Article.aspx?id={0}'>
                                        {1}</a>
                                </h2>
                                <p class='pcontent'>
                                    {2}
                                </p>
                                <div class='contentfooter'>
                                    <ul>
                                        <li><a href='Article.aspx?id={0}'>阅读全文>></a></li>
                                        <li>标签：<a href='ArticleList.aspx?page=1&rows=10&word={3}'>{3}</a></li>
                                        <li>浏览量：(<font color='red'>{4}</font>)</li>
                                        <li>评论：(<font color='red'>{5}</font>)</li>
                                    </ul>
                                </div>
                            </div>",
                            row["ID"], row["Title"], row["Introduction"], row["KeyWord"], row["Click"], Bll.CommentBll.GetCommentCount(row["ID"].ToString(), ""));
            }
            string reStr = Common.CFun.Escape(result.ToString());
            if (string.IsNullOrEmpty(reStr)) return "0";
            return reStr;
        }
        private string GetJokeList()
        {
            int pageIndex = Common.CFun.GetQueryInt("PageID", HttpContext.Current);
            int pageSize = 15;
            string sql = string.Format("SELECT Question,Anser FROM Joke limit {0},{1}", pageIndex - 1 * pageSize, pageIndex * pageSize);
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql, Common.SqliteHelper.DbName.Joke);
            StringBuilder result = new StringBuilder();
            foreach (DataRow row in dt.Rows)
            {
                result.AppendFormat(@"<div class='itemcontent'>
                                <h2>{0} 
                                </h2>
                                <p class='pcontent'>
                                    {1}
                                </p>
                            </div>",
                            row["Question"], row["Anser"]);
            }
            string reStr = Common.CFun.Escape(result.ToString());
            if (string.IsNullOrEmpty(reStr)) return "0";
            return reStr;
        }
        public string Add()
        {
            string Content = Common.CFun.HtmlEncode(Common.CFun.GetString("CommentContent", HttpContext.Current));
            string CID = Common.CFun.GetString("CID", HttpContext.Current);
            string Title = Common.CFun.HtmlEncode(Common.CFun.GetString("Title", HttpContext.Current));

            if (string.IsNullOrEmpty(Content)) return "请认真填写你的评论！";
            if (Content.Length > 130) return "只能输入130个字符！";

            string KillKeyWords = Common.CFun.GetPropertyByName("sys", "KillKeyWords");
            string[] KillWords = KillKeyWords.Split(',');
            for (int i = 0; i < KillWords.Length; i++)
            {
                if (Content.IndexOf(KillWords[i]) > -1)
                {
                    return "评论内容包含禁止关键字！";
                }
            }
            Comment model = new Comment();
            model.AddTime = Common.Encode.GetCurDateTime();
            model.CID = CID;
            model.Contents = Content;
            model.Name = Common.CFun.GetIP();
            model.Title = Title;
            model.UrlReferrer = Common.CFun.GetReferer();
            int result = CommentBll.Add(model);
            return "评论成功！";
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}