﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using Model;
using Bll;
using System.Text;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share
{
    public partial class Site1 : System.Web.UI.MasterPage
    {
        protected string RanTopten = "";//随机10条
        protected string Topten = "";//阅读排行
        protected string DateGroup = "";//日期归类
        protected string ArticleType = "";//文章类别
        protected string GongGao = "暂无公告！";//公告
        protected string Menu = "";//导航
        protected string FridenLink = "";//友情链接
        protected string CommentNew = string.Empty;//最新评论
        protected string WebUrl = string.Empty;
        protected string Footer = string.Empty;//底部信息，ICP，统计代码
        protected string Tags = string.Empty;
        protected string NewTopTen = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                Menu = GetMenu();
                GongGao = GetGongGao();
                DateGroup = GetDateGroup();
                ArticleType = GetSysType();
                Topten = GetTopten();
                RanTopten = GetRanTopten();
                WebUrl = Common.CFun.GetPropertyByName("sys", "WebUrl");
                Footer = GetFooter();
                CommentNew = GetCommentNew();
                FridenLink = GetFridenLink();
                Tags = GetTags();
                NewTopTen = GetNewTopTen();
            }
        }

        public string GetFooter()
        {

            string CopyRight = Common.CFun.GetPropertyByName("sys", "CopyRight");
            string TongJi = Common.Encode.HtmlDecode(Common.CFun.GetPropertyByName("sys", "TongJi"));
            string ICP = Common.CFun.GetPropertyByName("sys", "ICP");
            string reStr = string.Empty;
            reStr = CopyRight + "<BR>" + ICP + TongJi;
            return reStr;
        }
        //阅读排行
        public string GetTopten()
        {
            string reStr = string.Empty;
            string sql = "SELECT  ID,Title FROM Article where Kind <> 'Sys' and IsLock='n' order by Click desc limit 0,9";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql);
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";
                reStr += string.Format("<li {0}><a href=\"Article.aspx?id={1}\"><b class='b{3}'>{3}</b>.{2}</a></li>", lastclass, row["ID"], row["Title"], (i+1).ToString());
            }
            return reStr;
        }
        //随机10条
        public string GetRanTopten()
        {
            string reStr = string.Empty;
            string sql = "SELECT  ID,Title FROM Article where Kind <> 'Sys' and IsLock='n'  ORDER BY RANDOM() limit 10";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql);
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";
                reStr += string.Format("<li {0}><a href=\"Article.aspx?id={1}\">{2}</a></li>", lastclass, row["ID"], row["Title"]);
            }
            return reStr;
        }
        //最新10条
        public string  GetNewTopTen()
        {
            string reStr = string.Empty;
            int recordCount = 0;
            String colNames = "";
            String order = "CreateDate desc";
            String dbName = "";
            String where = " Kind <> 'Sys' and IsLock='n'";
            DataTable dt = ArticleBll.GetPageData(ref recordCount, 1, 10, colNames, where, order, dbName, new object { });
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";
                reStr += string.Format("<li {0}><a href=\"Article.aspx?id={1}\">{2}</a></li>", lastclass, row["ID"], row["Title"]);
            }
            return reStr;
        }
        //最新评论
        public string GetCommentNew()
        {
            string reStr = string.Empty;
            string sql = "SELECT CID,Contents FROM Comment  order by AddTime desc  limit 0,10";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql);
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";

                reStr += string.Format("<li {0}><a href=\"Article.aspx?id={1}\">{2}</a></li>", lastclass, row["CID"], Common.CFun.GetContentSummary(row["Contents"].ToString(), 11, false));
            }
            return reStr;
        }
        //公告
        private string GetGongGao()
        {
            string reStr = string.Empty;
            Article art = ArticleBll.GetModel("gonggao");
            if (art != null)
            {
                reStr = Common.CFun.UnEscape(art.Contents);
            }
            return reStr;
        }
        //导航栏
        private string GetMenu()
        {
            string reStr = string.Empty;
            DataTable dtMenu = Common.SqliteHelper.ExecuteDataTable("SELECT ID,Title,Url,Target,Style,ImageUrl,ParentID FROM TagLink where Kind='Menu' and IsLock='n'  order by SortID");
            DataRow[] drRoot = dtMenu.Select("ParentID=''");
            foreach (DataRow row in drRoot)
            {

                string strChild = "";//二级
                DataRow[] drChild = dtMenu.Select(string.Format("ParentID='{0}'", row["ID"]));
                if (drChild.Length > 0)
                {
                    strChild += "<br/><ul class='second'>";
                    foreach (DataRow dr in drChild)
                    {
                        strChild += string.Format("<li {2}><a href=\"{0}\" target=\"{1}\">{3}</a></li>", dr["Url"], dr["Target"], dr["Style"], dr["Title"]);
                    }
                    strChild += "</ul>";
                }
                reStr += string.Format("<li {2}><a href=\"{0}\" target=\"{1}\">{3}</a>{4}</li>", row["Url"], row["Target"], row["Style"], row["Title"], strChild);

            }
            return string.Format("<ul class='menu'>{0}</ul>", reStr);
        }
        //友情链接
        private string GetFridenLink()
        {
            string reStr = string.Empty;
            DataTable dt = Common.SqliteHelper.ExecuteDataTable("SELECT Title,Url,Target,Style,ImageUrl FROM TagLink where Kind='FriendLink' and IsLock='n' order by SortID");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                reStr += string.Format("<li {2}><a href=\"{0}\" target=\"{1}\">{3}</a></li>", row["Url"], row["Target"], row["Style"], row["Title"]);
            }
            return reStr;
        }

        //日期归档
        private string GetDateGroup()
        {
            string reStr = string.Empty;
            DataTable dt = Common.SqliteHelper.ExecuteDataTable("SELECT  count (1)Total,strftime('%Y年%m月' ,CreateDate)DateGroup FROM Article where Kind <> 'Sys' and IsLock='n'  group by strftime('%Y年%m月' ,CreateDate)");
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";
                reStr += string.Format("<li {0}><a href=\"ArticleList.aspx?date={1}\">{2}({3})</a></li>", lastclass, row["DateGroup"].ToString().Replace("年", "").Replace("月", ""), row["DateGroup"], row["Total"]);
            }
            return reStr;
        }
        //文章归类
        private string GetSysType()
        {
            string reStr = string.Empty;
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(string.Format("SELECT TypeID,TypeName,(select count(1) from Article where TypeID=s.TypeID)Total  FROM SysType s where Kind='Article'"));
            string lastclass = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                if (i == dt.Rows.Count - 1) lastclass = "class=\"last\"";
                reStr += string.Format("<li {0}><a href=\"ArticleList.aspx?CID={1}\">{2}({3})</a></li>", lastclass, row["TypeID"], row["TypeName"], row["Total"]);
            }
            return reStr;
        }

        public string GetTags()
        {
            StringBuilder result = new StringBuilder();
            string sql = "SELECT ID,Title,SortID FROM TagLink where Kind='TAG' and IsLock='n' order by SortID desc limit 0,50";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql);
            foreach (DataRow row in dt.Rows)
            {
                result.AppendFormat("<a href='/ArticleList.aspx?word={0}' {1}>{2}</a>", Server.UrlEncode(row["Title"].ToString()), GetStyle(row["SortID"]), row["Title"].ToString());
            }
            return result.ToString();
        }
        public string GetStyle(object click)
        {
            string sql = string.Format("SELECT Rvalue,Mark FROM SysRule where Svalue>{0} order by Svalue asc limit 0,1", click);
            string result = string.Empty;
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql, "");
            if (dt.Rows.Count == 0)
            {
                sql = "SELECT Rvalue,Mark FROM SysRule order by Svalue desc limit 0,1";
                dt = Common.SqliteHelper.ExecuteDataTable(sql, "");
            }
            if (dt.Rows.Count == 1)
            {
                result = string.Format("style='color:{0}; font-size:{1}px;'", dt.Rows[0]["Mark"], dt.Rows[0]["Rvalue"]);
            }
            return result;
        }
    }
}