/*
 * Media Element jQuery plugin
 * http://mediaelementjs.com/
 *
 * Creates a controller bar for HTML5 <video> add <audio> tags
 * using jQuery and MediaElement.js
 *
 * Copyright 2010, John Dyer
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 * Version: 1.1.3
 */
(function(a){mejs.MepDefaults={defaultVideoWidth:480,defaultVideoHeight:270,videoWidth:-1,videoHeight:-1,audioWidth:300,audioHeight:30,startVolume:0.8,loop:false,startLanguage:"",translations:[],translationSelector:false,googleApiKey:"",controls:{playpause:true,timerail:true,duration:true,volume:true,captions:true,fullscreen:true},controlsTemplate:'<div class="mep-playpause-button mep-play"><span></span></div><div class="mep-time-rail"><span class="mep-time-total"><span class="mep-time-loaded"></span><span class="mep-time-current"></span><span class="mep-time-handle"></span></span></div><div class="mep-time"><span class="mep-currenttime"></span><span>&nbsp;|&nbsp;</span><span class="mep-duration"></span></div><div class="mep-captions-button"><span></span><div class="mep-captions-selector"><ul></ul></div></div><div class="mep-volume-button mep-mute"><span></span><div class="mep-volume-slider"><div class="mep-volume-rail"><div class="mep-volume-handle"></div></div></div></div><div class="mep-fullscreen-button"><span></span></div>'};mejs.mepIndex=0;mejs.MediaElementPlayer=function(d,e){var b=this,c=mejs.MediaFeatures;b.$media=a(d);b.options=a.extend(true,{},mejs.MepDefaults,e);b.isVideo=(b.$media[0].tagName.toLowerCase()=="video");if(c.isiPad||c.isiPhone){b.$media.attr("controls","controls");b.$media.removeAttr("poster");if(c.isiPad&&b.$media[0].getAttribute("autoplay")!==null){b.$media[0].load();b.$media[0].play()}return}else{if(c.isAndroid&&b.isVideo){b.$media.attr("controls","controls");return}else{b.$media.removeAttr("controls")}}b.createPlayer()};mejs.MediaElementPlayer.prototype={createPlayer:function(){var b=this,c=a.extend(true,{},b.options,{success:function(d,e){b.setupPlayer(d,e)},error:function(d){b.handleError(d)}});b.id="mep_"+mejs.mepIndex++;b.$media.before(a('<div id="'+b.id+'" class="mep-container"><div class="mep-mediaelement"></div><div class="mep-captions-layer"><span class="mep-captions-text"></span></div><div class="mep-poster"><img /></div><div class="mep-overlay"><div class="mep-overlay-button"></div></div><div class="mep-chapters"></div><div class="mep-controls">'+b.options.controlsTemplate+'</div><div class="mep-clear"></div></div>'));b.container=a("#"+this.id);b.container.find(".mep-captions-selector ul").append(a('<li><input type="radio" name="'+this.id+'_captions" id="'+this.id+'_captions_none" value="none" checked="checked" /><label for="'+this.id+'_captions_none">None</label></li>'));b.container.addClass(b.$media[0].className).find(".mep-mediaelement").append(b.$media);if(b.isVideo){b.width=(b.options.videoWidth>0)?b.options.videoWidth:(b.$media[0].getAttribute("width")!==null)?b.$media.attr("width"):b.options.defaultVideoWidth;b.height=(b.options.videoHeight>0)?b.options.videoHeight:(b.$media[0].getAttribute("height")!==null)?b.$media.attr("height"):b.options.defaultVideoHeight}else{b.width=b.options.audioWidth;b.height=b.options.audioHeight}b.buildPoster();b.buildOverlay();b.buildCaptionsDisplay();b.setPlayerSize(b.width,b.height);b.buildControls();c.pluginWidth=b.height;c.pluginHeight=b.width;mejs.MediaElement(b.$media[0],c)},setupPlayer:function(b,d){var c=this;c.mediaElement=b;c.domNode=d;if(c.isVideo){c.overlay.show()}c.buildControlBar();c.buildPlayPause();c.buildTimeRail();c.buildVolumeControls();c.buildCaptionsControls();c.buildFullscreen();c.mediaElement.addEventListener("click",function(f){if(c.mediaElement.paused){c.mediaElement.play()}},true);c.mediaElement.addEventListener("play",function(f){c.poster.hide();c.overlay.hide();c.playpause.removeClass("mep-play").addClass("mep-pause")},true);c.mediaElement.addEventListener("playing",function(f){c.poster.hide();c.overlay.hide();c.playpause.removeClass("mep-play").addClass("mep-pause")},true);c.mediaElement.addEventListener("pause",function(f){if(c.isVideo){c.overlay.show()}c.playpause.removeClass("mep-pause").addClass("mep-play")},true);c.mediaElement.addEventListener("paused",function(f){if(c.isVideo){c.overlay.show()}c.playpause.removeClass("mep-pause").addClass("mep-play")},true);c.mediaElement.addEventListener("ended",function(f){c.mediaElement.setCurrentTime(0);c.mediaElement.pause();if(c.options.loop){c.mediaElement.play()}else{c.poster.show();c.overlay.show();c.controls.css("visibility","visible");c.playpause.removeClass("mep-pause").addClass("mep-play");c.setTimePosition()}},true);c.mediaElement.addEventListener("loadedmetadata",function(f){if(c.isVideo&&c.options.videoHeight<=0&&c.$media[0].getAttribute("height")===null&&!isNaN(f.target.videoHeight)){c.setPlayerSize(f.target.videoWidth,f.target.videoHeight);c.setRailSize();c.mediaElement.setVideoSize(f.target.videoWidth,f.target.videoHeight)}},true);setTimeout(function(){c.setRailSize()},50);if(c.options.success){c.options.success(c.mediaElement,c.domNode)}this.findTracks()},buildCaptionsDisplay:function(){var d=this,b="",c;d.captionsDisplay=d.container.find(".mep-captions-layer").hide();d.captionsText=d.container.find(".mep-captions-text");if(d.options.translationSelector){for(c in mejs.language.codes){b+='<option value="'+c+'">'+mejs.language.codes[c]+"</option>"}d.container.find(".mep-captions-selector ul").before(a('<select class="mep-captions-translations"><option value="">--Add Translation--</option>'+b+"</select>"));d.container.find(".mep-captions-translations").change(function(){var e=a(this);lang=e.val();if(lang!=""){d.tracks.push({srclang:lang,src:null,entries:[],isLoaded:false,isTranslation:true});if(!d.isLoadingTrack){d.trackToLoad--;d.addTrackButton(lang,true);d.options.startLanguage=lang;d.loadNextTrack()}}})}},buildCaptionsControls:function(){var c=this,d,b;c.captions.delegate("input[type=radio]","click",function(){d=this.value;if(d=="none"){c.selectedTrack=null}else{for(b=0;b<c.tracks.length;b++){if(c.tracks[b].srclang==d){c.selectedTrack=c.tracks[b];c.captionsDisplay.attr("lang",c.selectedTrack.srclang);c.displayCaptions();break}}}})},findTracks:function(){var c=this,b,d=c.$media.find("track");c.tracks=[];c.trackToLoad=-1;c.selectedTrack=null;c.isLoadingTrack=false;d.each(function(){c.tracks.push({srclang:a(this).attr("srclang").toLowerCase(),src:a(this).attr("src"),kind:a(this).attr("kind"),entries:[],isLoaded:false,isTranslation:false})});if(c.tracks.length>0&&c.options.translations.length>0){for(b=0;b<c.options.translations.length;b++){c.tracks.push({srclang:c.options.translations[b].toLowerCase(),src:null,kind:"subtitles",entries:[],isLoaded:false,isTranslation:true})}}for(b=0;b<c.tracks.length;b++){if(c.tracks[b].kind=="subtitles"){c.addTrackButton(c.tracks[b].srclang,c.tracks[b].isTranslation)}}if(c.tracks.length>0){c.loadNextTrack()}else{c.captions.remove();c.setRailSize()}},loadNextTrack:function(){var b=this;b.trackToLoad++;if(b.trackToLoad<b.tracks.length){b.isLoadingTrack=true;b.loadTrack(b.trackToLoad)}else{b.isLoadingTrack=false}},loadTrack:function(c){var d=this,b=d.tracks[c],e=function(){b.isLoaded=true;d.enableTrackButton(b.srclang);d.loadNextTrack()};if(b.isTranslation){mejs.SrtParser.translateSrt(d.tracks[0].entries,d.tracks[0].srclang,b.srclang,d.options.googleApiKey,function(f){b.entries=f;e()})}else{a.ajax({url:b.src,success:function(f){b.entries=mejs.SrtParser.parse(f);e()},error:function(){d.loadNextTrack()}})}},enableTrackButton:function(c){var b=this;b.captions.find("input[value="+c+"]").attr("disabled","").siblings("label").html(mejs.language.codes[c]||c);if(b.options.startLanguage==c){a("#"+b.id+"_captions_"+c).click()}b.adjustLanguageBox()},addTrackButton:function(e,d){var c=this,b=mejs.language.codes[e]||e;c.captions.find("ul").append(a('<li><input type="radio" name="'+c.id+'_captions" id="'+c.id+"_captions_"+e+'" value="'+e+'" disabled="disabled" /><label for="'+c.id+"_captions_"+e+'">'+b+((d)?" (translating)":" (loading)")+"</label></li>"));c.adjustLanguageBox();c.container.find(".mep-captions-translations option[value="+e+"]").remove()},adjustLanguageBox:function(){var b=this;b.captions.find(".mep-captions-selector").height(b.captions.find(".mep-captions-selector ul").outerHeight(true)+b.captions.find(".mep-captions-translations").outerHeight(true))},displayCaptions:function(){if(typeof this.tracks=="undefined"){return}var d=this,c,b=d.selectedTrack;if(b!=null&&b.isLoaded){for(c=0;c<b.entries.times.length;c++){if(d.mediaElement.currentTime>=b.entries.times[c].start&&d.mediaElement.currentTime<=b.entries.times[c].stop){d.captionsText.html(b.entries.text[c]);d.captionsDisplay.show();return}}d.captionsDisplay.hide()}else{d.captionsDisplay.hide()}},buildPoster:function(){var b=this;b.poster=b.container.find(".mep-poster");b.posterImg=b.poster.find("img");b.posterUrl=b.$media.attr("poster");b.posterUrl=(b.posterUrl===null||b.posterUrl==undefined)?"":b.posterUrl;if(b.posterUrl!==""){b.posterImg.attr("src",b.posterUrl)}else{b.poster.hide()}},buildOverlay:function(){var b=this;b.overlay=b.container.find(".mep-overlay");b.overlay.bind("click",function(c){if(b.mediaElement.paused){b.mediaElement.play()}});b.overlay.hide()},buildControls:function(){var b=this;b.controls=b.container.find(".mep-controls");b.isControlsVisible=true;b.playpause=b.controls.find(".mep-playpause-button");b.fullscreen=b.controls.find(".mep-fullscreen-button");if(!b.isVideo){b.fullscreen.remove()}b.time=b.controls.find(".mep-time");b.currentTime=b.controls.find(".mep-currenttime").html("00:00");b.duration=b.controls.find(".mep-duration").html("00:00");b.captions=b.controls.find(".mep-captions-button");b.mute=b.controls.find(".mep-volume-button");b.volumeSlider=b.controls.find(".mep-volume-slider");b.volumeRail=b.controls.find(".mep-volume-rail");b.volumeHandle=b.controls.find(".mep-volume-handle");b.timeRail=b.controls.find(".mep-time-rail");b.timeCurrent=b.timeRail.find(".mep-time-current").width(0);b.timeLoaded=b.timeRail.find(".mep-time-loaded").width(0);b.timeTotal=b.timeRail.find(".mep-time-total");b.timeHandle=b.controls.find(".mep-time-handle");b.controls.show();b.setRailSize();b.controls.hide();if(!b.options.controls.playpause){b.playpause.remove()}if(!b.options.controls.timerail){b.timeRail.remove()}if(!b.options.controls.duration){b.time.remove()}if(!b.options.controls.volume){b.mute.remove()}if(!b.options.controls.fullscreen){b.fullscreen.remove()}},buildControlBar:function(){var b=this;b.controls.show();if(b.isVideo){b.container.bind("mouseenter",function(){b.controls.css("visibility","visible");b.controls.fadeIn(200);b.captionsDisplay.css("padding-bottom",b.controls.height()+5);b.setRailSize();b.isControlsVisible=true}).bind("mouseleave",function(){if(!b.mediaElement.paused){b.controls.fadeOut(200,function(){a(this).css("visibility","hidden");a(this).css("display","block");b.captionsDisplay.css("padding-bottom",10)});b.isControlsVisible=false}})}},buildPlayPause:function(){var b=this;b.playpause.bind("click",function(){if(b.playpause.hasClass("mep-play")){b.mediaElement.play();b.playpause.removeClass("mep-play").addClass("mep-pause")}else{b.mediaElement.pause();b.playpause.removeClass("mep-pause").addClass("mep-play")}})},buildTimeRail:function(){var b=this;b.timeRail.delegate("span","click",function(h){var c=h.pageX,i=b.timeTotal.offset(),f=b.timeTotal.outerWidth(),d=((c-i.left)/f),g=d*b.mediaElement.duration;b.mediaElement.setCurrentTime(g)});b.mediaElement.addEventListener("timeupdate",function(c){b.displayCaptions();b.setTimePosition();b.setTimeLoaded(c.target)},true);b.mediaElement.addEventListener("progress",function(c){b.setTimeLoaded(c.target)},true)},setTimePosition:function(){var b=this,d,c;if(b.mediaElement.currentTime&&b.mediaElement.duration){b.currentTime.html(mejs.Utility.secondsToTimeCode(b.mediaElement.currentTime));if(b.mediaElement.duration){b.duration.html(mejs.Utility.secondsToTimeCode(b.mediaElement.duration))}d=b.timeTotal.width()*b.mediaElement.currentTime/b.mediaElement.duration;c=d-(b.timeHandle.width()/2);b.timeCurrent.width(d);b.timeHandle.css("left",c)}},setTimeLoaded:function(d){var b=this,c=null;if(d&&d.bytesTotal!=undefined&&d.bytesTotal>0&&d.bufferedBytes!=undefined){c=d.bufferedBytes/d.bytesTotal}else{if(d&&d.buffered&&d.buffered.length>0&&d.buffered.end&&d.duration){c=d.buffered.end(0)/d.duration}}if(c!==null){b.timeLoaded.width(b.timeTotal.width()*c)}},setRailSize:function(){var b=this,c=b.playpause.outerWidth(true)+b.time.outerWidth(true)+b.mute.outerWidth(true)+b.captions.outerWidth(true)+((b.isVideo)?b.fullscreen.outerWidth(true):0),d=b.controls.width()-c-(b.timeRail.outerWidth(true)-b.timeRail.outerWidth(false));b.timeRail.width(d);b.timeTotal.width(d-(b.timeTotal.outerWidth(true)-b.timeTotal.width()))},setPlayerSize:function(d,b){var c=this;c.width=parseInt(d,10);c.height=parseInt(b,10);c.container.width(c.width).height(c.height);c.captionsDisplay.width(c.width);c.overlay.width(c.width).height(c.height);c.posterImg.height(c.height).width(c.width)},handleError:function(c){var b=this;b.$media.hide();b.overlay.hide();b.controls.hide();b.poster.hide()},buildFullscreen:function(){var b=this;b.isFullScreen=false;b.normalHeight=0;b.normalWidth=0;b.fullscreen.bind("click",function(){b.setFullScreen(!b.isFullScreen)})},setFullScreen:function(b){var c=this;switch(c.mediaElement.pluginType){case"flash":c.mediaElement.setFullscreen(b);break;case"silverlight":c.mediaElement.setFullscreen(b);break;case"native":if(mejs.MediaFeatures.hasNativeFullScreen){if(b){c.mediaElement.webkitEnterFullScreen()}else{c.mediaElement.webkitExitFullScreen()}}else{if(b){c.normalHeight=c.$media.height();c.normalWidth=c.$media.width();c.container.addClass("mep-container-fullscreen").width("100%").height("100%").css("z-index",1000);c.$media.width("100%").height("100%");c.captionsDisplay.width("100%");c.overlay.width("100%").height("100%");c.posterImg.width("100%").height("auto");c.fullscreen.removeClass("mep-fullscreen").addClass("mep-unfullscreen");c.setRailSize();c.escB=function(d){c.escListener(d)};c.resB=function(d){c.resizeListener(d)};a(document).bind("keydown",c.escB);a(window).bind("resize",c.resB)}else{c.container.removeClass("mep-container-fullscreen").width(c.normalWidth).height(c.normalHeight).css("z-index",1);c.$media.width(c.normalWidth).height(c.normalHeight);c.posterImg.width(c.normalWidth).height(c.normalHeight);c.captionsDisplay.width(c.normalWidth);c.fullscreen.removeClass("mep-unfullscreen").addClass("mep-fullscreen");c.setRailSize();a(document).unbind("keydown",c.escB);a(window).unbind("resize",c.resB)}}}c.isFullScreen=b},escListener:function(b){if(b.keyCode==27){this.setFullScreen(false)}},resizeListener:function(b){this.setRailSize()},buildVolumeControls:function(){var b=this;b.vmmB=function(c){b.volumeMove(c)};b.vrmB=function(c){b.removeMouseMove(c)};b.volumeSlider.bind("mousedown",function(c){b.volumeMove(c);a(document).bind("mousemove",b.vmmB).bind("mouseup",b.vrmB)});b.mute.find("span").bind("click",function(){if(b.mediaElement.muted){b.mediaElement.setMuted(false);b.mute.removeClass("mep-unmute").addClass("mep-mute");b.positionVolumeHandle(1)}else{b.mediaElement.setMuted(true);b.mute.removeClass("mep-mute").addClass("mep-unmute");b.positionVolumeHandle(0)}});b.mediaElement.addEventListener("volumechange",function(c){b.positionVolumeHandle(c.target.volume)},true);b.mediaElement.setVolume(b.options.startVolume)},volumeMove:function(g){var c=this,b=c.volumeRail.height(),f=g.pageY-c.volumeRail.offset().top,d=(b-f)/b;if(f<0){f=0}else{if(f>b){f=b}}c.volumeHandle.css("top",f-(c.volumeHandle.height()/2));if(d==0){c.mediaElement.setMuted(true);c.mute.removeClass("mep-mute").addClass("mep-unmute")}else{c.mediaElement.setMuted(false);c.mute.removeClass("mep-unmute").addClass("mep-mute")}c.mediaElement.setVolume(d)},positionVolumeHandle:function(c){var b=this;b.volumeHandle.css("top",b.volumeRail.height()-(b.volumeRail.height()*c)-(b.volumeHandle.height()/2))},removeMouseMove:function(){var b=this;a(document).unbind("mousemove",b.vmmB).unbind("mouseup",b.vrmB)}};mejs.language={codes:{af:"Afrikaans",sq:"Albanian",ar:"Arabic",be:"Belarusian",bg:"Bulgarian",ca:"Catalan",zh:"Chinese","zh-cn":"Chinese Simplified","zh-tw":"Chinese Traditional",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch",en:"English",et:"Estonian",tl:"Filipino",fi:"Finnish",fr:"French",gl:"Galician",de:"German",el:"Greek",ht:"Haitian Creole",iw:"Hebrew",hi:"Hindi",hu:"Hungarian",is:"Icelandic",id:"Indonesian",ga:"Irish",it:"Italian",ja:"Japanese",ko:"Korean",lv:"Latvian",lt:"Lithuanian",mk:"Macedonian",ms:"Malay",mt:"Maltese",no:"Norwegian",fa:"Persian",pl:"Polish",pt:"Portuguese",ro:"Romanian",ru:"Russian",sr:"Serbian",sk:"Slovak",sl:"Slovenian",es:"Spanish",sw:"Swahili",sv:"Swedish",tl:"Tagalog",th:"Thai",tr:"Turkish",uk:"Ukrainian",vi:"Vietnamese",cy:"Welsh",yi:"Yiddish"}};mejs.SrtParser={pattern_identifier:/^[0-9]+$/,pattern_timecode:/^([0-9]{2}:[0-9]{2}:[0-9]{2}(,[0-9]{1,3})?) --\> ([0-9]{2}:[0-9]{2}:[0-9]{2}(,[0-9]{3})?)(.*)$/,timecodeToSeconds:function(b){var c=b.split(":");return c[0]*60*60+c[1]*60+parseFloat(c[2].replace(",","."))},split2:function(c,b){return c.split(b)},parse:function(e){var f=0,d=this.split2(e,/\r?\n/),c={text:[],times:[]},b,g;for(;f<d.length;f++){if(this.pattern_identifier.exec(d[f])){f++;b=this.pattern_timecode.exec(d[f]);if(b&&f<d.length){f++;g=d[f];f++;while(d[f]!==""&&f<d.length){g=g+"\n"+d[f];f++}c.text.push(g);c.times.push({start:this.timecodeToSeconds(b[1]),stop:this.timecodeToSeconds(b[3]),settings:b[5]})}}}return c},translateSrt:function(d,j,f,g,h){var b={text:[],times:[]},c,e;this.translateText(d.text.join(" <a></a>"),j,f,g,function(i){c=i.split("<a></a>");for(e=0;e<d.text.length;e++){b.text[e]=c[e];b.times[e]={start:d.times[e].start,stop:d.times[e].stop,settings:d.times[e].settings}}h(b)})},translateText:function(j,f,d,c,i){var l,e=[],h,b=1000,k="",g=function(){if(e.length>0){h=e.shift();mejs.SrtParser.translateChunk(h,f,d,c,function(m){if(m!="undefined"){k+=m}g()})}else{i(k)}};while(j.length>0){if(j.length>b){l=j.lastIndexOf(".",b);e.push(j.substring(0,l));j=j.substring(l+1)}else{e.push(j);j=""}}g()},translateChunk:function(e,g,c,d,f){var b={q:e,langpair:g+"|"+c,v:"1.0"};if(d!==""&&d!==null){b.key=d}a.ajax({url:"https://ajax.googleapis.com/ajax/services/language/translate",data:b,type:"GET",dataType:"jsonp",success:function(h){f(h.responseData.translatedText)},error:function(h){f(null)}})}};if("x\n\ny".split(/\n/gi).length!=3){mejs.SrtParser.split2=function(f,d){var e=[],b="",c;for(c=0;c<f.length;c++){b+=f.substring(c,c+1);if(d.test(b)){e.push(b.replace(d,""));b=""}}e.push(b);return e}}jQuery.fn.mediaelementplayer=function(b){return this.each(function(){return new mejs.MediaElementPlayer(a(this),b)})};window.MediaElementPlayer=mejs.MediaElementPlayer})(jQuery);