<%@Page Language="C#" Inherits="IWMS.Admin.GatherNews" MasterPageFile="admin.master"%>
<asp:Content ContentPlaceHolderId="cphHead" runat="server">
	<script type="text/javascript" src="inc/admin_gathernews.js"></script>
	<script type="text/javascript">
	<!--
	<asp:Literal id="sortArr" runat="server"/>
	var timeOffset=(new Date())-(new Date("<%=DateTime.Now.ToString("R")%>"));
	timeOffset/=60000;
	if (timeOffset>0){
		timeOffset=Math.ceil(timeOffset);
	}else{
		timeOffset=Math.floor(timeOffset);
	}
	-->
	</script>
	<script language="C#" runat="server">
	public string GetState(int rid){
		string s = "";
		s="<script type=\"text/javascript\">";
		s+="p=new Object();";
		s+="p.id="+ rid +";";
		if (IWMS.Tools.GatherTool.GTs.ContainsKey(rid)){
			IWMS.Tools.GatherTool gt = IWMS.Tools.GatherTool.GTs[rid];
			s+="p.doing=true;";
			s+="p.needDown="+ gt.State.NeedDown +";";
			s+="p.doneNum="+ gt.State.DoneNum +";";
			s+="p.newsNum="+ gt.State.NewsNum +";";
			s+="p.imgNum="+ gt.State.ImgNum +";";
			if (gt.State.EndTime != DateTime.MinValue){
				s+="p.endTime=\""+ gt.State.EndTime.ToString("R") +"\";";
				s+="p.interval="+ gt.Config.Interval +";";
			}
			s+="p.processing="+ gt.State.Processing.ToString().ToLower() +";";
			s+="p.recentUrl=\""+ gt.State.RecentUrl +"\";";
			s+="p.error=\""+ gt.State.Error.Replace("\r\n","[br]") +"\";";
		}else{
			s+="p.doing=false;";
		}
		s+="pa.push(p);";
		s+="</"+"script>";
		return s;
	}
	</script>
</asp:Content>

<asp:Content ContentPlaceHolderId="cphMain" runat="server">
	<asp:Label id="myLabel" class="msgBar" EnableViewState="false" runat="server"/>

	<form id="myForm" runat="server">
	
	<asp:PlaceHolder id="phGather" runat="server">
		<asp:ValidationSummary 
			 DisplayMode="BulletList" 
			 EnableClientScript="true"
			 ShowSummary="false"
			 ShowMessageBox="true"                        
			 HeaderText="请正确填写以下内容"
			 runat="server"/>
	
	<div class="mframe">
	<div class="tl"></div>
	<div class="rt"></div>
	<div class="tm">
		<span class="tt">开始采集</span>
	</div>
	<div class="wrapper">
	<div class="ml"></div>
	<div class="mr"></div>
	<div class="mm">
		请从下边选择一个采集规则开始采集。你也可以在修改下列部分采集参数后采集。<a href="#" class="fLink"><span id="modiSpan" onclick="modiDisp()">显示采集参数</span></a><br/>
		<table width="100%" id="modiTable" style="display:none">
		<tr><td>
			采集地址 <asp:TextBox Columns="40" MaxLength="250" id="startUrl" runat="server"/>
		</td></tr>
		<tr><td>
			入库分类
			<asp:DropDownList id="sortID"
				runat="server"/>
			<script type="text/javascript">
			<!--
			function setOptionColor(){
				var obj=document.getElementById("<%=sortID.ClientID%>");
				var keepSelect=false;
				var dispChilds=0;	// 需显示下级数
				// 非可添加项变色
				for (var i=obj.options.length-1;i>=0;i-=1){
					var id = parseInt(obj.options[i].value);
					if (id==0){
						continue;
					}
					if (!sArr[id][2]){
						if (sArr[id][0]==0 || dispChilds==0){
							if (document.all){
								obj.options.remove(i);
							}else{
								obj.options[i]=null;
							}
						}else{
							obj.options[i].value="";
							obj.options[i].style.color="gray";
						}
					}else{
						// 深度大于0为子类
						if (sArr[id][3]>0) {
							dispChilds+=1;
						}
						if (obj.options[i].selected){
							keepSelect=true;
						}
					}
					if (sArr[id][3]==0) {
						dispChilds=0;
					}
				}
				// 选择第一个可添加项
				if (!keepSelect) {
					for (var i=0;i<obj.options.length;i++){
						if ( obj.options[i].value != "") {
							obj.selectedIndex = i;
							break;
						}
					}
				}
			}
			setOptionColor();
			-->
			</script>
			　
			新闻标题含
			<asp:TextBox Columns="20" MaxLength="20" id="titleInclude" runat="server" title="多个使用,分隔"/>
			　
			新闻标题不含
			<asp:TextBox Columns="20" MaxLength="20" id="titleExclude" runat="server" title="多个使用,分隔"/>
		</td>
		</tr>
		<tr><td colspan="3">
			采集新闻数 <asp:TextBox Columns="5" MaxLength="7" id="downNum" Style="text-align:right" runat="server"/>
			<asp:RegularExpressionValidator
				ControlToValidate="downNum"
				ValidationExpression="\d+"
				ErrorMessage="采集数只能是数字"
				Display="None"
				runat="server"/>
	
			&nbsp; &nbsp;
			不经过审核
			<asp:RadioButtonList id="passed" RepeatDirection="Horizontal"
				RepeatLayout="Flow"
				runat="server">
				<asp:ListItem>是</asp:ListItem>
				<asp:ListItem>否</asp:ListItem>
			</asp:RadioButtonList>
	
			&nbsp; &nbsp;
			下载站外图片
			<asp:RadioButtonList id="downImg" RepeatDirection="Horizontal"
				RepeatLayout="Flow"
				runat="server">
				<asp:ListItem>是</asp:ListItem>
				<asp:ListItem>否</asp:ListItem>
			</asp:RadioButtonList>
			
			&nbsp; &nbsp;
			网页编码：<asp:DropDownList id="charset" runat="server">
				<asp:ListItem value="">&nbsp;</asp:ListItem>
				<asp:ListItem value="gb2312">GB2312</asp:ListItem>
				<asp:ListItem value="big5">BIG5</asp:ListItem>
				<asp:ListItem value="utf-8">UTF-8</asp:ListItem>
			</asp:DropDownList>
			
		</td>
		</tr>
		<tr>
		<td colspan="3">
			<table><tr><td width="130">
			采集多篇新闻网址：<br/>
			(每行一个新闻网址)
			</td><td>
			<asp:TextBox id="newsUrl" TextMode="MultiLine" Columns="70" rows="3" runat="server"/>
			</td></tr>
			</table>
		</td>
		<td>
		</td>
		</tr>
		</table>
	</div>
	</div>
	<div class="bl"></div>
	<div class="br"></div>
	<div class="bm"></div>
	</div>
	
	<div class="mframe">
	<div class="tl"></div>
	<div class="rt"></div>
	<div class="tm">
		<span class="tt">采集规则</span>
	</div>
	<div class="wrapper">
	<div class="ml"></div>
	<div class="mr"></div>
	<div class="mm">
		<div style="height:380px;overflow:auto;">
		<ASP:DataGrid id="MyDataGrid" runat="server"
				Width="100%"
				align="center"
				PageSize="10"
				ShowHeader="true"
				ShowFooter="false"
				AllowPaging="true"
				AutoGenerateColumns="false"
				DataKeyField="id"
				OnDeleteCommand="MyDataGrid_Delete"
				OnItemCommand="MyDataGrid_ItemCommand"
				OnPageIndexChanged="MyDataGrid_Page"
				CssClass="grid"
				HeaderStyle-CssClass="gridHead"
				ItemStyle-CssClass="tdbg"
				CellPadding="6"
				CellSpacing="0" >
			
			<Columns>
				<asp:TemplateColumn>
					<ItemTemplate>
						<input type="radio" name="rid" value='<%#Eval("id")%>'/>
					</ItemTemplate>
					<HeaderStyle width="20"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:TemplateColumn>
				<asp:TemplateColumn
					HeaderText="采集名称"
					>
					<ItemTemplate>
						<a href="admin_gatherRuleAdd.aspx?id=<%#Eval("id")%>"><%#Eval("name")%></a>
					</ItemTemplate>
					<ItemStyle HorizontalAlign="left"/>
				</asp:TemplateColumn>
				<asp:TemplateColumn
					HeaderText="状态"
					>
					<ItemTemplate>
						<div id="st<%#Eval("id")%>"></div>
						<%#GetState((int)Eval("id"))%>
					</ItemTemplate>
					<HeaderStyle width="60"/>
					<ItemStyle Width="" HorizontalAlign="center" />
				</asp:TemplateColumn>
				<asp:HyperLinkColumn
					HeaderText="起始<br/>地址"
					DataNavigateUrlField="startUrl"
					Text="访问"
					DataNavigateUrlFormatString="{0}"
					Target="_blank"
					>
					<HeaderStyle width="45"/>
					<ItemStyle Wrap="true" HorizontalAlign="center" />
				</asp:HyperLinkColumn>
				<asp:BoundColumn
					HeaderText="采集数"
					DataField="downNum"
					>
					<HeaderStyle width="50"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:BoundColumn>
				<asp:BoundColumn
					HeaderText="分类"
					DataField="class"
					>
					<HeaderStyle width="80"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:BoundColumn>
				<asp:TemplateColumn
					HeaderText="下载<br/>图片"
					>
					<ItemTemplate>
						<%#(bool)Eval("downImg") ? "√" : "×"%>
					</ItemTemplate>
					<HeaderStyle width="40"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:TemplateColumn>
				<asp:TemplateColumn
					HeaderText="不审"
					>
					<ItemTemplate>
						<%#(bool)Eval("passed") ? "√" : "×"%>
					</ItemTemplate>
					<HeaderStyle width="35"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:TemplateColumn>
				<asp:TemplateColumn
					HeaderText="站外<br/>链接"
					>
					<ItemTemplate>
						<%#(bool)Eval("linkOut") ? "√" : "×"%>
					</ItemTemplate>
					<HeaderStyle width="40"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:TemplateColumn>
				<asp:ButtonColumn
					HeaderText="上"
					ButtonType="LinkButton"
					Text="&uarr;"
					CommandName="up"
					>
					<HeaderStyle width="25"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:ButtonColumn>
				<asp:ButtonColumn
					HeaderText="下"
					ButtonType="LinkButton"
					Text="&darr;"
					CommandName="down"
					>
					<HeaderStyle width="25"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:ButtonColumn>
				<asp:ButtonColumn
					ButtonType="LinkButton"
					CommandName="Delete"
					Text="删除" >
					<HeaderStyle width="40"/>
					<ItemStyle HorizontalAlign="center" />
				</asp:Buttoncolumn>
			</Columns>
		</ASP:DataGrid>
		</div>
		
		<br/>
		<table>
		<tr><td style="line-height:3em">
			间隔
			<asp:DropDownList id="interval" runat="server">
				<asp:ListItem value="0"></asp:ListItem>
				<asp:ListItem value="15">15分钟</asp:ListItem>
				<asp:ListItem value="30">30分钟</asp:ListItem>
				<asp:ListItem value="60">1小时</asp:ListItem>
				<asp:ListItem value="120">2小时</asp:ListItem>
				<asp:ListItem value="240">4小时</asp:ListItem>
				<asp:ListItem value="480">8小时</asp:ListItem>
				<asp:ListItem value="720">12小时</asp:ListItem>
			</asp:DropDownList>
			循环采集，
			<asp:DropDownList id="staticScope" runat="server">
				<asp:ListItem value="0">仅生成新闻静态页面</asp:ListItem>
				<asp:ListItem value="1">同时生成首页静态页面</asp:ListItem>
				<asp:ListItem value="2">同时生成首页/分类/专题静态页面</asp:ListItem>
			</asp:DropDownList>&nbsp;
			<asp:Button id="Submit" Onclick="Submit_OnClick" Text="开始采集" runat="server"/>
			&nbsp; <asp:Button id="stop" Onclick="stop_OnClick" Text="停止采集" runat="server"/>
			<br/>
			<font color="red">注意：开多个采集任务时请差开时间，否则会在一定时间内cpu资源占用过高</font>
		</td></tr>
		</table>
		
	</div>
	</div>
	<div class="bl"></div>
	<div class="br"></div>
	<div class="bm"></div>
	</div>
	
	
	</asp:PlaceHolder>
	</form>
	<script type="text/javascript">dispState();window.setTimeout("intervalWork()",3000);
	</script>
</asp:Content>