<%@Page Language="C#" Inherits="IWMS.Admin.MemberAdd" MasterPageFile="admin.master"%>
<asp:Content ContentPlaceHolderId="cphMain" runat="server">

	<form id="myForm" runat="server">
		<asp:ValidationSummary 
			 DisplayMode="BulletList" 
			 EnableClientScript="true"
			 ShowSummary="false"
			 ShowMessageBox="true"                        
			 HeaderText="请正确填写以下内容"
			 runat="server"/>
	
	<div class="mframe">
	<div class="tl"></div>
	<div class="rt"></div>
	<div class="tm">
		<span class="tt"><asp:Literal id="literalTitle" Text="添加" runat="server"/>会员</span>
	</div>
	<div class="wrapper">
	<div class="ml"></div>
	<div class="mr"></div>
	<div class="mm">
		<asp:Label id="myLabel" class="msgBar" EnableViewState="false" runat="server"/>
		<asp:PlaceHolder id="phForm" runat="server">
		<table width="95%" align="center">
		<tr><th width="250">
			用户名：
		</th><td>
			<asp:TextBox id="name" MaxLength="50" size="20" runat="server"/>
			<asp:RequiredFieldValidator
				ControlToValidate="name"
				ErrorMessage="用户名必须填写"
				Display="None"
				runat="server"
				/>
		</td></tr>
		<tr><th>
			密　码：
		</th><td>
			<asp:TextBox TextMode="Password" id="password" MaxLength="50" size="20" runat="server"/>
			<asp:RequiredFieldValidator id="rfvPassword"
				ControlToValidate="password"
				ErrorMessage="密码必须填写"
				Display="None"
				runat="server"
				/>
		</td></tr>
		<tr><th>
			e-mail：
		</th><td>
			<asp:TextBox id="email" MaxLength="80" size="20" runat="server"/>
			<asp:RequiredFieldValidator
				ControlToValidate="email"
				ErrorMessage="email必须填写"
				Display="None"
				runat="server"
				/>
			<asp:RegularExpressionValidator
				ControlToValidate="email"
				ValidationExpression="\w[0-9a-zA-Z_\-\.]*@(\w[0-9a-zA-Z\-]*\.)+\w{2,}"
				ErrorMessage="email格式不正确"
				Display="None"
				runat="server"
				/>
			&nbsp;
			<asp:CheckBox id="hideEmail" Text="保密" runat="server"/>
		</td></tr>
		<tr><th>
			找回密码问题：
		</th><td>
			<asp:TextBox id="question" MaxLength="100" size="50" runat="server"/>
		</td></tr>
		<tr><th>
			找回密码答案：
		</th><td>
			<asp:TextBox id="answer" MaxLength="100" size="50" runat="server"/>
		</td></tr>
		<tr><th>
			QQ：
		</th><td>
			<asp:TextBox id="qq" MaxLength="20" size="20" runat="server"/>
			<asp:RegularExpressionValidator
				ControlToValidate="qq"
				ValidationExpression="\d+"
				Display="None"
				ErrorMessage="qq号格式不正确"
				runat="server"/>
		</td></tr>
		<tr><th>
			Icq：
		</th><td>
			<asp:TextBox id="icq" MaxLength="20" size="20" runat="server"/>
			<asp:RegularExpressionValidator
				ControlToValidate="icq"
				ValidationExpression="\d+"
				ErrorMessage="icq号格式不正确"
				Display="None"
				runat="server"/>
		</td></tr>
		<tr><th>
			MSN：
		</th><td>
			<asp:TextBox id="msn" MaxLength="100" size="20" runat="server"/>
			<asp:RegularExpressionValidator
				ControlToValidate="msn"
				ValidationExpression="(\w[0-9a-zA-Z_-]*@(\w[0-9a-zA-Z-]*\.)+\w{2,})"
				ErrorMessage="msn格式不正确"
				Display="None"
				runat="server"
				/>
		</td></tr>
		<tr><th>
			<%=lang["vMoney"]%>：
		</th><td>
			<asp:TextBox id="vMoney" MaxLength="10" size="6" Style="text-align:right" runat="server"/>
			<asp:RequiredFieldValidator
				ControlToValidate="vMoney"
				ErrorMessage="v币数必须填写"
				Display="None"
				runat="server"
				/>
			<asp:RegularExpressionValidator
				ControlToValidate="vMoney"
				ValidationExpression="\d+"
				ErrorMessage="v币必须为数字"
				Display="None"
				runat="server"
				/>
		</td></tr>
		<tr><th>
			<%=lang["totalMark"]%>：
		</th><td>
			<asp:TextBox id="totalMark" MaxLength="10" size="6" Style="text-align:right" runat="server"/>
			<asp:RequiredFieldValidator
				ControlToValidate="totalMark"
				ErrorMessage="积分数必须填写"
				Display="None"
				runat="server"
				/>
			<asp:RegularExpressionValidator
				ControlToValidate="totalMark"
				ValidationExpression="\d+"
				ErrorMessage="积分必须为数字"
				Display="None"
				runat="server"
				/>
		</td></tr>
		<tr><th>
			会员到期：
		</th><td>
			<asp:TextBox id="expireDate" MaxLength="20" size="20" runat="server"/>
			<asp:RegularExpressionValidator
				ControlToValidate="expireDate"
				ValidationExpression="\d{4}-\d{2}-\d{2} \d{2}:\d{2}"
				ErrorMessage="会员到期时间格式错误"
				Display="None"
				runat="server"
				/>
				<a href="javascript:SetExpire(1);">一月</a>
				<a href="javascript:SetExpire(6)">半年</a>
				<a href="javascript:SetExpire(12)">一年</a>
				<script type="text/javascript">
				function SetExpire(months)
				{
					d=new Date();
					d.setMonth(d.getMonth()+months);
					var o = document.getElementById("<%=expireDate.ClientID%>");
					o.value = ""+ (d.getYear().toString().length==4 ? d.getYear() : (d.getYear()<74 ? 2000+d.getYear() : 1900+d.getYear()) ) +"-"+ GetNum(d.getMonth()+1) +"-"+ GetNum(d.getDate()) +" "+ GetNum(d.getHours()) +":"+ GetNum(d.getMinutes());
					function GetNum(n)
					{
						// 一位转两位
						if (n<10){
							return "0"+n;
						}else{
							return n.toString();
						}
					}
				}
				</script>
		</td></tr>
		<tr><td colspan="2" class="gridHead">
			个人资料
		</td></tr>
		<tr><th>
			姓名：
		</th><td>
			<asp:TextBox id="realname" size="20" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			性别：
		</th><td>
			<asp:RadioButtonList id="male"
				RepeatDirection="Horizontal"
				runat="server">
				<asp:ListItem value="1" Text="男" Selected="True"/>
				<asp:ListItem value="0" Text="女"/>
			</asp:RadioButtonList>
		</td></tr>
		<tr><th>
			生日：
		</th><td>
			<asp:TextBox id="birthYear" size="4" MaxLength="4" runat="server"/>
			年
			<asp:RegularExpressionValidator
				ControlToValidate="birthYear"
				ValidationExpression="\d+"
				ErrorMessage="年格式不正确"
				Display="None"
				runat="server"
				/>
			<asp:DropDownList id="birthMonth" runat="server">
				<asp:ListItem value="" Text="" />
				<asp:ListItem value="1" Text="1" />
				<asp:ListItem value="2" Text="2" />
				<asp:ListItem value="3" Text="3" />
				<asp:ListItem value="4" Text="4" />
				<asp:ListItem value="5" Text="5" />
				<asp:ListItem value="6" Text="6" />
				<asp:ListItem value="7" Text="7" />
				<asp:ListItem value="8" Text="8" />
				<asp:ListItem value="9" Text="9" />
				<asp:ListItem value="10" Text="10" />
				<asp:ListItem value="11" Text="11" />
				<asp:ListItem value="12" Text="12" />
			</asp:DropDownList>
			月
			<asp:DropDownList id="birthDay" runat="server">
				<asp:ListItem value="" Text="" />
				<asp:ListItem value="1" Text="1" />
				<asp:ListItem value="2" Text="2" />
				<asp:ListItem value="3" Text="3" />
				<asp:ListItem value="4" Text="4" />
				<asp:ListItem value="5" Text="5" />
				<asp:ListItem value="6" Text="6" />
				<asp:ListItem value="7" Text="7" />
				<asp:ListItem value="8" Text="8" />
				<asp:ListItem value="9" Text="9" />
				<asp:ListItem value="10" Text="10" />
				<asp:ListItem value="11" Text="11" />
				<asp:ListItem value="12" Text="12" />
				<asp:ListItem value="13" Text="13" />
				<asp:ListItem value="14" Text="14" />
				<asp:ListItem value="15" Text="15" />
				<asp:ListItem value="16" Text="16" />
				<asp:ListItem value="17" Text="17" />
				<asp:ListItem value="18" Text="18" />
				<asp:ListItem value="19" Text="19" />
				<asp:ListItem value="20" Text="20" />
				<asp:ListItem value="21" Text="21" />
				<asp:ListItem value="22" Text="22" />
				<asp:ListItem value="23" Text="23" />
				<asp:ListItem value="24" Text="24" />
				<asp:ListItem value="25" Text="25" />
				<asp:ListItem value="26" Text="26" />
				<asp:ListItem value="27" Text="27" />
				<asp:ListItem value="28" Text="28" />
				<asp:ListItem value="29" Text="29" />
				<asp:ListItem value="30" Text="30" />
				<asp:ListItem value="31" Text="31" />
			</asp:DropDownList>
			日
		</td></tr>
		<tr><th>
			相片：
		</th><td>
			<asp:TextBox id="photo" size="20" MaxLength="255" runat="server"/>&nbsp; &nbsp;
			<asp:Image ImageUrl="" ImageAlign="AbsMiddle" Visible="false" ID="mImage" Style="position:absolute" runat="server"/>
		</td></tr>
		<tr><th>
			血型：
		</th><td>
			<asp:DropDownList id="bloodtype" runat="server">
				<asp:ListItem value="" Text="" />
				<asp:ListItem value="A" Text="A"/>
				<asp:ListItem value="B" Text="B"/>
				<asp:ListItem value="O" Text="O"/>
				<asp:ListItem value="AB" Text="AB"/>
			</asp:DropDownList>
		</td></tr>
		<tr><th>
			国家：
		</th><td>
			<asp:TextBox id="country" size="20" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			省/自治区：
		</th><td>
			<asp:TextBox id="province" size="20" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			市：
		</th><td>
			<asp:TextBox id="city" size="20" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			电话：
		</th><td>
			<asp:TextBox id="phone" size="20" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			邮编：
		</th><td>
			<asp:TextBox id="postcode" size=10 MaxLength=10 runat="server"/>
		</td></tr>
		<tr><th>
			联系地址：
		</th><td>
			<asp:TextBox id="address" size="50" MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			职业：
		</th><td>
			<asp:DropDownList id="job" runat="server">
			<asp:ListItem value=""></asp:ListItem>
			<asp:ListItem value="财会/金融">财会/金融</asp:ListItem>
			<asp:ListItem value="工程师">工程师</asp:ListItem>
			<asp:ListItem value="顾问">顾问</asp:ListItem>
			<asp:ListItem value="计算机相关行业">计算机相关行业</asp:ListItem>
			<asp:ListItem value="家庭主妇">家庭主妇</asp:ListItem>
			<asp:ListItem value="教育/培训">教育/培训</asp:ListItem>
			<asp:ListItem value="客户服务/支持">客户服务/支持</asp:ListItem>
			<asp:ListItem value="零售商/手工工人">零售商/手工工人</asp:ListItem>
			<asp:ListItem value="退休">退休</asp:ListItem>
			<asp:ListItem value="无职业">无职业</asp:ListItem>
			<asp:ListItem value="销售/市场/广告">销售/市场/广告</asp:ListItem>
			<asp:ListItem value="学生">学生</asp:ListItem>
			<asp:ListItem value="研究和开发">研究和开发</asp:ListItem>
			<asp:ListItem value="一般管理/监督,政府/军队">一般管理/监督,政府/军队</asp:ListItem>
			<asp:ListItem value="执行官/高级管理">执行官/高级管理</asp:ListItem>
			<asp:ListItem value="制造/生产/操作">制造/生产/操作</asp:ListItem>
			<asp:ListItem value="专业人员">专业人员</asp:ListItem>
			<asp:ListItem value="自雇/业主,其他">自雇/业主,其他</asp:ListItem>
			</asp:DropDownList>
		</td></tr>
		<tr><th>
			学历：
		</th><td>
			<asp:DropDownList id="edu" runat="server">
			<asp:ListItem value=""></asp:ListItem>
			<asp:ListItem value="小学">小学</asp:ListItem>
			<asp:ListItem value="初中">初中</asp:ListItem>
			<asp:ListItem value="高中">高中</asp:ListItem>
			<asp:ListItem value="大学">大学</asp:ListItem>
			<asp:ListItem value="硕士">硕士</asp:ListItem>
			<asp:ListItem value="博士">博士</asp:ListItem>
			</asp:DropDownList>
		</td></tr>
		<tr><th>
			毕业学校：
		</th><td>
			<asp:TextBox id="school" size=40 MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			RSS标题：
		</th><td>
			<asp:TextBox id="rssTitle" size="20" MaxLength="255" runat="server"/>
		</td></tr>
		<tr><th>
			自我简介：
		</th><td>
			<asp:TextBox id="introduction"
				TextMode="MultiLine"
				Columns="40" 
				Rows=4
				runat="server"/>(<255)
		</td></tr>
		<tr><th>
			备注：
		</th><td>
			<asp:TextBox id="remarks" size=40 MaxLength="100" runat="server"/>
		</td></tr>
		<tr><th>
			会员组：
		</th><td>
			<asp:CheckBoxList id="groupid"
				RepeatDirection="Horizontal"
				RepeatColumns=5
				runat="server"/>
		</td></tr>
		<tr><td colspan="2" height="30" align="center">
			<asp:Button id="btPost" Text="添加" Onclick="btPost_Onclick" runat="server"/>
		</td></tr>
		</table>
		</asp:PlaceHolder>
		
	</div>
	</div>
	<div class="bl"></div>
	<div class="br"></div>
	<div class="bm"></div>
	</div>
	
	</form>

</asp:Content>