/***********************************************
 Fool-Proof Date Input Script with DHTML Calendar
 by Jason Moon - webmaster@moonfam.net
 modified by 木鸟 - www.iwms.net
 ************************************************/

// Customizable variables
var DefaultDateFormat = 'MM/DD/YYYY'; // If no date format is supplied, this will be used instead
var HideWait = 3; // Number of seconds before the calendar will disappear
var Y2kPivotPoint = 76; // 2-digit years before this point will be created in the 21st century
var FontSize = 11; // In pixels
var FontFamily = 'Tahoma';
var CellWidth = 18;
var CellHeight = 16;
var ImageURL = 'pic/calendar.jpg';
var NextURL = 'pic/calendar_next.gif';
var PrevURL = 'pic/calendar_prev.gif';
var NextYearURL = 'pic/calendar_nextYear.gif';
var PrevYearURL = 'pic/calendar_prevYear.gif';
var CalBGColor = 'white';
var TopRowBGColor = 'buttonface';
var DayBGColor = 'lightgrey';

// Global variables
var ZCounter = 100;
var Today = new Date();
//var WeekDays = new Array('S','M','T','W','T','F','S');
var WeekDays = new Array('日','一','二','三','四','五','六');
var MonthDays = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
//var MonthNames = new Array('January','February','March','April','May','June','July','August','September','October','November','December');
var MonthNames = new Array('1月','2月','3月','4月','5月','6月','7月','8月','9月','10月','11月','12月');

if(document.charset=="big5"){
var WeekDays = new Array('ら','','','','','き','せ');
var MonthNames = new Array('1る','2る','3る','4る','5る','6る','7る','8る','9る','10る','11る','12る');
}

// Write out the stylesheet definition for the calendar
with (document) {
   writeln('<style>');
   writeln('td.calendarDateInput {letter-spacing:normal;line-height:normal;font-family:' + FontFamily + ',Sans-Serif;font-size:' + FontSize + 'px;}');
   writeln('select.calendarDateInput {letter-spacing:.06em;font-family:Verdana,Sans-Serif;font-size:11px;}');
   writeln('input.calendarDateInput {letter-spacing:.06em;font-family:Verdana,Sans-Serif;font-size:11px;}');
   writeln('</style>');
}

// Only allows certain keys to be used in the date field
function NumOnly(e) {
   var KeyCode = (e.keyCode) ? e.keyCode : e.which;
   return ((KeyCode == 8) // backspace
        || (KeyCode == 9) // tab
        || (KeyCode == 37) // left arrow
        || (KeyCode == 39) // right arrow
        || (KeyCode == 46) // delete
        || ((KeyCode > 47) && (KeyCode < 58)) // 0 - 9
   );
}

// Gets the absolute pixel position of the supplied element
function GetTagPixels(StartTag, Direction) {
   var PixelAmt = (Direction == 'LEFT') ? StartTag.offsetLeft : StartTag.offsetTop;
   while ((StartTag.tagName != 'BODY') && (StartTag.tagName != 'HTML')) {
      StartTag = StartTag.offsetParent;
      PixelAmt += (Direction == 'LEFT') ? StartTag.offsetLeft : StartTag.offsetTop;
   }
   return PixelAmt;
}

// Is the specified select-list behind the calendar?
function BehindCal(SelectList, CalLeftX, CalRightX, CalTopY, CalBottomY, ListTopY) {
   var ListLeftX = GetTagPixels(SelectList, 'LEFT');
   var ListRightX = ListLeftX + SelectList.offsetWidth;
   var ListBottomY = ListTopY + SelectList.offsetHeight;
   return (((ListTopY < CalBottomY) && (ListBottomY > CalTopY)) && ((ListLeftX < CalRightX) && (ListRightX > CalLeftX)));
}

// For IE, hides any select-lists that are behind the calendar
function FixSelectLists(Over) {
   if (navigator.appName == 'Microsoft Internet Explorer') {
      var CalDiv = this.getCalendar();
      var CalLeftX = CalDiv.offsetLeft;
      var CalRightX = CalLeftX + CalDiv.offsetWidth;
      var CalTopY = CalDiv.offsetTop;
      var CalBottomY = CalTopY + (CellHeight * 9);
      var FoundCalInput = false;
      formLoop :
      for (var j=this.formNumber;j<document.forms.length;j++) {
         for (var i=0;i<document.forms[j].elements.length;i++) {
            if (typeof document.forms[j].elements[i].type == 'string') {
               if ((document.forms[j].elements[i].type == 'hidden') && (document.forms[j].elements[i].name == this.hiddenFieldName)) {
                  FoundCalInput = true;
                  i += 3; // 3 elements between the 1st hidden field and the last year input field
               }
               if (FoundCalInput) {
                  if (document.forms[j].elements[i].type.substr(0,6) == 'select') {
                     ListTopY = GetTagPixels(document.forms[j].elements[i], 'TOP');
                     if (ListTopY < CalBottomY) {
                        if (BehindCal(document.forms[j].elements[i], CalLeftX, CalRightX, CalTopY, CalBottomY, ListTopY)) {
                           document.forms[j].elements[i].style.visibility = (Over) ? 'hidden' : 'visible';
                        }
                     }
                     else break formLoop;
                  }
               }
            }
         }
      }
   }
}

// Displays a message in the status bar when hovering over the calendar days
function DayCellHover(Cell, Over, Color, HoveredDay) {
   Cell.style.backgroundColor = (Over) ? DayBGColor : Color;
   if (Over) {
      if ((this.yearValue == Today.getFullYear()) && (this.monthIndex == Today.getMonth()) && (HoveredDay == Today.getDate())){ self.status = 'Click to select today';
     }else {
         var Suffix = HoveredDay.toString();
         switch (Suffix.substr(Suffix.length - 1, 1)) {
            case '1' : Suffix += (HoveredDay == 11) ? 'th' : 'st'; break;
            case '2' : Suffix += (HoveredDay == 12) ? 'th' : 'nd'; break;
            case '3' : Suffix += (HoveredDay == 13) ? 'th' : 'rd'; break;
            default : Suffix += 'th'; break;
         }
         self.status = 'Click to select ' + this.monthName + ' ' + Suffix;
      }
   }
   else self.status = '';
   return true;
}

// Sets the form elements after a day has been picked from the calendar
function PickDisplayDay(ClickedDay) {
   this.show();
   this.setPicked(this.displayed.yearValue, this.displayed.monthIndex, ClickedDay);
}


// Builds the HTML for the calendar days
function BuildCalendarDays() {
   var Rows = 5;
   if (((this.displayed.dayCount == 31) && (this.displayed.firstDay > 4)) || ((this.displayed.dayCount == 30) && (this.displayed.firstDay == 6))) Rows = 6;
   else if ((this.displayed.dayCount == 28) && (this.displayed.firstDay == 0)) Rows = 4;
   var HTML = '<table width="' + (CellWidth * 7) + '" cellspacing="0" cellpadding="1" style="cursor:default">';
   for (var j=0;j<Rows;j++) {
      HTML += '<tr>';
      for (var i=1;i<=7;i++) {
         Day = (j * 7) + (i - this.displayed.firstDay);
         if ((Day >= 1) && (Day <= this.displayed.dayCount)) {
            if ((this.displayed.yearValue == this.picked.yearValue) && (this.displayed.monthIndex == this.picked.monthIndex) && (Day == this.picked.day)) {
               TextStyle = 'color:white;font-weight:bold;';
               BackColor = DayBGColor;
            }
            else {
               TextStyle = 'color:black;';
               BackColor = CalBGColor;
            }
            if ((this.displayed.yearValue == Today.getFullYear()) && (this.displayed.monthIndex == Today.getMonth()) && (Day == Today.getDate())){
            	 TextStyle += 'border:1px solid darkred;padding:0px;';
            }
            HTML += '<td align="center" class="calendarDateInput" style="cursor:default;height:' + CellHeight + ';width:' + CellWidth + ';' + TextStyle + ';background-color:' + BackColor + '" onClick="' + this.objName + '.pickDay(' + Day + ')" onMouseOver="return ' + this.objName + '.displayed.dayHover(this,true,\'' + BackColor + '\',' + Day + ')" onMouseOut="return ' + this.objName + '.displayed.dayHover(this,false,\'' + BackColor + '\')">' + Day + '</td>';
         }else{
         	 HTML += '<td class="calendarDateInput" style="height:' + CellHeight + '">&nbsp;</td>';
        }
      }
      HTML += '</tr>';
   }
   return HTML += '</table>';
}

// Determines which century to use (20th or 21st) when dealing with 2-digit years
function GetGoodYear(YearDigits) {
   if (YearDigits.length == 4){
   	return YearDigits;
   }else {
      var Millennium = (YearDigits < Y2kPivotPoint) ? 2000 : 1900;
      return Millennium + parseInt(YearDigits,10);
   }
}

// Returns the number of days in a month (handles leap-years)
function GetDayCount(SomeYear, SomeMonth) {
   return ((SomeMonth == 1) && ((SomeYear % 400 == 0) || ((SomeYear % 4 == 0) && (SomeYear % 100 != 0)))) ? 29 : MonthDays[SomeMonth];
}

// Highlights the buttons
function VirtualButton(Cell, ButtonDown) {
   if (ButtonDown) {
      Cell.style.borderLeft = 'buttonshadow 1px solid';
      Cell.style.borderTop = 'buttonshadow 1px solid';
      Cell.style.borderBottom = 'buttonhighlight 1px solid';
      Cell.style.borderRight = 'buttonhighlight 1px solid';
   }else {
      Cell.style.borderLeft = 'buttonhighlight 1px solid';
      Cell.style.borderTop = 'buttonhighlight 1px solid';
      Cell.style.borderBottom = 'buttonshadow 1px solid';
      Cell.style.borderRight = 'buttonshadow 1px solid';
   }
}

// Mouse-over for the previous/next month buttons
function NeighborHover(Cell, Over, DateObj) {
   if (Over) {
      VirtualButton(Cell, false);
      self.status = 'Click to view ' + DateObj.fullName;
   }else {
      Cell.style.border = 'buttonface 1px solid';
      self.status = '';
   }
   return true;
}

// Adds/removes days from the day list, depending on the month/year
function FixDayList(DayList, NewDays) {
   var DayPick = DayList.selectedIndex + 1;
   if (NewDays != DayList.length) {
      var OldSize = DayList.length;
      for (var k=Math.min(NewDays,OldSize);k<Math.max(NewDays,OldSize);k++) {
         (k >= NewDays) ? DayList.options[NewDays] = null : DayList.options[k] = new Option(k+1, k+1);
      }
      DayPick = Math.min(DayPick, NewDays);
      DayList.options[DayPick-1].selected = true;
   }
   return DayPick;
}

// Resets the year to its previous valid value when something invalid is entered
function FixYearInput(YearField) {
   var YearRE = new RegExp('\\d{' + YearField.defaultValue.length + '}');
   if (!YearRE.test(YearField.value)){
   	YearField.value = YearField.defaultValue;
   }
}

// Displays a message in the status bar when hovering over the calendar icon
function CalIconHover(Over) {
   var Message = (this.isShowing()) ? 'hide' : 'show';
   self.status = (Over) ? 'Click to ' + Message + ' the calendar' : '';
   return true;
}

// Starts the timer over from scratch
function CalTimerReset() {
   eval('clearTimeout(' + this.timerID + ')');
   eval(this.timerID + '=setTimeout(\'' + this.objName + '.show()\',' + (HideWait * 1000) + ')');
}

// The timer for the calendar
function DoTimer(CancelTimer) {
   if (CancelTimer){
   	eval('clearTimeout(' + this.timerID + ')');
   }else {
      eval(this.timerID + '=null');
      this.resetTimer();
   }
}

// Show or hide the calendar
function ShowCalendar() {
   if (this.isShowing()) {
      var StopTimer = true;
      this.getCalendar().style.zIndex = --ZCounter;
      this.getCalendar().style.visibility = 'hidden';
      this.fixSelects(false);
   }else {
      var StopTimer = false;
      this.fixSelects(true);
      this.getCalendar().style.zIndex = ++ZCounter;
      this.getCalendar().style.visibility = 'visible';
   }
   this.handleTimer(StopTimer);
   self.status = '';
}


// Holds characteristics about a date
function dateObject() {
   this.date = (arguments.length == 1) ? new Date(arguments[0]) : new Date(arguments[0], arguments[1], arguments[2]);
   this.yearValue = this.date.getFullYear();
   this.monthIndex = this.date.getMonth();
   this.monthName = MonthNames[this.monthIndex];
   this.fullName = this.yearValue + ' ' + this.monthName;
   this.day = this.date.getDate();
   this.dayCount = GetDayCount(this.yearValue, this.monthIndex);
   var FirstDate = new Date(this.yearValue, this.monthIndex, 1);
   this.firstDay = FirstDate.getDay();

}

// Keeps track of the date that goes into the hidden field
function storedMonthObject(DateFormat, DateYear, DateMonth, DateDay) {
   dateObject.call(this, DateYear, DateMonth, DateDay);
   this.yearPad = this.yearValue.toString();
   this.monthPad = (this.monthIndex < 9) ? '0' + String(this.monthIndex + 1) : this.monthIndex + 1;
   this.dayPad = (this.day < 10) ? '0' + this.day.toString() : this.day;
   this.monthShort = this.monthName.substr(0,3).toUpperCase();
   // Formats the year value
   if (DateFormat != 'YYYYMMDD') {
      DateFormat.match(/(Y{2,4})$/);
      if (RegExp.$1.length == 2) this.yearPad = this.yearPad.substr(2);
   }
   // Formats the date
   if (/YYYYMMDD/.test(DateFormat)){
   	this.formatted = this.yearPad + this.monthPad + this.dayPad;
   }else if (/YYYY-MM-DD/.test(DateFormat)){
   	this.formatted = this.yearPad +"-"+ this.monthPad +"-"+ this.dayPad;
   }else{
      if (/MM?\/DD?\/Y{2,4}/.test(DateFormat)){
      	var FirstPart = this.monthPad + '/' + this.dayPad + '/';
      }else if (/DD?\/MM?\/Y{2,4}/.test(DateFormat)){
      	var FirstPart = this.dayPad + '/' + this.monthPad + '/';
      }else if (/DD?-((MON)|(MMM))-Y{2,4}/.test(DateFormat)){
      	var FirstPart = this.dayPad + '-' + this.monthShort + '-';
      }else if (/((MON)|(MMM))-DD?-Y{2,4}/.test(DateFormat)){
      	var FirstPart = this.monthShort + '-' + this.dayPad + '-';
      }
      this.formatted = FirstPart + this.yearPad;
   }
}

// Object for the current displayed month
function displayMonthObject(ParentObject, DateYear, DateMonth, DateDay) {
   dateObject.call(this, DateYear, DateMonth, DateDay);
   this.displayID = ParentObject.hiddenFieldName + '_Current_ID';
   this.getDisplay = new Function('return document.getElementById(this.displayID)');
   this.dayHover = DayCellHover;
   this.goCurrent = new Function(ParentObject.objName + '.getCalendar().style.zIndex=++ZCounter;' + ParentObject.objName + '.setDisplayed(Today.getFullYear(),Today.getMonth());');
   if (ParentObject.formNumber >= 0){
   	this.getDisplay().innerHTML = this.fullName;
   }
}

// Object for the previous/next buttons
function neighborMonthObject(ParentObject, IDText, DateMS) {
   dateObject.call(this, DateMS);
   this.buttonID = ParentObject.hiddenFieldName + '_' + IDText + '_ID';
   this.hover = new Function('C','O','NeighborHover(C,O,this)');
   this.getButton = new Function('return document.getElementById(this.buttonID)');
   this.go = new Function(ParentObject.objName + '.getCalendar().style.zIndex=++ZCounter;' + ParentObject.objName + '.setDisplayed(this.yearValue,this.monthIndex);');
   if (ParentObject.formNumber >= 0){
   	this.getButton().title = this.monthName;
   }
}

// Object for the previous/next year buttons
function neighborYearObject(ParentObject, IDText, DateYear, DateMonth) {
   dateObject.call(this, DateYear, DateMonth, 1);
   this.buttonID = ParentObject.hiddenFieldName + '_' + IDText + '_ID';
   this.hover = new Function('C','O','NeighborHover(C,O,this)');
   this.getButton = new Function('return document.getElementById(this.buttonID)');
   this.go = new Function(ParentObject.objName + '.getCalendar().style.zIndex=++ZCounter;' + ParentObject.objName + '.setDisplayed(this.yearValue,this.monthIndex);');
   if (ParentObject.formNumber >= 0){
   	this.getButton().title = this.yearValue;
   }
}

// Sets the currently-displayed month object
function SetDisplayedMonth(DispYear, DispMonth) {
   this.displayed = new displayMonthObject(this, DispYear, DispMonth, 1);
   // Creates the previous and next month objects
   this.previous = new neighborMonthObject(this, 'Previous', this.displayed.date.getTime() - 86400000);
   this.next = new neighborMonthObject(this, 'Next', this.displayed.date.getTime() + (86400000 * (this.displayed.dayCount + 1)));
   this.previousYear = new neighborYearObject(this, 'PreviousYear', parseInt(DispYear,10)-1, DispMonth);
   this.nextYear = new neighborYearObject(this, 'NextYear', parseInt(DispYear,10)+1, DispMonth);
   // Creates the HTML for the calendar
   if (this.formNumber >= 0){
   	this.getDayTable().innerHTML = this.buildCalendar();
   }
}

// Sets the current selected date
function SetPickedMonth(PickedYear, PickedMonth, PickedDay) {
   this.picked = new storedMonthObject(this.format, PickedYear, PickedMonth, PickedDay);
   this.setHidden(this.picked.formatted);
   this.setDisplayed(PickedYear, PickedMonth);
}

// The calendar object
function calendarObject(DateName, DateFormat, DefaultDate) {

   /* Properties */
   this.hiddenFieldName = DateName;
   this.monthDisplayID = DateName + '_Current_ID';
   this.calendarID = DateName + '_ID';
   this.dayTableID = DateName + '_DayTable_ID';
   this.calendarLinkID = this.calendarID + '_Link';
   this.timerID = this.calendarID + '_Timer';
   this.objName = DateName + '_Object';
   this.format = DateFormat;
   this.formNumber = -1;
   this.picked = null;
   this.displayed = null;
   this.previous = null;
   this.next = null;

   /* Methods */
   this.setPicked = SetPickedMonth;
   this.setDisplayed = SetDisplayedMonth;
   this.fixYear = FixYearInput;
   this.resetTimer = CalTimerReset;
   this.show = ShowCalendar;
   this.handleTimer = DoTimer;
   this.iconHover = CalIconHover;
   this.buildCalendar = BuildCalendarDays;
   this.pickDay = PickDisplayDay;
   this.fixSelects = FixSelectLists;
   this.setHidden = new Function('D','if (this.formNumber >= 0) this.getHiddenField().value=D');
   // Returns a reference to these elements
   this.getHiddenField = new Function('return document.forms[this.formNumber].elements[this.hiddenFieldName]');
   this.getCalendar = new Function('return document.getElementById(this.calendarID)');
   this.getDayTable = new Function('return document.getElementById(this.dayTableID)');
   this.getCalendarLink = new Function('return document.getElementById(this.calendarLinkID)');
   this.getMonthDisplay = new Function('return document.getElementById(this.monthDisplayID)');
   this.isShowing = new Function('return !(this.getCalendar().style.visibility != \'visible\')');

   /* Constructor */
   // Functions used only by the constructor
   function getMonthIndex(MonthAbbr) { // Returns the index (0-11) of the supplied month abbreviation
      for (var MonPos=0;MonPos<MonthNames.length;MonPos++) {
         if (MonthNames[MonPos].substr(0,3).toUpperCase() == MonthAbbr.toUpperCase()){
         	break;
         }
      }
      return MonPos;
   }
   function SetGoodDate(CalObj, Notify) { // Notifies the user about their bad default date, and sets the current system date
      CalObj.setPicked(Today.getFullYear(), Today.getMonth(), Today.getDate());
      if (Notify){
      	alert('WARNING: The supplied date is not in valid \'' + DateFormat + '\' format: ' + DefaultDate + '.\nTherefore, the current system date will be used instead: ' + CalObj.picked.formatted);
      }
   }
   // Main part of the constructor
   if (DefaultDate == 'undefined'){
   	SetGoodDate(this, false);
   }else{
      if (this.format == 'YYYYMMDD') {
         (/^\d{8}$/.test(DefaultDate)) ? this.setPicked(DefaultDate.substr(0,4), parseInt(DefaultDate.substr(4,2),10)-1, DefaultDate.substr(6,2)) : SetGoodDate(this, true);
      }else if (this.format=="YYYY-MM-DD"){
			if (/^\d{4}-\d{1,2}-\d{1,2}$/.test(DefaultDate)) {
				var arr = DefaultDate.split('-');
				this.setPicked(arr[0], parseInt(arr[1],10)-1, arr[2]);
			}else{
				SetGoodDate(this, true);
			}
      }else {
         if (/\//.test(this.format)) {
            if (/^(\d{1,2})\/(\d{1,2})\/(\d{2,4})$/.test(DefaultDate)) {
               if (this.format.substr(0,1) == 'M') {
                  var MonPart = RegExp.$1;
                  var DayPart = RegExp.$2;
               } else {
                  var MonPart = RegExp.$2;
                  var DayPart = RegExp.$1;
               }
               this.setPicked(GetGoodYear(RegExp.$3), parseInt(MonPart,10)-1, DayPart);
            }
            else SetGoodDate(this, true);
         }else if (/-/.test(this.format)) {
         	if (/MON/.test(this.format)){
         		// 显示英文月
	            var REMonths = '';
	            for (var j=0;j<MonthNames.length;j++) {
	               if (j > 0){
	               	REMonths += '|';
	               }
	               REMonths += MonthNames[j].substr(0,3).toUpperCase();
	            }
	            if (this.format.substr(0,1) == 'D') {
	               var DateRE = new RegExp('^(\\d{1,2})-(' + REMonths + ')-(\\d{2,4})$', 'i');
	               (DateRE.test(DefaultDate)) ? this.setPicked(GetGoodYear(RegExp.$3), getMonthIndex(RegExp.$2), RegExp.$1) : SetGoodDate(this, true);
	            } else {
	               var DateRE = new RegExp('^(' + REMonths + ')-(\\d{1,2})-(\\d{2,4})$', 'i');
	               (DateRE.test(DefaultDate)) ? this.setPicked(GetGoodYear(RegExp.$3), getMonthIndex(RegExp.$1), RegExp.$2) : SetGoodDate(this, true);
	            }
	        }else{
	        	// 中国日期显示
	            if (/^(\d{2,4})-(\d{1,2})-(\d{1,2})$/.test(DefaultDate)) {
	                  var MonPart = RegExp.$2;
	                  var DayPart = RegExp.$3;
	                  var YearPart = RegExp.$1;
	               this.setPicked(GetGoodYear(YearPart), parseInt(MonPart,10)-1, DayPart);
	            }else{
	            	SetGoodDate(this, true);
	            }
	     	}
         }
      }
   }
}

// Main function that creates the form elements
function DateInput(DateName, DateFormat, DefaultDate) {
   if (DateName == undefined){
   	document.writeln('<span style="color:red;font-size:' + FontSize + 'px;font-family:' + FontFamily + ';">ERROR: Missing required parameter in call to \'DateInput\': [name of hidden date field].</span>');
   }else {
      if (DateFormat == undefined){
      	DateFormat = DefaultDateFormat;
      }else if ((/^YYYYMMDD$/i.test(DateFormat)) || (/^YYYY-MM-DD$/i.test(DateFormat)) || (/^((MM?)|(DD?))\/((MM?)|(DD?))\/Y{2,4}$/i.test(DateFormat)) || (/^((DD?)|((MON)|(MMM)))-((DD?)|((MON)|(MMM)))-Y{2,4}$/i.test(DateFormat))){
      	DateFormat = DateFormat.toUpperCase();
      }else {
         DateFormat = DefaultDateFormat;
         var AlertMessage = 'WARNING: The supplied date format for the \'' + DateName + '\' field is not valid: ' + DateFormat + '\nTherefore, the default date format will be used instead: ' + DefaultDateFormat;
         var CurrentDate = new storedMonthObject(DefaultDateFormat, Today.getFullYear(), Today.getMonth(), Today.getDate());
         if (DefaultDate != undefined){
         	AlertMessage += '\n\nThe supplied date cannot be interpreted with the invalid format.\nTherefore, the current system date will be used instead: ' + CurrentDate.formatted;
        }
         DefaultDate = CurrentDate.formatted;
         alert(AlertMessage);
      }
      
      // Creates the calendar object!
      eval(DateName + '_Object=new calendarObject(\'' + DateName + '\',\'' + DateFormat + '\',\'' + DefaultDate + '\')');
      if (DefaultDate == undefined) {
         var InitialStatus = ' style="visibility:hidden"';
         var InitialDate = '';
      } else {
         var InitialStatus = '';
         var InitialDate = eval(DateName + '_Object.picked.formatted');
      }
      // Create the form elements
      with (document) {
         //writeln('<input type="text" name="' + DateName + '" value="' + InitialDate + '" onclick="javascript:' + DateName + '_Object.show()">');
         // Find this form number
         for (var f=0;f<forms.length;f++) {
            for (var e=0;e<forms[f].elements.length;e++) {
               if (typeof forms[f].elements[e].type == 'string') {
                  if ((forms[f].elements[e].type == 'text') && (forms[f].elements[e].name == DateName)) {
                  	forms[f].elements[e].value=InitialDate;
                  	forms[f].elements[e].readOnly=true;
                     eval(DateName + '_Object.formNumber='+f);
                     break;
                  }
               }
            }
         }
//		writeln('<table cellpadding="0" cellspacing="2"><tr>' + String.fromCharCode(13) + '<td valign="middle">');
		write(String.fromCharCode(13) + '<a' + InitialStatus + ' id="' + DateName + '_ID_Link" href="javascript:' + DateName + '_Object.show()" onMouseOver="return ' + DateName + '_Object.iconHover(true)" onMouseOut="return ' + DateName + '_Object.iconHover(false)"><img src="' + ImageURL + '" align="baseline" title="Calendar" width="16" height="15" border="0"></a>&nbsp;');
		writeln('<span id="' + DateName + '_ID" style="position:absolute;visibility:hidden;width:' + (CellWidth * 7) + 'px;background-color:' + CalBGColor + ';border:1px solid dimgray;" onMouseOver="' + DateName + '_Object.handleTimer(true)" onMouseOut="' + DateName + '_Object.handleTimer(false)">');
		writeln('<table width="' + (CellWidth * 7) + '" cellspacing="0" cellpadding="1">' + String.fromCharCode(13) + '<tr style="background-color:' + TopRowBGColor + ';">');
		writeln('<td id="' + DateName + '_PreviousYear_ID" style="cursor:default" align="center" class="calendarDateInput" style="height:' + CellHeight + '" onClick="' + DateName + '_Object.previousYear.go()" onMouseDown="VirtualButton(this,true)" onMouseUp="VirtualButton(this,false)" onMouseOver="return ' + DateName + '_Object.previousYear.hover(this,true)" onMouseOut="return ' + DateName + '_Object.previousYear.hover(this,false)" title="' + eval(DateName + '_Object.previousYear.yearValue') + '"><img src="' + PrevYearURL + '" width="9" height="9"/></td>');
		writeln('<td id="' + DateName + '_Previous_ID" style="cursor:default" align="center" class="calendarDateInput" style="height:' + CellHeight + '" onClick="' + DateName + '_Object.previous.go()" onMouseDown="VirtualButton(this,true)" onMouseUp="VirtualButton(this,false)" onMouseOver="return ' + DateName + '_Object.previous.hover(this,true)" onMouseOut="return ' + DateName + '_Object.previous.hover(this,false)" title="' + eval(DateName + '_Object.previous.monthName') + '"><img src="' + PrevURL + '" width="5" height="9"/></td>');
		writeln('<td id="' + DateName + '_Current_ID" style="cursor:pointer" align="center" class="calendarDateInput" style="height:' + CellHeight + '" colspan="3" onClick="' + DateName + '_Object.displayed.goCurrent()" onMouseOver="self.status=\'Click to view ' + eval(DateName + '_Object.displayed.fullName') + '\';return true;" onMouseOut="self.status=\'\';return true;" title="Show Current Month">' + eval(DateName + '_Object.displayed.fullName') + '</td>');
		writeln('<td id="' + DateName + '_Next_ID" style="cursor:default" align="center" class="calendarDateInput" style="height:' + CellHeight + '" onClick="' + DateName + '_Object.next.go()" onMouseDown="VirtualButton(this,true)" onMouseUp="VirtualButton(this,false)" onMouseOver="return ' + DateName + '_Object.next.hover(this,true)" onMouseOut="return ' + DateName + '_Object.next.hover(this,false)" title="' + eval(DateName + '_Object.next.monthName') + '"><img src="' + NextURL + '" width="5" height="9"/></td>');
		writeln('<td id="' + DateName + '_NextYear_ID" style="cursor:default" align="center" class="calendarDateInput" style="height:' + CellHeight + '" onClick="' + DateName + '_Object.nextYear.go()" onMouseDown="VirtualButton(this,true)" onMouseUp="VirtualButton(this,false)" onMouseOver="return ' + DateName + '_Object.nextYear.hover(this,true)" onMouseOut="return ' + DateName + '_Object.nextYear.hover(this,false)" title="' + eval(DateName + '_Object.nextYear.yearValue') + '"><img src="' + NextYearURL + '" width="9" height="9"/></td></tr>' + String.fromCharCode(13) + '<tr>');
		for (var w=0;w<7;w++){
			writeln('<td width="18" align="center" class="calendarDateInput" style="height:' + CellHeight + ';width:' + CellWidth + ';font-weight:bold;border-top:1px solid dimgray;border-bottom:1px solid dimgray;">' + WeekDays[w] + '</td>');
		}
		writeln('</tr>' + String.fromCharCode(13) + '</table>' + String.fromCharCode(13) + '<span id="' + DateName + '_DayTable_ID">' + eval(DateName + '_Object.buildCalendar()') + '</span>' + String.fromCharCode(13) + '</span>' );
      }
   }
}