iwms.htmlEncode=function(str){
	return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
};

var post=new Object();

post.container=null;		// 表单所在div
post.sourceEle=null;		// 开启表单的链接
post.arrCont=new Array();	// 已经获取了的父帖内容所在div
post.pId=0;			// 回复的主题 id
post.eId=0;			// 当前编辑帖 id
post.loaded=false;		// 是否已预处理完成
post.sorts=[];			// 讨论区分类
post._mobile=null;

// 是否手机访问
post.mobile=function(){
	if(post._mobile==null){
		var ua = navigator.userAgent;
		post._mobile = (ua.indexOf("AppleWebKit")>0 && ua.indexOf("Mobile")>0 || ua.indexOf("Android")>=0);
	}
	return post._mobile;
};

// 评论投票
post.vote = function(ele,id,s){
	if (!post.loaded){
		return;
	}
	var voted=iwms.cookie("iwmsPVoted");
	voted = voted.length==0 ? [] : voted.split(',');

	if($("#ps"+id+" span.psName").html()==iwms.user.name){
		iwms.popMsg('posts',ele,"不能对自己的帖投票!");
		iwms.hideMsg('posts',2000);
		return;
	}
	
	if (voted.include(id)){
		iwms.popMsg('posts',ele,"您已经对该帖投过票!");
		iwms.hideMsg('posts',2000);
		return;
	}
	
	iwms.ajSrc=ele;
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'vote',id:id,support:s},function(r){
		if (r.success){
			iwms.popMsg('posts',ele,"谢谢您参与投票!");
		}else{
			iwms.popMsg('posts',ele,"帖子已不存在，提交失败!");
		}
		iwms.hideMsg('posts',2000);
		if(voted.length>9){
			voted=voted.slice(voted.length-9);
		}
		voted.push(id);
		iwms.cookie("iwmsPVoted",voted.toString(),30);
		ele.innerHTML="已"+ele.innerHTML;
		ele=ele.nextSibling;
		var n = parseInt(ele.innerHTML.replace(/\D/g,""));
		ele.innerHTML="&nbsp;("+(n+1)+")";
	},'json');
};

// 页面插入新帖
post.insert = function(url){
	var fm=document.fmPost;
	// 有上传文件转临时文件名
	if (fm.upload.value.length>0){
		var arr = fm.upload.value.split(",");
		for(var i=0; i<arr.length; i++){
			fm.body.value=fm.body.value.replace(arr[i],arr[i].replace("temp_",""));
		}
	}
	var p_title=iwms.htmlEncode(fm.title.value);
	if (post.eId>0){
		// 编辑
		var $p=$("#ps"+post.eId);
		$("div.psTitle",$p).html('<a href="'+url+'">'+p_title+'</a>');
		$("div.psBody",$p).html(fm.body.value);
		$("span.psSort",$p).html(fm.sid.value=="0"?"其它":fm.sid.options[fm.sid.selectedIndex].text);
	}else{
		var $con=$("#psContainer");
		if ($con.length==0){
			return;
		}
		var tb=$con.get(0).tagName=="TBODY";	// 是否列表方式
		if(tb){
			var str='<tr><td class="psTitle"><a href="'+url+'">'+p_title+'</a></td><td class="psName">'+
				(iwms.user.name.length==0?"匿名":iwms.user.name)+
				'</td><td class="psHits">0</td><td class="psReply">0</td><td class="psDate">新发帖</td></tr>';
			var $fix=$("tr.psFix:last",$con);
			if ($fix.length>0){
				$fix.after(str);
			}else{
				$con.prepend(str);
			}
		}else{
			var str="<div class='psTitle'><a href='"+url+"'>"+p_title+"</a></div><div style='text-align:right'><span class='psName'>"+
					(iwms.user.name.length==0?"匿名":iwms.user.name)+
					"</span><span class='psDate'>新发帖</span>"+
					"</div><div class='psBody'>"+ fm.body.value +"</div>"+
					"<div class='psFun'><div class='psR'><span class='psHits'>阅读：0</span><span class='psReply'>跟帖：0</span></div></div>";
			if(post.pId>0){
				$("#ps"+post.pId).after(str);
			}else{
				var $fix=$("div.psFix:last",$con);
				if ($fix.length>0){
					$fix.after(str);
				}else{
					$con.prepend(str);
				}
			}
		}
	}
	var re=/<img/ig;
	if(re.test(fm.body.value)){
		iwms.imgResize();
	}
};

// 页面删除帖子隐藏
post.remove=function(id){
	$("#ps"+id).hide();
};

// 记录上传文件
post.logUpload=function(file){
	var o_u=document.fmPost.upload;
	if(o_u.value.length>1){
		o_u.value+=','+file;
	}else{
		o_u.value=file;
	}
};

// 显示表单
post.disp = function(ele, pid, ps){
	if (!post.loaded){
		return;
	}
	// 未登陆不显示
	if (post.userOnly && iwms.user.name.length==0){
		iwms.popMsg("post",ele,"你还没有<a href='#' onclick='iwms.logPop()'>登陆</a>，限<a href='memberreg.aspx'>注册会员</a>发帖");
		return;
	}
	if (post.container){
		var sourceChg=false;	// 事件源改变的话直接显示
		var o=post.container;
		if (post.sourceEle && ele && post.sourceEle!=ele){
			sourceChg=true;
		}
		post.sourceEle=ele;
		if (o.style.display=="none" || o.style.display=="" || sourceChg){
			var o_f=document.fmPost;
//			o_f.reset();	// tinymce会报错
			var pos=iwms.msgPos(ele,o);
			o.style.left=pos.x+"px";
			o.style.top=pos.y+"px";
			o.style.display="block";
			o.style.zIndex=100;
			// 添加分类选项
			if(o_f.sid.options.length==0){
				var opt=document.createElement("OPTION");
				opt.text="选择分类";
				opt.value="0";
				opt.style.color="#999";
				o_f.sid.options.add(opt);
				for(var i=0; i<post.sorts.length; i++){
					opt=document.createElement("OPTION");
					opt.text=post.sorts[i][1];
					opt.value=post.sorts[i][0];
					o_f.sid.options.add(opt);
				}
			}
			var ed=tinyMCE.get("body");
			if (ps){
				// 编辑的处理
				$("#fmTitle").html("编辑主题");
				post.pId=0;
				post.eId=ps.id;
				if (ps.pid>0){
					o_f.sid.style.display="none";
					o_f.title.style.width="380px";
				}else{
					o_f.sid.style.display="";
					o_f.title.style.width="280px";
				}
				o_f.title.value=ps.title;
				o_f.sid.selectedIndex=0;
				for(var i=0;i<o_f.sid.options.length;i++){
					if (o_f.sid.options[i].text==ps.sort){
						o_f.sid.selectedIndex=i;
						break;
					}
				}
				if (ed){
					ed.setContent(ps.body);
				}else{
					o_f.body.value=ps.body;
				}
			}else if (pid){
				// 回复的处理
				$("#fmTitle").html("回复主题");
				post.pId=pid;
				post.eId=0;
				ordTitle = $("#ps"+pid+" div.psTitle").text();
				var re=/^(re( \d+)?:)+/;
				if(re.test(ordTitle)){
					ordTitle=ordTitle.replace(re,"");
				}
				o_f.title.value = "re "+pid+":"+ ordTitle;
				o_f.sid.style.display="none";
				o_f.title.style.width="380px";
				if(ed){
					ed.setContent("");
					ed.focus();
				}else{
					o_f.body.value="";
					o_f.body.focus();
				}
			}else{
				$("#fmTitle").html("发表主题");
				post.pId=0;
				post.eId=0;
				o_f.sid.style.display="";
				o_f.title.value="";
				o_f.title.style.width="280px";
				for(var i=0;i<o_f.sid.options.length;i++){
					if(o_f.sid.options[i].value==post.sid){
						o_f.sid.selectedIndex=i;
						break;
					}
				}
				if(ed){
					ed.setContent("");
				}else{
					o_f.body.value="";
				}
				$(o_f.title).focus();
			}
			iwms.dropShadow("post",post.container);
		}else{
			iwms.clearShadow("post");
			o.style.display="none";
		}
	}else{
		iwms.ajSrc=ele;
		$.get(iwms.urlPrefix+'post.xml',function(r){
			var html=$(r).find("html:eq(0)").text();
			post.container=document.createElement("DIV");
			post.container.className="aj_form";
			post.container.innerHTML=html;
			document.body.appendChild(post.container);
			post.disp(ele, pid, ps);
			// 初始编辑器
			if(!post.mobile()){
				tinyMCE.init({
					mode : "textareas",
					editor_selector : "mcePost",
					init_instance_callback : "mceInit",
					save_callback : "mceSave",
					urlconverter_callback : "mceURLConverter",
					theme : "advanced",
					theme_advanced_toolbar_location : "top",
					theme_advanced_toolbar_align : "left",
					theme_advanced_resizing : true,
					theme_advanced_resizing_use_cookie : false,
					theme_advanced_statusbar_location : "bottom",
					width : 385,
					language : "cn",
					dialog_type : "modal",
					relative_urls : false,
					remove_linebreaks : false,
					forced_root_block : "",
					force_br_newlines : true,
					extended_valid_elements : "-div,p,-span[style],"+
							"-a[href|target:_blank],"+
							"-center,"+
							"input[type|name|value|checked|src|alt|size|maxlength],"+
							"button[name|value|type],"+
							"select[name|size|multiple],"+
							"textarea[name|rows|cols]",
					
					add_form_submit_trigger : true,
					submit_patch : true,
					add_unload_trigger : false,
					tab_focus : ':prev,:next',
				
					plugins : "preview,inlinepopups,fullscreen",
					
					theme_advanced_buttons1 : "bold,italic,underline,|forecolor,fontsizeselect,forecolor,removeformat,image,|,undo,redo,link,unlink,|,preview",
					theme_advanced_disable : "styleselect,formatselect,justifyleft,justifycenter,justifyright,justifyfull,strikethrough",
					theme_advanced_buttons2 : "",
					theme_advanced_buttons3 : "",
					invalid_elements : "script,fieldset,legend",
					setup : function(ed){
						ed.onKeyUp.add(function(ed,e){
							if(e.ctrlKey && e.keyCode==13){
								post.post();
							}
						});
					},
					
					swfupload_log_function : post.logUpload
				});
			}
		},'xml');
		return;
	}
};


// 初始完tinyMCE调整阴影
function mceInit(inst){
	iwms.dropShadow("post",post.container);
	$(post.container).resize(function(){
		iwms.dropShadow("post",post.container);
	});
	var o_f=inst.getElement().form;
	// 回复时内容focus
	if(o_f.title.value.length>0 && inst.getContent().length==0){
		inst.focus();
	}
}

// 保存数据前处理
function mceSave(eleId, html, body){
	var reP=/^\s*<p>(.*)<\/p>\s*$/ig;
	if(html.search(reP)>-1 && html.match(/<p>/ig).length==1){
		html=html.replace(reP, "$1");
	}else{
		var reDiv=/^\s*<div>(.*)<\/div>\s*$/ig;
		if(html.search(reDiv)>-1 && html.match(/<div>/ig).length==1){
			html=html.replace(reDiv, "$1");
		}
	}
	html=html.replace(/&nbsp;&nbsp;/g,"&nbsp; ");
	return html;
}

// tinyMCE的地址转换有点问题
function mceURLConverter(url, node, on_save){
	var du=tinyMCE.activeEditor.documentBaseURI.getURI();
	if(url.length>du.length && url.toLowerCase().indexOf(du.toLowerCase())==0){
		url=url.substring(du.length);
	}
	return url;
}

// 显示内容长度
post.dispLen = function(b){
	var ed=tinyMCE.get("body");
	var len= ed ? ed.getContent().length : document.fmPost.body.value.length;
	$("#bodyLen").val(b ? len : "");
};


$(function(){
	// 帖子container
	var $con=$("#psContainer");
	// 发帖时间修改为友好方式
	$("span.psDate,td.psDate",$con).each(function(i){
//		var d=new Date(this.title);
//		d=new Date(Date.parse(d)+iwms.timeDiff);
		var d=iwms.getClientDate(this.title);
		var s=d.toFriendString();
		this.innerHTML = s;
		this.title=d.toLocaleString();
	});
	// 显示类别名
	$.get("json.aspx",{cmd:'postSort'},function(r){
		post.sorts = r;

		post.id2sort();
		// 列表页的介绍显示处理
		if (typeof(post.sid)=="number"){
			var c=iwms.cookie("iwmsPostIntro");
			if(!c.sInclude(post.sid)){
				post.dispIntro();
			}
		}
	},'json');
	// 回复帖标题链接
	$("div.psBody legend",$con).each(function(i){
		var p;
		eval("p="+$(this).parent().parent().parent().find(".psJson").attr("title"));
		var re=/<span.+$/i;
		var s=$(this).html();
		re.test(s);
		var s1=RegExp.leftContext;
		var s2=RegExp.lastMatch;
		$(this).html("<a href='"+ (post.rewriteExt.length>0?"td"+p.pid+"."+post.rewriteExt : "thread.aspx?id="+p.pid) +"'>"+s1.gbLeft(60,"...")+"</a>"+s2);
	});
	// 显示管理项
	if(!post.verify && iwms.user.name.length>0){
		$("div.psFun",$con).each(function(i){
			if(iwms.user.admPs || iwms.user.name==$(this).siblings(".psName:first").html()){
				$(this).append('<a href="###" onmouseover="post.popAdm(this)">管理</a>');
			}
		});
	}
	// 非管理员不显示审核链接
	if(iwms.user.admPs && !post.verify && post.ncNum>0){
		$("#middle div.sBlank").prepend('<a href="posts.aspx?v=1" class="psSelVerify">审核帖子('+post.ncNum+')</a> ');
	}
	// 会员名加菜单
	$("span.psName[title]",$con).each(function(i){
		var uid=parseInt(this.title);
		this.style.cursor="pointer";
		this.onmouseover=function(){
			post.popUser(this,uid);
		};
		this.removeAttribute("title");
	});
	// 只显示标题时加行变色
	if($("table.psCont2").length==1){
		$("tr",$con).mouseover(function(){$(this).addClass("psBg2");}).mouseout(function(){$(this).removeClass("psBg2");});
	}
	// 添加发表主题链接
	if(!post.verify){
		$("#middle div.psFrm div.tm").append('　　[<a href="###" onclick="post.disp(this)">发表主题</a>]');
	}

	post.loaded=true;
});

// 显示发帖协议
post.dispAgreement = function(){
	var o=document.fmPost.nextSibling;
	o.style.display = o.style.display=="none" ? "block" : "none";
	iwms.dropShadow("post",post.container);
};

// 取帖子内容
post.getContent = function(obj,id){
	if (!post.loaded){
		return;
	}
	var $pbody = $("#ps"+id+" div.psPBody");
	
	if ($pbody.html()==""){
		var p=post.getCur(id);
		// 其它帖取过同一父帖
		for(var i=0;i<post.arrCont.length;i++){
			if(post.arrCont[i][0]==p.pid){
				$pbody.html(post.arrCont[i][1].innerHTML);
				$pbody.slideDown('fast');
				post.showQuote(obj,id);
				iwms.imgResize();
				return;
			}
		}
		iwms.ajSrc=obj;
		$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'get',id:p.pid},function(r){
			if(r.success){
				post.arrCont.push([p.pid,$pbody.get(0)]);
				$pbody.html(r.content).slideDown('fast');
				post.showQuote(obj,id);
				iwms.imgResize();
			}else{
				iwms.popMsg('posts',obj,"取帖子内容失败！");
				iwms.hideMsg('posts',2000);
				return;
			}
		},'json');
	}else{
		post.showQuote(obj,id);
	}
};

// 展开收缩引用帖内容
post.showQuote = function(obj,id){
		if (obj.className=="psOpen"){
			obj.className="psClose";
			$("#ps"+id+" div.psPBody").show();
		}else{
			obj.className="psOpen";
			$("#ps"+id+" div.psPBody").hide();
		}
};

// 提交帖子
post.post = function(){
	var ed=tinyMCE.get("body");
	if(ed)ed.save();

	var fm=document.fmPost;
	if (iwms.cookie("posted").length>0){
		alert("为防灌水,请稍后重发");
		return false;
	}
	if (!$("#rmAgree").get(0).checked){
		alert("只有同意本站发帖声明才可发布");
		return false;
	}
	fm.title.value=fm.title.value.trim();
	if (fm.title.value.gbLen()<10 || fm.title.value.isSpace()){
		alert("标题不能少于10个字符(5个中文)");
		fm.title.focus();
		return false;
	}
	if(fm.sid.style.display=="" && fm.sid.value=="0"){
		alert("请选择帖子分类");
		return false;
	}
	if (fm.body.value.gbLen()<4 || fm.body.value.isSpace()){
		alert("内容不能少于4个字符(2个中文)");
		if(ed){
			ed.focus();
		}else{
			fm.body.focus();
		}
		return false;
	}
	if (fm.body.value.length>post.maxSize){
		post.dispLen(fm.body);
		if(ed){
			ed.focus();
		}else{
			fm.body.focus();
		}
		alert("帖子内容不可以超过"+post.maxSize+"字");
		return false;
	}
	
	if(ed){
		ed.setProgressState(1);
	}else{
		fm.body.value=iwms.htmlEncode(fm.body.value).replace(/\r?\n/g,"<br/>");
	}

	iwms.ajSrc=post.sourceEle;
	var v=iwms.ajForm(fm);
	v.act='ajax';

	if(post.eId>0){
		v.cmd='edit';
		v.id=post.eId;
	}else{
		v.cmd='add';
		v.pid=post.pId;
	}
	v.vcode=iwms.vCode;
	$.post(iwms.urlPrefix+'posts.aspx',v,function(r){
		if(ed)ed.setProgressState(0);
		post.disp();
		if (r.interval>0){
			iwms.cookie('posted','1',r.interval/24/360);
		}
		if (r.success){
			post.insert(r.obj.url);
		}
		iwms.popMsg('posts',iwms.ajSrc,r.msg);
		iwms.hideMsg('posts',2000);
	},'json');
	return false;
};

// 显示会员菜单
post.popUser=function(ele, id)
{
	if (!post.loaded){
		return;
	}
	var d=document.createElement("DIV");
	var a=document.createElement("A");
	d.className="popAdm";
	a.innerHTML="会员资料";
	a.href="memberProfile.aspx?id="+id;
	a.target="_blank";
	d.appendChild(a);
	a=document.createElement("A");
	a.innerHTML="查看帖子";
	a.href="search.aspx?type=post&where=memberid&keyword="+id;
	a.target="_blank";
	d.appendChild(a);
	iwms.popMsg("postUser",ele,d);	
};

// 显示管理菜单
post.popAdm=function(ele)
{
	if (!post.loaded){
		return;
	}
	var p;
	eval("p="+$(ele).siblings("span.psJson").attr("title"));
	var d=document.createElement("DIV");
	var a=document.createElement("A");
	d.className="popAdm";
	a.innerHTML="编辑";
	a.href="javascript:post.edit("+p.id+")";
	d.appendChild(a);
	if (iwms.user.admPs){
		a=document.createElement("A");
		a.innerHTML="删除";
		a.href="javascript:post.del("+p.id+")";
		d.appendChild(a);
		if (p.pid==0){
			a=document.createElement("A");
			a.innerHTML="置顶";
			a.href="###";
			a.onclick=new Function("post.getFix(this,"+p.id+")");
			d.appendChild(a);
		}
	}
	iwms.popMsg("postAdm",ele,d);
};

// 显示置顶菜单
post.popFix=function(id,sids){
	var d=document.createElement("DIV");
	var a=document.createElement("A");
	d.className="popFix";
	a.href="###";
	a.onclick=new Function("post.fixChk(this)");
	a.title="0";
	a.innerHTML="首页";
	d.appendChild(a);
	for(var i=0;i<post.sorts.length;i++){
		a=document.createElement("A");
		a.href="###";
		a.onclick=new Function("post.fixChk(this)");
		a.title=post.sorts[i][0];
		a.innerHTML=post.sorts[i][1];
		d.appendChild(a);
	}
	for(var i=0;i<d.childNodes.length;i++){
		var r=new RegExp("(^|,)"+d.childNodes[i].title+"(,|$)","ig");
		if(r.test(sids)){
			post.fixChk(d.childNodes[i]);
		}
	}
	a=document.createElement("A");
	a.href="###";
	a.onclick=new Function("post.fixSave(this,"+id+")");
	a.style.background="none";
	a.innerHTML="设置";
	d.appendChild(a);
	iwms.hideMsg("postAdm");
	iwms.popMsg("postFix",$("#ps"+id+" div.psFun a:last").get(0),d);
};

// 选择是否分类置顶
post.fixChk=function(ele){
	$(ele).toggleClass("psChk");
};

// 保存置顶设置
post.fixSave=function(ele,id){
	var sids="";
	$(ele).parent().find("a[title]").each(function(i){
		if (this.className=="psChk"){
			if(sids.length>0){
				sids+=",";
			}
			sids+=this.title;
		}
	});
	iwms.ajSrc=$("#ps"+id+" div.psFun a:last").get(0);
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'saveFix',id:id,sids:sids},function(r){
		iwms.popMsg('posts',iwms.ajSrc,r.success?"置顶设置成功":msg);
		iwms.hideMsg('posts',2000);
	},'json');
};

// 取帖子置顶设置
post.getFix=function(ele,id){
	iwms.ajSrc=ele;
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'getFix',id:id},function(r){
		post.popFix(id,r.sids)
	},'json');
};

// 编辑
post.edit=function(id){
	var p=post.getCur(id);
	var $con=$("#ps"+id);

	var p_title=$("div.psTitle",$con).text();
	var p_sort=$("span.psSort",$con).text();

	iwms.ajSrc=$("div.psFun a:last",$con).get(0);
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'get',id:id},function(r){
		var p_body=r.content;
		if (r.success){
			post.disp(iwms.ajSrc,0,{"id":id,"pid":p.pid,"title":p_title,"sort":p_sort,"body":p_body});
		}else{
			iwms.popMsg("posts",iwms.ajSrc,"取帖子内容失败！");
			iwms.hideMsg("posts",2000);
			return;
		}
	},'json');
};

// html取内容时去掉里边的引用fieldset
post.clearQuote = function(b){
	var r=/<\/fieldset>/ig;
	var n=b.search(r);
	if (n>=0){
		b=b.substr(n+11);
	}
	return b;
};

// 删除
post.del=function(id){
	var b=confirm("删除帖子会同时删除跟帖，确认操作？");
	if(!b){
		return;
	}
	var obj=$("#ps"+id).prev();
	if (obj.length==0){
		obj=$(".psFrm .tt");
	}
	obj=obj.get(0);
	
	iwms.ajSrc=obj;
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'del',id:id},function(r){
		if (r.success){
			post.remove(id);
			iwms.popMsg("posts",obj,"删除成功!");
		}else{
			iwms.popMsg("posts",obj,"删除失败!");
		}
		iwms.hideMsg("posts",2000);
	},'json');
};

// 审核通过
post.pass=function(id){
	var b=confirm("确认此帖通过审核？");
	if(!b){
		return;
	}
	var obj=$("#ps"+id).prev();
	if (obj.length==0){
		obj=$(".psFrm .tt");
	}
	obj=obj.get(0);
	
	iwms.ajSrc=obj;
	$.post(iwms.urlPrefix+'posts.aspx',{act:'ajax',cmd:'pass',id:id},function(r){
		if (r.success){
			post.remove(id);
			iwms.popMsg("posts",obj,"审核通过成功!");
		}else{
			iwms.popMsg("posts",obj,"审核通过失败!");
		}
		iwms.hideMsg("posts",2000);
	},'json');
};

// 从json取当前帖值
post.getCur=function(id){
	var s=$("#ps"+id +" span.psJson").attr("title");
	var p;
	eval("p="+ s +";");
	return p;
};

// 显示分类介绍
post.dispIntro=function(){
	$intro=$("div.psIntro div.sIntro");
	if($intro.html()==""){
		var str="";
		if(post.sid>0){
			for(var i=0;i<post.sorts.length;i++){
				if(post.sorts[i][0]==post.sid){
					str=post.sorts[i][2];
				}
			}
			if(str.length==0){
				str="&nbsp;";
			}
		}else{
			var surl=post.rewriteExt.length>0 ? "ps[id]."+post.rewriteExt : "posts.aspx?sid=[id]";
			for(var i=0;i<post.sorts.length;i++){
				str+="<div style='width:33%;float:left'><strong><a href='"+surl.replace("[id]",post.sorts[i][0])+"'>"+post.sorts[i][1]+"</a></strong><br/>"+post.sorts[i][2]+"</div>";
			}
			if(str.length==0){
				str="&nbsp;"
			}
		}
		$intro.html(str);
	}
	var opened=$intro.css("display")=="block";
	$intro.slideToggle("fast");
	$("div.psIntro div.sName").css({"border-bottom-width":(opened?"1px":"0px"), "background-position":"right "+(opened?"-350px":"-400px")});
	opened=!opened;		// 已调
	var co=iwms.cookie("iwmsPostIntro");
	if(co.sInclude(post.sid) && opened){
		co=co.sRemove(post.sid);
	}else if(!co.sInclude(post.sid) && !opened){
		if(co.length>0){
			co+=",";
		}
		co+=post.sid;	
	}
	iwms.cookie("iwmsPostIntro",co,co.length>0?30:-1);
};

// 帖中分类id转分类名
post.id2sort=function(){
	$("#psContainer span.psSort").each(function(i){
		var sid=parseInt(this.innerHTML);
		this.title="类别";
		if (sid<0){
			sid*=-1;
		}
		for(var i=0;i<post.sorts.length;i++){
			if (post.sorts[i][0]==sid){
				this.innerHTML=post.sorts[i][1];
				break;
			}
		}
	});
};

// 设置列表方式是否默认
post.listType=function(){
	var co=iwms.cookie("iwmsPostList");
	if(co.sInclude(post.sid)){
		co=co.sRemove(post.sid);
	}else{
		if(co.length>0){
			co+=",";
		}
		co+=post.sid;
	}
	iwms.cookie("iwmsPostList",co,co.length>0?30:-1);
	location.reload();
};