﻿CREATE TABLE [Blog_Class] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [UserID] int Default 0 NULL,
    [PKey] nvarchar(500) NULL,
    [Name] nvarchar(250) NULL,
    [CreateTime] datetime Default getdate() NULL,
    [TypeID] int Default 0 NULL,
    [Count] int Default 0 NULL,
    [IsVisible] bit Default 1 NULL,
    [Description] nvarchar(250) NULL 
)

CREATE TABLE [Blog_Comment] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [ContentUserID] int Default 0 NULL,
    [ContentID] int NULL,
    [TypeID] int Default 0 NULL,
    [UserID] int NULL,
    [NickName] nvarchar(50) NULL,
    [Body] nvarchar(4000) NULL,
    [CreateTime] datetime Default getdate() NULL,
    [ReBody] nvarchar(4000) NULL 
)

CREATE TABLE [Blog_Content] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [ClassID] int NULL,
    [UserID] int NULL,
    [TypeID] int Default 0 NULL,
    [Title] nvarchar(200) NULL,
    [Abstract] nvarchar(4000) NULL,
    [Tag] nvarchar(255) NULL,
    [CreateTime] datetime Default getdate() NULL,
    [Icon] nvarchar(255) NULL,
    [ViewLevel] int NULL,
    [ViewPassword] nvarchar(50) NULL,
    [CommentLevel] int NULL,
    [CommentCount] int Default 0 NULL,
    [EditTime] datetime Default getdate() NULL,
    [Hits] int Default 0 NULL,
    [IsRss] bit Default 1 NULL,
    [IsPub] bit Default 0 NULL,
    [IsTop] bit Default 0 NULL,
    [IsMain] bit Default 0 NULL,
    [SysClassID] int NULL,
    [LanguageID] int Default 1 NULL,
    [SysTypeID] int NULL 
)

CREATE TABLE [Blog_ContentBody] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [Body] ntext NULL 
)

CREATE TABLE [Blog_ContentHit] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [Hits] int Default 0 NULL 
)

CREATE TABLE [Blog_File] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [UserID] int Default 0 NULL,
    [FileName] nvarchar(255) NULL,
    [FilePath] nvarchar(255) NULL,
    [Size] int Default 0 NULL,
    [CreateTime] datetime Default getdate() NULL,
    [IsTemp] bit Default 1 NULL,
    [Hits] int Default 0 NULL,
    [SourceName] nvarchar(255) NULL 
)

CREATE TABLE [Blog_Link] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [UserID] int NULL,
    [Title] nvarchar(150) NULL,
    [LinkUrl] nvarchar(150) NULL,
    [Body] nvarchar(300) NULL,
    [CreateTime] datetime Default getdate() NULL 
)

CREATE TABLE [Blog_Skin] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [UserID] int Default 0 NULL,
    [Name] nvarchar(32) NULL,
    [SkinPath] nvarchar(255) NULL,
    [IsEnabled] bit Default 1 NULL,
    [CreateTime] datetime Default getdate() NULL 
)

CREATE TABLE [Blog_User] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [UserName] nvarchar(50) NULL,
    [NickName] nvarchar(50) NULL,
    [Password] nvarchar(500) NULL,
    [Email] nvarchar(50) NULL,
    [SkinID] int Default 1 NULL,
    [HeadUrl] nvarchar(500) Default (N'/Upload/UserHead/default1.jpg') NULL,
    [Bulletin] nvarchar(4000) NULL,
    [Enabled] bit NULL,
    [SpaceName] nvarchar(300) Default (N'我的博客') NULL,
    [SpaceIntro] nvarchar(500) Default (N'作者:路过秋天 http://www.cyqdata.com') NULL,
    [Sign] nvarchar(500) NULL,
    [CustomCss] nvarchar(4000) NULL,
    [ArticleListSize] int Default 10 NULL,
    [PhotoListSize] int Default 12 NULL,
    [Amount] int Default 0 NULL,
    [VisitCount] int Default 0 NULL,
    [CreateTime] datetime Default getdate() NULL,
    [LanguageID] int Default 0 NULL,
    [ShowModule] int Default 65535 NULL 
)

CREATE TABLE [Blog_UserVisit] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [VisitCount] int Default 0 NULL 
)

CREATE TABLE [ErrorLogs] 
(
    [ID] int IDENTITY(1,1) NOT NULL  PRIMARY key,
    [PageUrl] nvarchar(400) NULL,
    [ErrorMessage] nvarchar(2000) NULL,
    [CreateTime] datetime Default getdate() NULL 
)
go
--基本数据导入：
--1：默认用户：
insert into Blog_User(UserName,NickName,Password) values('cyqdata','cyqdata','aABB0AHQAYwBhAGEAYQA4ADMAZABnAGIAYQBhAGcAYQBxAHkAcQBCBkAGEAdABhAC4AYwBvAG0AcAA6AC8A');

go
--2：皮肤路径：
insert into Blog_Skin(Name,SkinPath) values('skin_default','/skin/default/');
insert into Blog_Skin(Name,SkinPath) values('skin_black','/skin/skin_black/');
insert into Blog_Skin(Name,SkinPath) values('skin_blue','/skin/skin_blue/');
insert into Blog_Skin(Name,SkinPath) values('skin_bbs','/skin/skin_bbs/');
insert into Blog_Skin(Name,SkinPath) values('skin_cogitation','/skin/skin_cogitation/');
insert into Blog_Skin(Name,SkinPath) values('skin_sea','/skin/skin_sea/');
insert into Blog_Skin(Name,SkinPath) values('skin_rose','/skin/skin_rose/');
insert into Blog_Skin(Name,SkinPath) values('skin_pinktree','/skin/skin_pinktree/');

go
--分页存储过程：
create  procedure [dbo].[SelectBase] 
           @PageIndex         int, 
           @PageSize      int, 
           @TableName    nvarchar(4000), 
           @Where     nvarchar(2000)='' 
           as 
           Declare @rowcount    int 
           Declare @intStart    int 
           Declare @intEnd         int 
           declare @Column1 varchar(32) --第一列名称
           Declare @Sql nvarchar(2000), @WhereR nvarchar(1000), @OrderBy nvarchar(1000) 
           set @rowcount=0 
           set nocount on 
           if @Where<>'' 
           begin 
           set @Where=' and '+@Where 
           end 
           if CHARINDEX('order by', @Where)>0 
           begin 
           set @WhereR=substring(@Where, 1, CHARINDEX('order by',@Where)-1) --取得条件 
           set @OrderBy=substring(@Where, CHARINDEX('order by',@Where), Len(@Where)) --取得排序方式(order by 字段 方式) 
           end 
           else 
           begin 
           set @WhereR=@Where 
           set @OrderBy=' order by id asc' 
           end 
           set @Sql='SELECT @rowcount=count(*) from '+cast(@TableName as varchar(4000))+' where 1=1 '+@WhereR 

           exec sp_executeSql @Sql,N'@rowcount int output',@rowcount output 
           if @PageIndex=0 and @PageSize=0 --不进行分页,查询所有数据列表 
           begin 
           set @Sql='SELECT * from '+cast(@TableName as varchar(4000))+' where 1=1 '+@Where 
           end 
           else --进行分页查询数据列表 
           begin 
           set @intStart=(@PageIndex-1)*@PageSize+1; 
           set @intEnd=@intStart+@PageSize-1 
           set @Column1=col_name(object_id(@tableName),1) --设置第一列名称
           if @Column1 is null begin set @Column1='ID' end --设置默认为ID列
           set @Sql='Create table #tem(tempID int identity(1,1) not null,Row int) '  
           set @Sql=@Sql+'insert #tem(Row) select '+@Column1+' from '+@TableName+' where 1=1 '+@Where  
           set @Sql=@Sql+' select * from '+@TableName+' left join #tem  on '+@Column1+'=#tem.Row '  
           set @Sql=@Sql+' where  #tem.tempID between '+cast(@intStart as varchar)+' and '+cast(@intEnd as varchar) 
           end 
           exec sp_executeSql @Sql 
           return @rowcount 
           set nocount off 

GO