﻿CREATE TABLE `Blog_Class` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `UserID` int Default 0 NULL,
    `PKey` varchar(1000) NULL,
    `Name` varchar(500) NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP,
    `TypeID` int Default 0 NULL,
    `Count` int Default 0 NULL,
    `IsVisible` bit Default 1 NULL,
    `Description` varchar(500) NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_Comment` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `ContentUserID` int Default 0 NULL,
    `ContentID` int NULL,
    `TypeID` int Default 0 NULL,
    `UserID` int NULL,
    `NickName` varchar(100) NULL,
    `Body` varchar(8000) NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP,
    `ReBody` varchar(8000) NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_Content` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `ClassID` int NULL,
    `UserID` int NULL,
    `TypeID` int Default 0 NULL,
    `Title` varchar(400) NULL,
    `Abstract` varchar(8000) NULL,
    `Tag` varchar(510) NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP,
    `Icon` varchar(510) NULL,
    `ViewLevel` int NULL,
    `ViewPassword` varchar(100) NULL,
    `CommentLevel` int NULL,
    `CommentCount` int Default 0 NULL,
    `EditTime` datetime NULL,
    `Hits` int Default 0 NULL,
    `IsRss` bit Default 1 NULL,
    `IsPub` bit Default 0 NULL,
    `IsTop` bit Default 0 NULL,
    `IsMain` bit Default 0 NULL,
    `SysClassID` int NULL,
    `LanguageID` int Default 1 NULL,
    `SysTypeID` int NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_ContentBody` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `Body` longtext NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_ContentHit` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `Hits` int Default 0 NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_File` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `UserID` int Default 0 NULL,
    `FileName` varchar(510) NULL,
    `FilePath` varchar(510) NULL,
    `Size` int Default 0 NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP,
    `IsTemp` bit Default 1 NULL,
    `Hits` int Default 0 NULL,
    `SourceName` varchar(510) NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_Link` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `UserID` int NULL,
    `Title` varchar(300) NULL,
    `LinkUrl` varchar(300) NULL,
    `Body` varchar(600) NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_Skin` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `UserID` int Default 0 NULL,
    `Name` varchar(64) NULL,
    `SkinPath` varchar(510) NULL,
    `IsEnabled` bit Default 1 NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_User` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `UserName` varchar(100) NULL,
    `NickName` varchar(100) NULL,
    `Password` varchar(1000) NULL,
    `Email` varchar(100) NULL,
    `SkinID` int Default 1 NULL,
    `HeadUrl` varchar(1000) Default "/Upload/UserHead/default1.jpg" NULL,
    `Bulletin` varchar(8000) NULL,
    `Enabled` bit NULL,
    `SpaceName` varchar(600) Default "我的博客" NULL,
    `SpaceIntro` varchar(1000) Default "作者:路过秋天 http://www.cyqdata.com" NULL,
    `Sign` varchar(1000) NULL,
    `CustomCss` varchar(8000) NULL,
    `ArticleListSize` int Default 10 NULL,
    `PhotoListSize` int Default 12 NULL,
    `Amount` int Default 0 NULL,
    `VisitCount` int Default 0 NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP,
    `LanguageID` int Default 0 NULL,
    `ShowModule` int Default 65535 NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `Blog_UserVisit` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `VisitCount` int Default 0 NULL 
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `ErrorLogs` 
(
    `ID` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `PageUrl` varchar(800) NULL,
    `ErrorMessage` varchar(4000) NULL,
    `CreateTime` timestamp DEFAULT CURRENT_TIMESTAMP
)ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


/*基本数据导入：*/

/*1：默认用户：*/
insert into Blog_User(UserName,NickName,Password) values('cyqdata','cyqdata','aABB0AHQAYwBhAGEAYQA4ADMAZABnAGIAYQBhAGcAYQBxAHkAcQBCBkAGEAdABhAC4AYwBvAG0AcAA6AC8A');

/*2：皮肤路径：*/
insert into Blog_Skin(Name,SkinPath) values('skin_default','/skin/default/');
insert into Blog_Skin(Name,SkinPath) values('skin_black','/skin/skin_black/');
insert into Blog_Skin(Name,SkinPath) values('skin_blue','/skin/skin_blue/');
insert into Blog_Skin(Name,SkinPath) values('skin_bbs','/skin/skin_bbs/');
insert into Blog_Skin(Name,SkinPath) values('skin_cogitation','/skin/skin_cogitation/');
insert into Blog_Skin(Name,SkinPath) values('skin_sea','/skin/skin_sea/');
insert into Blog_Skin(Name,SkinPath) values('skin_rose','/skin/skin_rose/');
insert into Blog_Skin(Name,SkinPath) values('skin_pinktree','/skin/skin_pinktree/');


