﻿<%@ Page Inherits="TidyBlog.Web.Admin_ArticleSetup" Codebehind="ArticleSetup.aspx.cs" %>
<%@ Import Namespace="TidyBlog.BLL" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=update" method="post">
    <table class="twoCols"> 
        <thead>
            <tr>
                <th class="caption" colspan="2">文章设置</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="重 置" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th><label for="summaryLength">摘要长度</label></th>
                <td>
                    <input type="text" id="summaryLength" name="summaryLength" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("SummaryLength") %>" /> 个字
                    <em>* (大概值，50-5000之间)</em>
                </td>
            </tr>
            <!--<tr>
                <th><label for="displayMode">列表模式</label></th>
                <td>
                    <select id="displayMode" name="displayMode">
                        <option value="1"<% if (ArticleSetupBLL.Read("DisplayMode").Equals("1")) { %> selected="selected"<% } %>>仅显示标题</option>
                        <option value="2"<% if (ArticleSetupBLL.Read("DisplayMode").Equals("2")) { %> selected="selected"<% } %>>显示标题和摘要(推荐)</option>
                        <option value="3"<% if (ArticleSetupBLL.Read("DisplayMode").Equals("3")) { %> selected="selected"<% } %>>显示全文</option>
                    </select>
                    <em>*</em>
                </td>
            </tr>-->
            <tr>
                <th><label for="pageSize">每页显示文章</label></th>
                <td>
                    <input type="text" id="pageSize" name="pageSize" maxlength="2" style="width: 25px;" value="<%=ArticleSetupBLL.Read("PageSize") %>" /> 篇
                    <em>(* 1-50篇)</em>
                </td>
            </tr>
            <tr>
                <th><label for="allowExternalHosts">允许外链域名</label></th>
                <td>
                    <textarea id="allowExternalHosts" name="allowExternalHosts" style="width: 240px; height: 80px;"><%=ArticleSetupBLL.Read("AllowExternalHosts") %></textarea>
                    <em>(每个域名一行)</em>
                </td>
            </tr>
            <tr>
                <th><label for="allowComment">评论设置</label></th>
                <td>
                    <select name="allowComment">
                        <option value="0"<% if (ArticleSetupBLL.Read("AllowComment").Equals("0")) { %> selected="selected"<% } %>>关闭</option>
                        <option value="1"<% if (ArticleSetupBLL.Read("AllowComment").Equals("1")) { %> selected="selected"<% } %>>审核模式</option>
                        <option value="2"<% if (ArticleSetupBLL.Read("AllowComment").Equals("2")) { %> selected="selected"<% } %>>开放</option>
                    </select>，
                    <label for="commentLength">不超过</label>
                    <input type="text" id="commentLength" name="commentLength" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("CommentLength") %>" />
                    个字符
                    <em>* (0-5000，0为不限制)</em>，
                    <label for="commentInterval">间隔</label>
                    <input type="text" id="commentInterval" name="commentInterval" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("CommentInterval") %>" /> 秒
                    <em>* (0-9999，0为不限制)</em>
                </td>
            </tr>
            <tr>
                <th><label for="allowMessage">留言开关</label></th>
                <td>
                    <select name="allowMessage">
                        <option value="0"<% if (ArticleSetupBLL.Read("AllowMessage").Equals("0")) { %> selected="selected"<% } %>>关闭</option>
                        <option value="1"<% if (ArticleSetupBLL.Read("AllowMessage").Equals("1")) { %> selected="selected"<% } %>>审核模式</option>
                        <option value="2"<% if (ArticleSetupBLL.Read("AllowMessage").Equals("2")) { %> selected="selected"<% } %>>开放</option>
                    </select>，
                    <label for="messageLength">不超过</label>
                    <input type="text" id="messageLength" name="messageLength" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("MessageLength") %>" />
                    个字符
                    <em>* (0-5000，0为不限制)</em>，
                    <label for="messageInterval">间隔</label>
                    <input type="text" id="messageInterval" name="messageInterval" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("MessageInterval") %>" /> 秒
                    <em>* (0-9999，0为不限制)</em>
                </td>
            </tr>
            <tr>
                <th><label for="badWords">敏感字词</label></th>
                <td>
                    <textarea id="badWords" name="badWords" style="width: 240px; height: 200px;" rows="11" cols="50"><%=ArticleSetupBLL.Read("BadWords") %></textarea>
                    <em>(每行填写一个敏感字词)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {
		  
function isWords(value) { return "" == value || /^\w+(?:\|\w+)*$/.test(value); }

var validator = new $.validate.FormValidator($("form")[0]);
validator.addRules("summaryLength", Number, ["min", 50, "摘要长度不能小于50"], ["max", 5000, "摘要长度不能大于5000"]);
validator.addRules("pageSize", Number, ["min", 1, "每页文章数不能小于1"], ["max", 50, "每页文章数不能大于50"]);
validator.addRules("allowFileTypes", [isWords, "错误的文件类型"]);
validator.addRules("commentMessage", Number, ["min", 0, "评论长度不能小于0"], ["max", 5000, "评论长度不能大于5000"]);
validator.addRules("commentInterval", Number, ["min", 0, "评论间隔不能小于0秒"], ["max", 9999, "评论间隔不能大于9999秒"]);
validator.addRules("messageLength", Number, ["min", 0, "留言长度不能小于0"], ["max", 5000, "留言长度不能大于5000"]);
validator.addRules("messageInterval", Number, ["min", 0, "留言间隔不能小于0秒"], ["max", 9999, "留言间隔不能大于9999秒"]);

$("#summaryLength").focus();

})()
//]]></script>