﻿<%@ Page Inherits="TidyBlog.Web.Admin_BasicSetup" Codebehind="BasicSetup.aspx.cs" %>
<%@ Import Namespace="TidyBlog.BLL" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=update" method="post">
    <table class="twoCols">
        <thead>
            <tr>
                <th class="caption" colspan="2">基础设置</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="重 置" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th><label for="blogName">博客名</label></th>
                <td>
                    <input type="text" id="blogName" name="blogName" maxlength="30" style="width: 200px;" value="<%=BasicSetupBLL.Read("BlogName") %>" />
                    <em>* (30个字以内)</em>
                </td>
            </tr>
            <tr>
                <th><label for="keywords">关键字</label></th>
                <td>
                    <input type="text" id="keywords" name="keywords" maxlength="80" style="width: 280px;" value="<%=BasicSetupBLL.Read("Keywords") %>" />
                    <em>* (80个字以内)</em>
                </td>
            </tr>
            <tr>
                <th><label for="blogIntro">简介</label></th>
                <td>
                    <textarea id="blogIntro" name="blogIntro" style="width: 350px; height: 60px;"><%=BasicSetupBLL.Read("BlogIntro") %></textarea>
                </td>
            </tr>
            <tr>
                <th><label for="domain">域名</label></th>
                <td>
                    <input type="text" id="domain" name="domain" maxlength="50" style="width: 160px;" value="<%=BasicSetupBLL.Read("Domain") %>" />
                    <em>(50个字符以内)</em>
                </td>
            </tr>
            <tr>
                <th><labe for="createDate">创建日期</labe></th>
                <td>
                    <input type="text" id="createDate" name="createDate" maxlength="20" style="width: 100px;" value="<%=BasicSetupBLL.Read("CreateDate") %>" />
                    <em>* (格式: 年-月-日)</em>
                </td>
            </tr>
            <tr>
                <th>访问控制</th>
                <td>
                    <input type="radio" name="isOpened" id="closed" value="0"<% if (BasicSetupBLL.Read("IsOpened").Equals("0")) { %> checked="checked"<% } %> /><label for="closed">关闭（后台仍然可访问）</label>
                    <input type="radio" name="isOpened" id="memberVisible" value="1"<% if (BasicSetupBLL.Read("IsOpened").Equals("1")) { %> checked="checked"<% } %> /><label for="memberVisible">仅允许用户访问</label>
                    <input type="radio" name="isOpened" id="opened" value="2"<% if (BasicSetupBLL.Read("IsOpened").Equals("2")) { %> checked="checked"<% } %> /><label for="opened">允许所有人访问</label>
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <th><label for="closeReason">关闭原因</label></th>
                <td>
                    <textarea id="closeReason" name="closeReason" style="width: 350px; height: 60px;"><%=BasicSetupBLL.Read("CloseReason") %></textarea>
                </td>
            </tr>
            <tr>
                <th><label for="forbiddenIPs">禁止 IP</label></th>
                <td>
                    <textarea id="forbiddenIPs" name="forbiddenIPs" rows="5" cols="50" style="width: 150px; height: 80px;"><%=BasicSetupBLL.Read("ForbiddenIPs")%></textarea>
                    <em>(每行填写一个IP，无禁止IP勿填)</em>
                </td>
            </tr>
            <tr>
                <th><label for="timeDiff">时差</label></th>
                <td>
                    <input id="timeDiff" name="timeDiff" type="text" maxlength="5" style="width: 40px;" value="<%=BasicSetupBLL.Read("TimeDiff") %>" />
                    <em>* (-12.0至+12.0之间的小数)</em>
                </td>
            </tr>
            <tr>
                <th><label for="beian">备案信息</label></th>
                <td>
                    <input type="text" id="beian" name="beian" maxlength="50" style="width: 150px;" value="<%=BasicSetupBLL.Read("Beian") %>" />
                    <em>(50个字以内，<a href="http://www.miibeian.gov.cn/" target="_blank">点击此处进行备案</a>)</em>
                </td>
            </tr>
            <tr>
                <th><label for="counter">统计器代码</label></th>
                <td>
                    <textarea id="counter" name="counter" rows="3" cols="80" style="width: 350px; height: 60px;"><%=BasicSetupBLL.Read("Counter") %></textarea>
                    <br /><em>(您可以把从其他网站申请的统计器代码粘贴在此处)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[									  
(function() {

var validator = new $.validate.FormValidator($("form")[0]);
validator.addRules("blogName", ["noempty", "", "博客名不能为空"]);
validator.addRules("domain", [function(value) {
	if (value != "") { return !/<|>|"|'/.test(value); }
}, "域名不能包含Html特殊字符"]);
validator.addRules("forbiddenIPs", [function(value) {
	if (value != "") {
		var ipRe = /^\d{1,3}(\.\d{1,3}){3}$/;
		value = value.split(/[\r\n]+/);
		for (var i = 0; i < value.length; i++) {
			if (!ipRe.test(value[i])) { return false; }
		}
	}
}, "非法的IP值"]);
validator.addRules("timeDiff", ["min", -12, "时差不能小于-12.0"], ["max", 12, "时差不能大于12.0"]);

$("#blogName").focus();

})()
//]]></script>